/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.decorative;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.decorative.StreetLight;
import com.silvaniastudios.roads.blocks.enums.IPostConnectable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MetalPost
extends BlockBase
implements IPostConnectable {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    boolean horizontal = false;
    double thickness = 0.0;

    public MetalPost(String name, boolean horizontal, double thickness) {
        super(name, Material.field_151573_f);
        this.horizontal = horizontal;
        this.thickness = thickness;
        this.func_149647_a(FurenikusRoads.tab_road_parts);
        this.func_149711_c(2.0f);
        this.setDefaultState();
        this.field_149783_u = true;
    }

    public void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPostConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPostConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPostConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPostConnectTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canPostConnectTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.getBlockBelowOffset(worldIn, pos)));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (facing == EnumFacing.DOWN && !block.equals(Blocks.field_150350_a)) {
            return true;
        }
        if (this.horizontal && block.func_193383_a(worldIn, state, pos, facing.func_176734_d()) == BlockFaceShape.SOLID || block instanceof MetalPost || block instanceof StreetLight) {
            return true;
        }
        if (block instanceof MetalPost || block instanceof StreetLight) {
            MetalPost post = (MetalPost)block;
            return post.horizontal;
        }
        return false;
    }

    private boolean canPostConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.canConnectTo(world, offset, facing.func_176734_d());
    }

    public boolean getBlockBelowOffset(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e != 1.0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBoxFromState(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBoxFromState(state, world, pos);
    }

    public AxisAlignedBB getBoxFromState(IBlockState state, IBlockAccess world, BlockPos pos) {
        double widthOffset = this.thickness / 2.0;
        boolean north = this.canPostConnectTo(world, pos, EnumFacing.NORTH);
        boolean east = this.canPostConnectTo(world, pos, EnumFacing.EAST);
        boolean south = this.canPostConnectTo(world, pos, EnumFacing.SOUTH);
        boolean west = this.canPostConnectTo(world, pos, EnumFacing.WEST);
        boolean up = this.canPostConnectTo(world, pos, EnumFacing.UP);
        double xLow = 0.0;
        double yLow = 0.0;
        double zLow = 0.0;
        double xHigh = 1.0;
        double yHigh = 1.0;
        double zHigh = 1.0;
        zLow = north ? 0.0 : 0.5 - widthOffset;
        xHigh = east ? 1.0 : 0.5 + widthOffset;
        zHigh = south ? 1.0 : 0.5 + widthOffset;
        xLow = west ? 0.0 : 0.5 - widthOffset;
        if (this.horizontal) {
            yLow = 0.5 - widthOffset;
            yHigh = 0.5 + widthOffset;
        } else {
            if ((north || east || south || west) && !up) {
                yHigh = 0.5 + widthOffset;
            }
            if (!north && !east && !south && !west || up) {
                yHigh = 1.0;
            }
        }
        if (this.getBlockBelowOffset(world, pos)) {
            yLow = -0.935;
        }
        return new AxisAlignedBB(xLow, yLow, zLow, xHigh, yHigh, zHigh);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

