/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.decorative;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.decorative.CurbBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.items.FRItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BarrierEdgeBlock
extends BlockBase {
    public static final PropertyEnum<EnumBarrierRotation> ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumBarrierRotation.class);
    public static final PropertyEnum<EnumBarrierSide> LEFT = PropertyEnum.func_177709_a((String)"left", EnumBarrierSide.class);
    public static final PropertyEnum<EnumBarrierSide> RIGHT = PropertyEnum.func_177709_a((String)"right", EnumBarrierSide.class);
    public static final PropertyBool POSTS = PropertyBool.func_177716_a((String)"zpost");
    boolean double_sided;
    AxisAlignedBB SOUTH_AABB = field_185505_j;
    AxisAlignedBB WEST_AABB = field_185505_j;
    AxisAlignedBB NORTH_AABB = field_185505_j;
    AxisAlignedBB EAST_AABB = field_185505_j;
    AxisAlignedBB FULL_AABB = field_185505_j;

    public BarrierEdgeBlock(String name, boolean double_sided) {
        super(name, Material.field_151573_f);
        this.double_sided = double_sided;
        this.func_149647_a(FurenikusRoads.tab_road_parts);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ROTATION, (Comparable)((Object)EnumBarrierRotation.NORTH)).func_177226_a(LEFT, (Comparable)((Object)EnumBarrierSide.NORMAL)).func_177226_a(RIGHT, (Comparable)((Object)EnumBarrierSide.NORMAL)).func_177226_a((IProperty)POSTS, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() == FRItems.wrench) {
            if (this.func_176201_c(state) > 3) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POSTS, (Comparable)Boolean.valueOf(false)));
            } else {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POSTS, (Comparable)Boolean.valueOf(true)));
            }
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rot = 0;
        if (placer.func_174811_aO().equals((Object)EnumFacing.EAST)) {
            rot = 1;
        }
        if (placer.func_174811_aO().equals((Object)EnumFacing.SOUTH)) {
            rot = 2;
        }
        if (placer.func_174811_aO().equals((Object)EnumFacing.WEST)) {
            rot = 3;
        }
        return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta + rot, placer);
    }

    public IBlockState func_176203_a(int meta) {
        boolean post = false;
        if (meta > 3) {
            post = true;
            meta -= 4;
        }
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumBarrierRotation.byMetadata(meta))).func_177226_a((IProperty)POSTS, (Comparable)Boolean.valueOf(post));
    }

    public int func_176201_c(IBlockState state) {
        EnumBarrierRotation rot = (EnumBarrierRotation)((Object)state.func_177229_b(ROTATION));
        int post = (Boolean)state.func_177229_b((IProperty)POSTS) != false ? 4 : 0;
        return rot.getMetadata() + post;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private EnumBarrierSide canBarrierConnectTo(IBlockState state, IBlockAccess world, BlockPos pos, boolean checkingLeft) {
        EnumBarrierRotation thisRot = (EnumBarrierRotation)((Object)state.func_177229_b(ROTATION));
        EnumFacing up = EnumFacing.NORTH;
        EnumFacing left = EnumFacing.WEST;
        EnumFacing right = EnumFacing.EAST;
        EnumFacing down = EnumFacing.SOUTH;
        EnumBarrierRotation wrLeft = EnumBarrierRotation.WEST;
        EnumBarrierRotation wrRight = EnumBarrierRotation.EAST;
        if (thisRot.equals((Object)EnumBarrierRotation.NORTH)) {
            up = EnumFacing.NORTH;
            left = EnumFacing.WEST;
            right = EnumFacing.EAST;
            down = EnumFacing.SOUTH;
            wrLeft = EnumBarrierRotation.WEST;
            wrRight = EnumBarrierRotation.EAST;
        }
        if (thisRot.equals((Object)EnumBarrierRotation.EAST)) {
            up = EnumFacing.EAST;
            left = EnumFacing.NORTH;
            right = EnumFacing.SOUTH;
            down = EnumFacing.WEST;
            wrLeft = EnumBarrierRotation.NORTH;
            wrRight = EnumBarrierRotation.SOUTH;
        }
        if (thisRot.equals((Object)EnumBarrierRotation.SOUTH)) {
            up = EnumFacing.SOUTH;
            left = EnumFacing.EAST;
            right = EnumFacing.WEST;
            down = EnumFacing.NORTH;
            wrLeft = EnumBarrierRotation.EAST;
            wrRight = EnumBarrierRotation.WEST;
        }
        if (thisRot.equals((Object)EnumBarrierRotation.WEST)) {
            up = EnumFacing.WEST;
            left = EnumFacing.SOUTH;
            right = EnumFacing.NORTH;
            down = EnumFacing.EAST;
            wrLeft = EnumBarrierRotation.SOUTH;
            wrRight = EnumBarrierRotation.NORTH;
        }
        IBlockState stateUp = world.func_180495_p(pos.func_177972_a(up));
        IBlockState stateLeft = world.func_180495_p(pos.func_177972_a(left));
        IBlockState stateRight = world.func_180495_p(pos.func_177972_a(right));
        IBlockState stateDown = world.func_180495_p(pos.func_177972_a(down));
        boolean upBlock = stateUp.func_177230_c() instanceof BarrierEdgeBlock;
        boolean leftBlock = stateLeft.func_177230_c() instanceof BarrierEdgeBlock;
        boolean rightBlock = stateRight.func_177230_c() instanceof BarrierEdgeBlock;
        boolean downBlock = stateDown.func_177230_c() instanceof BarrierEdgeBlock;
        if (upBlock && leftBlock && ((EnumBarrierRotation)((Object)stateUp.func_177229_b(ROTATION))).equals((Object)wrLeft) && ((EnumBarrierRotation)((Object)stateLeft.func_177229_b(ROTATION))).equals((Object)thisRot)) {
            if (checkingLeft) {
                return EnumBarrierSide.CORNER;
            }
            return EnumBarrierSide.NONE;
        }
        if (upBlock && rightBlock && ((EnumBarrierRotation)((Object)stateUp.func_177229_b(ROTATION))).equals((Object)wrRight) && ((EnumBarrierRotation)((Object)stateRight.func_177229_b(ROTATION))).equals((Object)thisRot)) {
            if (checkingLeft) {
                return EnumBarrierSide.NONE;
            }
            return EnumBarrierSide.CORNER;
        }
        if (downBlock && !leftBlock && !upBlock && checkingLeft && ((EnumBarrierRotation)((Object)stateDown.func_177229_b(ROTATION))).equals((Object)wrLeft)) {
            return EnumBarrierSide.DOWN;
        }
        if (downBlock && !rightBlock && !upBlock && !checkingLeft && ((EnumBarrierRotation)((Object)stateDown.func_177229_b(ROTATION))).equals((Object)wrRight)) {
            return EnumBarrierSide.DOWN;
        }
        return EnumBarrierSide.NORMAL;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumBarrierSide left = this.canBarrierConnectTo(state, world, pos, true);
        EnumBarrierSide right = this.canBarrierConnectTo(state, world, pos, false);
        return state.func_177226_a(LEFT, (Comparable)((Object)left)).func_177226_a(RIGHT, (Comparable)((Object)right));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, LEFT, RIGHT, POSTS});
    }

    public void setBoxes(IBlockAccess world, BlockPos pos) {
        this.SOUTH_AABB = new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.875, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.25, 1.0);
        this.WEST_AABB = new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 0.125, -1.0 + this.getBlockBelowHeight(world, pos) + 1.25, 1.0);
        this.NORTH_AABB = new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.25, 0.125);
        this.EAST_AABB = new AxisAlignedBB(0.875, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.25, 1.0);
        this.FULL_AABB = new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.25, 1.0);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        int meta;
        this.setBoxes((IBlockAccess)world, pos);
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        boolean n = (meta = this.func_176201_c(state)) == 0 || meta == 4;
        boolean e = meta == 1 || meta == 5;
        boolean s = meta == 2 || meta == 6;
        boolean w = meta == 3 || meta == 7;
        EnumBarrierSide left = (EnumBarrierSide)((Object)state.func_177229_b(LEFT));
        EnumBarrierSide right = (EnumBarrierSide)((Object)state.func_177229_b(RIGHT));
        if (this.double_sided) {
            if (n) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    w = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    e = true;
                }
                if (!left.equals((Object)EnumBarrierSide.DOWN) && !right.equals((Object)EnumBarrierSide.DOWN)) {
                    s = true;
                }
            } else if (e) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    n = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    s = true;
                }
                if (!left.equals((Object)EnumBarrierSide.DOWN) && !right.equals((Object)EnumBarrierSide.DOWN)) {
                    w = true;
                }
            } else if (s) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    e = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    w = true;
                }
                if (!left.equals((Object)EnumBarrierSide.DOWN) && !right.equals((Object)EnumBarrierSide.DOWN)) {
                    n = true;
                }
            } else if (w) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    s = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    n = true;
                }
                if (!left.equals((Object)EnumBarrierSide.DOWN) && !right.equals((Object)EnumBarrierSide.DOWN)) {
                    e = true;
                }
            }
        } else {
            if (n) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    w = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    e = true;
                }
            } else if (e) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    n = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    s = true;
                }
            } else if (s) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    e = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    w = true;
                }
            } else if (w) {
                if (left.equals((Object)EnumBarrierSide.DOWN)) {
                    s = true;
                }
                if (right.equals((Object)EnumBarrierSide.DOWN)) {
                    n = true;
                }
            }
            if (n && (left.equals((Object)EnumBarrierSide.CORNER) || right.equals((Object)EnumBarrierSide.CORNER))) {
                n = false;
            }
            if (e && (left.equals((Object)EnumBarrierSide.CORNER) || right.equals((Object)EnumBarrierSide.CORNER))) {
                e = false;
            }
            if (s && (left.equals((Object)EnumBarrierSide.CORNER) || right.equals((Object)EnumBarrierSide.CORNER))) {
                s = false;
            }
            if (w && (left.equals((Object)EnumBarrierSide.CORNER) || right.equals((Object)EnumBarrierSide.CORNER))) {
                w = false;
            }
        }
        if (n) {
            BarrierEdgeBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.NORTH_AABB);
        }
        if (e) {
            BarrierEdgeBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.EAST_AABB);
        }
        if (s) {
            BarrierEdgeBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.SOUTH_AABB);
        }
        if (w) {
            BarrierEdgeBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        this.setBoxes(world, pos);
        int meta = this.func_176201_c(state);
        boolean n = meta == 0 || meta == 4;
        boolean e = meta == 1 || meta == 5;
        boolean s = meta == 2 || meta == 6;
        boolean w = meta == 3 || meta == 7;
        state = state.func_185899_b(world, pos);
        EnumBarrierSide left = (EnumBarrierSide)((Object)state.func_177229_b(LEFT));
        EnumBarrierSide right = (EnumBarrierSide)((Object)state.func_177229_b(RIGHT));
        if (this.double_sided) {
            return this.FULL_AABB;
        }
        if (n && left.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (n && right.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (e && left.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (e && right.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (s && left.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (s && right.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (w && left.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (w && right.equals((Object)EnumBarrierSide.DOWN)) {
            return this.FULL_AABB;
        }
        if (n && left.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 0.125, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 0.125);
        }
        if (n && right.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.875, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 0.125);
        }
        if (e && left.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.875, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 0.125);
        }
        if (e && right.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.875, -1.0 + this.getBlockBelowHeight(world, pos), 0.875, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
        }
        if (s && left.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.875, -1.0 + this.getBlockBelowHeight(world, pos), 0.875, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
        }
        if (s && right.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.875, 0.125, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
        }
        if (w && left.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.875, 0.125, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
        }
        if (w && right.equals((Object)EnumBarrierSide.CORNER)) {
            return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 0.125, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 0.125);
        }
        if (n) {
            return this.NORTH_AABB;
        }
        if (e) {
            return this.EAST_AABB;
        }
        if (s) {
            return this.SOUTH_AABB;
        }
        if (w) {
            return this.WEST_AABB;
        }
        return this.FULL_AABB;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offset = 1.0 - this.getBlockBelowHeight(worldIn, pos);
        return new Vec3d(0.0, -offset, 0.0);
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumBarrierRotation implements IStringSerializable
    {
        NORTH(0, "north"),
        EAST(1, "east"),
        SOUTH(2, "south"),
        WEST(3, "west");

        private static final EnumBarrierRotation[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumBarrierRotation(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumBarrierRotation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumBarrierRotation[EnumBarrierRotation.values().length];
            EnumBarrierRotation[] enumBarrierRotationArray = EnumBarrierRotation.values();
            int n = enumBarrierRotationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBarrierRotation type;
                EnumBarrierRotation.META_LOOKUP[type.getMetadata()] = type = enumBarrierRotationArray[i];
            }
        }
    }

    public static enum EnumBarrierSide implements IStringSerializable
    {
        NORMAL(0, "normal"),
        DOWN(1, "down"),
        CORNER(2, "corner"),
        NONE(3, "none");

        private static final EnumBarrierSide[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumBarrierSide(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumBarrierSide byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumBarrierSide[EnumBarrierSide.values().length];
            EnumBarrierSide[] enumBarrierSideArray = EnumBarrierSide.values();
            int n = enumBarrierSideArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBarrierSide type;
                EnumBarrierSide.META_LOOKUP[type.getMetadata()] = type = enumBarrierSideArray[i];
            }
        }
    }
}

