/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.IngameListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class GroupScreen
extends IngameListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    protected static final ResourceLocation LEAVE = new ResourceLocation("voicechat", "textures/icons/leave.png");
    protected static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    protected static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    protected static final ResourceLocation GROUP_HUD = new ResourceLocation("voicechat", "textures/icons/group_hud_button.png");
    protected static final ITextComponent TITLE = new TextComponentTranslation("gui.voicechat.group.title", new Object[0]);
    protected static final ITextComponent LEAVE_GROUP = new TextComponentTranslation("message.voicechat.leave_group", new Object[0]);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected GroupList groupList;
    protected int units;
    protected final ClientGroup group;
    protected ToggleImageButton mute;
    protected ToggleImageButton disable;
    protected ToggleImageButton showHUD;
    protected ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super(TITLE, 236, 0);
        this.group = group;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = MathHelper.func_76123_f((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_146295_m - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        this.groupList = new GroupList(this, this.field_146294_l, this.units * 18, this.guiTop + 16, 36);
        this.setList(this.groupList);
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.mute = new ToggleImageButton(0, this.guiLeft + 7, buttonY, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.func_189646_b(this.mute);
        this.disable = new ToggleImageButton(1, this.guiLeft + 7 + buttonSize + 3, buttonY, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.func_189646_b(this.disable);
        this.showHUD = new ToggleImageButton(2, this.guiLeft + 7 + (buttonSize + 3) * 2, buttonY, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHUD::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHUD.set(VoicechatClient.CLIENT_CONFIG.showGroupHUD.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.func_189646_b(this.showHUD);
        this.leave = new ImageButton(3, this.guiLeft + this.xSize - buttonSize - 7, buttonY, LEAVE, button -> {
            NetManager.sendToServer(new LeaveGroupPacket());
            this.field_146297_k.func_147108_a((GuiScreen)new JoinGroupScreen());
        }, (button, mouseX, mouseY) -> this.func_146279_a(LEAVE_GROUP.func_150261_e(), mouseX, mouseY));
        this.func_189646_b(this.leave);
        this.checkButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.mute != null) {
            this.mute.field_146124_l = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        }
        if (this.showHUD != null) {
            this.showHUD.field_146124_l = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
        }
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float delta) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.func_73729_b(this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.func_73729_b(this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.func_73729_b(this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float delta) {
        TextComponentTranslation title = this.group.getType().equals(Group.Type.NORMAL) ? new TextComponentTranslation("message.voicechat.group_title", new Object[]{new TextComponentString(this.group.getName())}) : new TextComponentTranslation("message.voicechat.group_type_title", new Object[]{new TextComponentString(this.group.getName()), GroupType.fromType(this.group.getType()).getTranslation()});
        this.field_146289_q.func_78276_b(title.func_150254_d(), this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(title.func_150261_e()) / 2, this.guiTop + 5, 0x404040);
    }
}

