/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser.expression;

import java.util.ArrayList;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionFloat;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.parser.expression.ParsedExpressionAndAnd;
import stanhebben.zenscript.parser.expression.ParsedExpressionArray;
import stanhebben.zenscript.parser.expression.ParsedExpressionAssign;
import stanhebben.zenscript.parser.expression.ParsedExpressionBinary;
import stanhebben.zenscript.parser.expression.ParsedExpressionBool;
import stanhebben.zenscript.parser.expression.ParsedExpressionCall;
import stanhebben.zenscript.parser.expression.ParsedExpressionCast;
import stanhebben.zenscript.parser.expression.ParsedExpressionCompare;
import stanhebben.zenscript.parser.expression.ParsedExpressionConditional;
import stanhebben.zenscript.parser.expression.ParsedExpressionFunction;
import stanhebben.zenscript.parser.expression.ParsedExpressionIndex;
import stanhebben.zenscript.parser.expression.ParsedExpressionIndexSet;
import stanhebben.zenscript.parser.expression.ParsedExpressionInstanceOf;
import stanhebben.zenscript.parser.expression.ParsedExpressionInvalid;
import stanhebben.zenscript.parser.expression.ParsedExpressionMap;
import stanhebben.zenscript.parser.expression.ParsedExpressionMember;
import stanhebben.zenscript.parser.expression.ParsedExpressionNull;
import stanhebben.zenscript.parser.expression.ParsedExpressionOpAssign;
import stanhebben.zenscript.parser.expression.ParsedExpressionOrOr;
import stanhebben.zenscript.parser.expression.ParsedExpressionUnary;
import stanhebben.zenscript.parser.expression.ParsedExpressionValue;
import stanhebben.zenscript.parser.expression.ParsedExpressionVariable;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeDouble;
import stanhebben.zenscript.type.ZenTypeFloat;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.ZenTypeLong;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public abstract class ParsedExpression {
    private final ZenPosition position;

    public ParsedExpression(ZenPosition position) {
        this.position = position;
    }

    public static ParsedExpression read(ZenTokener parser, IEnvironmentGlobal environment) {
        return ParsedExpression.readAssignExpression(parser, environment);
    }

    private static ParsedExpression readAssignExpression(ZenTokener parser, IEnvironmentGlobal environment) {
        Token token = parser.peek();
        if (token == null) {
            ZenPosition position = new ZenPosition(parser.getFile(), parser.getLine(), parser.getLineOffset(), parser.getFile().getFileName());
            environment.error(position, "unexpected end of file; expression expected");
            return new ParsedExpressionInvalid(position);
        }
        ZenPosition position = token.getPosition();
        ParsedExpression left = ParsedExpression.readConditionalExpression(position, parser, environment);
        if (parser.peek() == null) {
            ZenPosition position2 = new ZenPosition(parser.getFile(), parser.getLine(), parser.getLineOffset(), parser.getFile().getFileName());
            environment.error(position2, "unexpected end of file - ; expected");
            return new ParsedExpressionInvalid(position2);
        }
        switch (parser.peek().getType()) {
            case 39: {
                parser.next();
                return new ParsedExpressionAssign(position, left, ParsedExpression.readAssignExpression(parser, environment));
            }
            case 12: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.ADD);
            }
            case 14: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.SUB);
            }
            case 45: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.CAT);
            }
            case 16: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.MUL);
            }
            case 18: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.DIV);
            }
            case 20: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.MOD);
            }
            case 22: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.OR);
            }
            case 24: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.AND);
            }
            case 26: {
                parser.next();
                return new ParsedExpressionOpAssign(position, left, ParsedExpression.readAssignExpression(parser, environment), OperatorType.XOR);
            }
        }
        return left;
    }

    private static ParsedExpression readConditionalExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readOrOrExpression(position, parser, environment);
        if (parser.optional(28) != null) {
            ParsedExpression onIf = ParsedExpression.readOrOrExpression(parser.peek().getPosition(), parser, environment);
            parser.required(29, ": expected");
            ParsedExpression onElse = ParsedExpression.readConditionalExpression(parser.peek().getPosition(), parser, environment);
            return new ParsedExpressionConditional(position, left, onIf, onElse);
        }
        return left;
    }

    private static ParsedExpression readOrOrExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readAndAndExpression(position, parser, environment);
        while (parser.optional(40) != null) {
            ParsedExpression right = ParsedExpression.readAndAndExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionOrOr(position, left, right);
        }
        return left;
    }

    private static ParsedExpression readAndAndExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readOrExpression(position, parser, environment);
        while (parser.optional(41) != null) {
            ParsedExpression right = ParsedExpression.readOrExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionAndAnd(position, left, right);
        }
        return left;
    }

    private static ParsedExpression readOrExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readXorExpression(position, parser, environment);
        while (parser.optional(23) != null) {
            ParsedExpression right = ParsedExpression.readXorExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.OR);
        }
        return left;
    }

    private static ParsedExpression readXorExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readAndExpression(position, parser, environment);
        while (parser.optional(27) != null) {
            ParsedExpression right = ParsedExpression.readAndExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.XOR);
        }
        return left;
    }

    private static ParsedExpression readAndExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readCompareExpression(position, parser, environment);
        while (parser.optional(25) != null) {
            ParsedExpression right = ParsedExpression.readCompareExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.AND);
        }
        return left;
    }

    private static ParsedExpression readCompareExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readAddExpression(position, parser, environment);
        switch (parser.peek() == null ? -1 : parser.peek().getType()) {
            case 38: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.EQ);
            }
            case 42: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.NE);
            }
            case 35: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.LT);
            }
            case 34: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.LE);
            }
            case 37: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.GT);
            }
            case 36: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionCompare(position, left, right, CompareType.GE);
            }
            case 109: {
                parser.next();
                ParsedExpression right = ParsedExpression.readAddExpression(parser.peek().getPosition(), parser, environment);
                return new ParsedExpressionBinary(position, left, right, OperatorType.CONTAINS);
            }
        }
        return left;
    }

    private static ParsedExpression readAddExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readMulExpression(position, parser, environment);
        while (true) {
            ParsedExpression right;
            if (parser.optional(13) != null) {
                right = ParsedExpression.readMulExpression(parser.peek().getPosition(), parser, environment);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.ADD);
                continue;
            }
            if (parser.optional(15) != null) {
                right = ParsedExpression.readMulExpression(parser.peek().getPosition(), parser, environment);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.SUB);
                continue;
            }
            if (parser.optional(32) == null) break;
            right = ParsedExpression.readMulExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.CAT);
        }
        return left;
    }

    private static ParsedExpression readMulExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        ParsedExpression left = ParsedExpression.readUnaryExpression(position, parser, environment);
        while (true) {
            ParsedExpression right;
            if (parser.optional(17) != null) {
                right = ParsedExpression.readUnaryExpression(parser.peek().getPosition(), parser, environment);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.MUL);
                continue;
            }
            if (parser.optional(19) != null) {
                right = ParsedExpression.readUnaryExpression(parser.peek().getPosition(), parser, environment);
                left = new ParsedExpressionBinary(position, left, right, OperatorType.DIV);
                continue;
            }
            if (parser.optional(21) == null) break;
            right = ParsedExpression.readUnaryExpression(parser.peek().getPosition(), parser, environment);
            left = new ParsedExpressionBinary(position, left, right, OperatorType.MOD);
        }
        return left;
    }

    private static ParsedExpression readUnaryExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        switch (parser.peek().getType()) {
            case 43: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.peek().getPosition(), parser, environment), OperatorType.NOT);
            }
            case 15: {
                parser.next();
                return new ParsedExpressionUnary(position, ParsedExpression.readUnaryExpression(parser.peek().getPosition(), parser, environment), OperatorType.NEG);
            }
        }
        return ParsedExpression.readPostfixExpression(position, parser, environment);
    }

    private static ParsedExpression readPostfixExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        Token next;
        ParsedExpression base = ParsedExpression.readPrimaryExpression(position, parser, environment);
        while ((next = parser.peek()) != null) {
            ZenType type;
            if (parser.optional(10) != null) {
                Token indexString = parser.optional(1, 121, 107);
                if (indexString != null) {
                    base = new ParsedExpressionMember(position, base, indexString.getValue());
                    continue;
                }
                Token indexString2 = parser.optional(4);
                if (indexString2 != null) {
                    base = new ParsedExpressionMember(position, base, StringUtil.unescapeString(indexString2.getValue()));
                    continue;
                }
                Token last = parser.next();
                throw new ParseException(last, "Invalid expression, last token: " + last.getValue());
            }
            if (next.getType() == 9 || next.getType() == 1 && next.getValue().equals("to")) {
                parser.next();
                ParsedExpression to = ParsedExpression.readAssignExpression(parser, environment);
                return new ParsedExpressionBinary(position, base, to, OperatorType.RANGE);
            }
            if (parser.optional(7) != null) {
                ParsedExpression index = ParsedExpression.readAssignExpression(parser, environment);
                parser.required(8, "] expected");
                if (parser.optional(39) != null) {
                    ParsedExpression newVal = ParsedExpression.readAssignExpression(parser, environment);
                    base = new ParsedExpressionIndexSet(position, base, index, newVal);
                    continue;
                }
                base = new ParsedExpressionIndex(position, base, index);
                continue;
            }
            if (parser.optional(30) != null) {
                ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>();
                if (parser.optional(31) == null) {
                    arguments.add(ParsedExpression.readAssignExpression(parser, environment));
                    while (parser.optional(11) != null) {
                        arguments.add(ParsedExpression.readAssignExpression(parser, environment));
                    }
                    parser.required(31, ") expected");
                }
                base = new ParsedExpressionCall(position, base, arguments);
                continue;
            }
            if (parser.optional(120) != null) {
                type = ZenType.read(parser, environment);
                base = new ParsedExpressionCast(position, base, type);
                continue;
            }
            if (parser.optional(668) == null) break;
            type = ZenType.read(parser, environment);
            base = new ParsedExpressionInstanceOf(position, base, type);
        }
        return base;
    }

    private static ParsedExpression readPrimaryExpression(ZenPosition position, ZenTokener parser, IEnvironmentGlobal environment) {
        switch (parser.peek().getType()) {
            case 2: {
                long l;
                String number = parser.next().getValue();
                ZenType numberType = ZenTypeInt.INSTANCE;
                if (number.endsWith("l") || number.endsWith("L")) {
                    numberType = ZenTypeLong.INSTANCE;
                    number = number.substring(0, number.length() - 1);
                }
                if ((long)((int)(l = Long.decode(number).longValue())) != l) {
                    numberType = ZenTypeLong.INSTANCE;
                }
                return new ParsedExpressionValue(position, new ExpressionInt(position, l, numberType));
            }
            case 3: {
                String value = parser.next().getValue();
                ZenType zenType = ZenTypeDouble.INSTANCE;
                if (value.endsWith("f") || value.endsWith("F")) {
                    zenType = ZenTypeFloat.INSTANCE;
                    value = value.substring(0, value.length() - 1);
                }
                return new ParsedExpressionValue(position, new ExpressionFloat(position, Double.parseDouble(value), zenType));
            }
            case 4: {
                return new ParsedExpressionValue(position, new ExpressionString(position, StringUtil.unescapeString(parser.next().getValue())));
            }
            case 1: {
                return new ParsedExpressionVariable(position, parser.next().getValue());
            }
            case 108: {
                parser.next();
                parser.required(30, "( expected");
                ArrayList<ParsedFunctionArgument> arguments = new ArrayList<ParsedFunctionArgument>();
                if (parser.optional(31) == null) {
                    do {
                        String name = parser.required(1, "identifier expected").getValue();
                        ZenType type = ZenTypeAny.INSTANCE;
                        ParsedExpression defaultExpression = null;
                        if (parser.optional(120) != null) {
                            type = ZenType.read(parser, environment);
                        }
                        if (parser.optional(39) != null) {
                            defaultExpression = ParsedExpression.read(parser, environment);
                        }
                        arguments.add(new ParsedFunctionArgument(name, type, defaultExpression));
                    } while (parser.optional(11) != null);
                    parser.required(31, ") expected");
                }
                ZenType returnType = ZenTypeAny.INSTANCE;
                if (parser.optional(120) != null) {
                    returnType = ZenType.read(parser, environment);
                }
                parser.required(5, "{ expected");
                ArrayList<Statement> statements = new ArrayList<Statement>();
                if (parser.optional(6) == null) {
                    while (parser.optional(6) == null) {
                        statements.add(Statement.read(parser, environment, returnType));
                    }
                }
                return new ParsedExpressionFunction(position, returnType, arguments, statements);
            }
            case 35: {
                Token start = parser.next();
                ArrayList<Token> tokens = new ArrayList<Token>();
                Token next = parser.next();
                while (next.getType() != 37) {
                    tokens.add(next);
                    next = parser.next();
                }
                IZenSymbol resolved = parser.getEnvironment().getBracketed(environment, tokens);
                if (resolved == null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append('<');
                    Token last = null;
                    for (Token token : tokens) {
                        if (last != null) {
                            builder.append(' ');
                        }
                        builder.append(token.getValue());
                        last = token;
                    }
                    builder.append('>');
                    if (!parser.ignoreBracketErrors) {
                        parser.getEnvironment().getErrorLogger().error(start.getPosition(), "Could not resolve " + builder.toString());
                    } else {
                        parser.getEnvironment().getErrorLogger().info(start.getPosition(), "Could not resolve " + builder.toString());
                    }
                    return new ParsedExpressionInvalid(start.getPosition());
                }
                return new ParsedExpressionValue(start.getPosition(), parser.getEnvironment().getBracketed(environment, tokens).instance(start.getPosition()));
            }
            case 7: {
                parser.next();
                ArrayList<ParsedExpression> contents = new ArrayList<ParsedExpression>();
                if (parser.optional(8) == null) {
                    while (parser.optional(8) == null) {
                        contents.add(ParsedExpression.readAssignExpression(parser, environment));
                        if (parser.optional(11) != null) continue;
                        parser.required(8, "] or , expected");
                        break;
                    }
                }
                return new ParsedExpressionArray(position, contents);
            }
            case 5: {
                parser.next();
                ArrayList<ParsedExpression> keys = new ArrayList<ParsedExpression>();
                ArrayList<ParsedExpression> values = new ArrayList<ParsedExpression>();
                if (parser.optional(6) == null) {
                    while (parser.optional(6) == null) {
                        keys.add(ParsedExpression.readAssignExpression(parser, environment));
                        parser.required(29, ": expected");
                        values.add(ParsedExpression.readAssignExpression(parser, environment));
                        if (parser.optional(11) != null) continue;
                        parser.required(6, "} or , expected");
                        break;
                    }
                }
                return new ParsedExpressionMap(position, keys, values);
            }
            case 141: {
                parser.next();
                return new ParsedExpressionBool(position, true);
            }
            case 142: {
                parser.next();
                return new ParsedExpressionBool(position, false);
            }
            case 140: {
                parser.next();
                return new ParsedExpressionNull(position);
            }
            case 30: {
                parser.next();
                ParsedExpression result = ParsedExpression.readAssignExpression(parser, environment);
                parser.required(31, ") expected");
                return result;
            }
        }
        Token last = parser.next();
        throw new ParseException(last, "Invalid expression, last token: " + last.getValue());
    }

    public ZenPosition getPosition() {
        return this.position;
    }

    public abstract IPartialExpression compile(IEnvironmentMethod var1, ZenType var2);

    public Expression compileKey(IEnvironmentMethod environment, ZenType predictedType) {
        return this.compile(environment, predictedType).eval(environment);
    }
}

