/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiatrader.schedulers;

import bletch.common.schedulers.IScheduler;
import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiatrader.core.ModConfig;
import bletch.tektopiatrader.entities.EntityTrader;
import bletch.tektopiatrader.utils.LoggerUtils;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.tangotek.tektopia.Village;

public class TraderScheduler
implements IScheduler {
    protected Boolean checkedVillages = false;
    protected Boolean resetNight = false;

    @Override
    public void resetDay() {
    }

    @Override
    public void resetNight() {
        if (this.resetNight.booleanValue()) {
            return;
        }
        LoggerUtils.instance.info("TraderScheduler - resetNight called", true);
        this.checkedVillages = false;
        this.resetNight = true;
    }

    @Override
    public void update(World world) {
        if (this.checkedVillages.booleanValue() || world == null || world.func_72896_J() || !EntityTrader.isWorkTime(world, 0)) {
            return;
        }
        LoggerUtils.instance.info("TraderScheduler - update called", true);
        this.resetNight = false;
        this.checkedVillages = true;
        List<Village> villages = TektopiaUtils.getVillages(world);
        if (villages == null || villages.isEmpty()) {
            return;
        }
        villages.forEach(v -> {
            int villageCheck;
            String villageName = v.getName();
            int villageLevel = TektopiaUtils.getVillageLevel(v);
            int n = villageCheck = ModConfig.trader.checksVillageSize != false ? world.field_73012_v.nextInt(villageLevel) : 0;
            if (villageLevel > 0 && villageCheck == 0) {
                LoggerUtils.instance.info(TextUtils.translate("message.trader.villagechecksuccess", villageName, villageLevel, villageCheck), true);
                List entityList = world.func_72872_a(EntityTrader.class, v.getAABB().func_186662_g(120.0));
                if (entityList.size() == 0) {
                    BlockPos spawnPosition = TektopiaUtils.getVillageSpawnPoint(world, v);
                    if (TektopiaUtils.trySpawnEntity(world, spawnPosition, w -> new EntityTrader((World)w)).booleanValue()) {
                        v.sendChatMessage((ITextComponent)new TextComponentTranslation("message.trader.spawned", new Object[0]));
                        LoggerUtils.instance.info(TextUtils.translate("message.trader.spawned.village", villageName, TektopiaUtils.formatBlockPos(spawnPosition)), true);
                    } else {
                        LoggerUtils.instance.info(TextUtils.translate("message.trader.noposition.village", villageName), true);
                    }
                } else {
                    LoggerUtils.instance.info(TextUtils.translate("message.trader.exists", villageName), true);
                }
            } else {
                LoggerUtils.instance.info(TextUtils.translate("message.trader.villagecheckfailed", villageName, villageLevel, villageCheck), true);
            }
        });
    }
}

