/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiatrader;

import bletch.common.schedulers.ScheduleManager;
import bletch.tektopiatrader.commands.TraderCommands;
import bletch.tektopiatrader.core.ModCommonProxy;
import bletch.tektopiatrader.core.ModEntities;
import bletch.tektopiatrader.schedulers.TraderScheduler;
import bletch.tektopiatrader.utils.LoggerUtils;
import com.leviathanstudio.craftstudio.client.registry.CraftStudioLoader;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="tektopiatrader", name="TektopiaTrader", version="1.4.0", dependencies="required-after:minecraft@[1.12.2];required-after:forge@[14.23.5.2768,);required-after:tektopia@[1.0.0,);before:tektopiainformation", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/Bletch1971/TektopiaTrader/master/1.0/updateforge.json")
@ParametersAreNonnullByDefault
public class TektopiaTrader {
    @Mod.Instance(value="tektopiatrader")
    public static TektopiaTrader instance;
    @SidedProxy(clientSide="bletch.tektopiatrader.core.ModClientProxy", serverSide="bletch.tektopiatrader.core.ModCommonProxy")
    public static ModCommonProxy proxy;
    public static ScheduleManager scheduleManager;

    @Mod.EventHandler
    public void preInitialize(FMLPreInitializationEvent e) {
        instance = this;
        proxy.resetDebug();
        proxy.preInitialize(e);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent e) {
        proxy.initialize(e);
    }

    @Mod.EventHandler
    public void postInitialize(FMLPostInitializationEvent e) {
        proxy.postInitialize(e);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        LoggerUtils.instance.info("Starting command registrations...");
        LoggerUtils.instance.info("Registering trader commands");
        TraderCommands commands = new TraderCommands();
        e.registerServerCommand((ICommand)commands);
        commands.registerNodes();
        LoggerUtils.instance.info("Finished command registrations");
        World world = e.getServer().func_130014_f_();
        LoggerUtils.instance.info("Starting ScheduleManager setup...");
        scheduleManager = new ScheduleManager(world);
        scheduleManager.addScheduler(new TraderScheduler());
        LoggerUtils.instance.info("Finished ScheduleManager setup");
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void worldTick(TickEvent.WorldTickEvent e) {
            if (e.phase == TickEvent.Phase.START) {
                scheduleManager.onWorldTick(e);
            }
        }

        @CraftStudioLoader
        public static void registerCraftStudio() {
            proxy.registerCraftStudioModels();
            proxy.registerCraftStudioAnimations();
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            ModEntities.register((IForgeRegistry<EntityEntry>)event.getRegistry());
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            ModEntities.registerModels();
        }
    }
}

