/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.utils;

import bletch.common.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillageManager;
import net.tangotek.tektopia.economy.ItemEconomy;
import net.tangotek.tektopia.economy.ItemValue;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureBarracks;
import net.tangotek.tektopia.structures.VillageStructureHome;
import net.tangotek.tektopia.structures.VillageStructureRancherPen;
import net.tangotek.tektopia.structures.VillageStructureType;

@ParametersAreNonnullByDefault
public class TektopiaUtils {
    public static final int MIN_VILLAGE_LEVEL = 1;
    public static final int MAX_VILLAGE_LEVEL = 5;
    public static final String PROFESSIONTYPE_ARCHITECT = "ARCHITECT";
    public static final String PROFESSIONTYPE_TRADESMAN = "TRADESMAN";

    public static List<Block> getTektopiaBlocks() {
        return StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(b -> b.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).distinct().sorted(Comparator.comparing(b -> b.getClass().getTypeName())).collect(Collectors.toList());
    }

    public static List<ItemStack> getTektopiaBlockStacks() {
        return StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(b -> b.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).distinct().map(b -> new ItemStack(b)).sorted(Comparator.comparing(s -> s.getClass().getTypeName())).collect(Collectors.toList());
    }

    public static List<Class<?>> getTektopiaBlockClasses() {
        return StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(b -> b.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).map(b -> b.getClass()).filter(c -> !c.getTypeName().equalsIgnoreCase(Block.class.getTypeName())).distinct().sorted(Comparator.comparing(Class::getTypeName)).collect(Collectors.toList());
    }

    public static List<Item> getTektopiaItems() {
        return StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(i -> i.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).distinct().sorted(Comparator.comparing(i -> i.getClass().getTypeName())).collect(Collectors.toList());
    }

    public static List<ItemStack> getTektopiaItemStacks() {
        return StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(i -> i.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).distinct().map(i -> new ItemStack(i)).sorted(Comparator.comparing(s -> s.getClass().getTypeName())).collect(Collectors.toList());
    }

    public static List<Class<?>> getTektopiaItemClasses() {
        return StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(i -> i.getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")).distinct().map(i -> i.getClass()).sorted(Comparator.comparing(Class::getTypeName)).collect(Collectors.toList());
    }

    public static ProfessionType getProfessionType(String professionTypeName) {
        if (StringUtils.isNullOrWhitespace(professionTypeName).booleanValue()) {
            return null;
        }
        try {
            return ProfessionType.valueOf((String)professionTypeName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> getProfessionTypeNames(Boolean includeAdditionals) {
        List results = StreamSupport.stream(Arrays.spliterator(ProfessionType.values()), false).distinct().filter(p -> p != ProfessionType.NOMAD).map(t -> t.name()).collect(Collectors.toList());
        if (includeAdditionals.booleanValue()) {
            results.add(PROFESSIONTYPE_ARCHITECT);
            results.add(PROFESSIONTYPE_TRADESMAN);
        }
        return results.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    public static List<ProfessionType> getProfessionTypes() {
        return StreamSupport.stream(Arrays.spliterator(ProfessionType.values()), false).distinct().filter(p -> p != ProfessionType.NOMAD).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
    }

    public static List<VillageStructureType> getVillageHomeTypes() {
        return StreamSupport.stream(Arrays.spliterator(VillageStructureType.values()), false).distinct().filter(t -> t.isHome() || t == VillageStructureType.BARRACKS).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
    }

    public static List<VillageStructureType> getVillageStructureTypes() {
        return StreamSupport.stream(Arrays.spliterator(VillageStructureType.values()), false).distinct().sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
    }

    public static Map<VillageStructureType, List<VillageStructure>> getVillageHomes(Village village) {
        HashMap<VillageStructureType, List<VillageStructure>> structuresList = new HashMap<VillageStructureType, List<VillageStructure>>();
        for (VillageStructureType structureType : TektopiaUtils.getVillageHomeTypes()) {
            ArrayList structures = village.getStructures(structureType);
            if (structures == null) {
                structures = new ArrayList();
            }
            structuresList.put(structureType, structures);
        }
        return structuresList;
    }

    public static Map<VillageStructureType, List<VillageStructure>> getVillageStructures(Village village) {
        HashMap<VillageStructureType, List<VillageStructure>> structuresList = new HashMap<VillageStructureType, List<VillageStructure>>();
        for (VillageStructureType structureType : TektopiaUtils.getVillageStructureTypes()) {
            ArrayList structures = village.getStructures(structureType);
            if (structures == null) {
                structures = new ArrayList();
            }
            structuresList.put(structureType, structures);
        }
        return structuresList;
    }

    public static List<EntityVillagerTek> getVillageResidents(Village village) {
        try {
            Field field = Village.class.getDeclaredField("residents");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(village);
                if (fieldValue instanceof List) {
                    return ((List)fieldValue).stream().filter(v -> v instanceof EntityVillagerTek).map(v -> (EntityVillagerTek)v).sorted((c1, c2) -> (c1.getClass().getName() + "@" + c1.getLastName() + "@" + c1.getFirstName()).compareTo(c2.getClass().getName() + "@" + c2.getLastName() + "@" + c1.getFirstName())).collect(Collectors.toList());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<EntityVillagerTek>();
    }

    public static int getStructureMaxBeds(VillageStructureHome homeStructure) {
        try {
            Field field = VillageStructureHome.class.getDeclaredField("maxBeds");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(homeStructure);
                if (fieldValue instanceof Integer) {
                    return (Integer)fieldValue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int getStructureMaxBeds(VillageStructureBarracks barracksStructure) {
        try {
            Field field = VillageStructureHome.class.getDeclaredField("maxBeds");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(barracksStructure);
                if (fieldValue instanceof Integer) {
                    return (Integer)fieldValue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static List<BlockPos> getStructureFloorTiles(VillageStructure structure) {
        try {
            Field field = VillageStructure.class.getDeclaredField("floorTiles");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(structure);
                if (fieldValue instanceof List) {
                    return ((List)fieldValue).stream().filter(v -> v instanceof BlockPos).map(v -> (BlockPos)v).collect(Collectors.toList());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<BlockPos>();
    }

    public static int getStructureAnimalCount(VillageStructureRancherPen structure) {
        try {
            Field field = VillageStructureRancherPen.class.getDeclaredField("animalCount");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(structure);
                if (fieldValue instanceof Integer) {
                    return (Integer)fieldValue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static List<ItemStack> getEconomySalesHistory(ItemEconomy economy) {
        try {
            Field field = ItemEconomy.class.getDeclaredField("salesHistory");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(economy);
                if (fieldValue instanceof LinkedList) {
                    return ((LinkedList)fieldValue).stream().filter(v -> v instanceof ItemValue).map(iv -> ((ItemValue)iv).getItemStack()).collect(Collectors.toList());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getVillagerSleepOffset(EntityVillagerTek villager) {
        try {
            Field field = EntityVillagerTek.class.getDeclaredField("sleepOffset");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(villager);
                if (fieldValue instanceof Integer) {
                    return (Integer)fieldValue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static List<Integer> getVillagerRecentEats(EntityVillagerTek villager) {
        try {
            Field field = EntityVillagerTek.class.getDeclaredField("recentEats");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(villager);
                if (fieldValue instanceof LinkedList) {
                    return ((LinkedList)fieldValue).stream().filter(v -> v instanceof Integer).map(iv -> (Integer)iv).collect(Collectors.toList());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long fixTime(long time) {
        while (time > 24000L) {
            time -= 24000L;
        }
        while (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public static int fixTime(int time) {
        while (time > 24000) {
            time -= 24000;
        }
        while ((long)time < 0L) {
            time += 24000;
        }
        return time;
    }

    public static boolean isTimeOfDay(long timeOfDay, long startTime, long endTime) {
        startTime = TektopiaUtils.fixTime(startTime);
        if ((endTime = TektopiaUtils.fixTime(endTime)) > startTime) {
            return timeOfDay >= startTime && timeOfDay <= endTime;
        }
        return timeOfDay >= startTime || timeOfDay <= endTime;
    }

    public static String formatBlockPos(BlockPos blockPos) {
        if (blockPos == null) {
            return "";
        }
        return blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p();
    }

    public static List<Village> getVillages(World world) {
        if (world == null) {
            return null;
        }
        VillageManager villageManager = VillageManager.get((World)world);
        if (villageManager == null) {
            return null;
        }
        try {
            Field field = VillageManager.class.getDeclaredField("villages");
            if (field != null) {
                field.setAccessible(true);
                Object fieldValue = field.get(villageManager);
                if (fieldValue instanceof Set) {
                    return ((Set)fieldValue).stream().filter(v -> v instanceof Village).map(v -> (Village)v).filter(v -> v.isValid()).collect(Collectors.toList());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getVillageLevel(Village village) {
        if (village == null) {
            return 0;
        }
        int residentCount = village.getResidentCount();
        return Math.max(Math.min(residentCount / 10, 5), 1);
    }

    public static BlockPos getVillageSpawnPoint(World world, Village village) {
        int retries = 3;
        while (retries-- > 0) {
            BlockPos spawnPosition = village.getEdgeNode();
            if (!TektopiaUtils.isChunkFullyLoaded(world, spawnPosition)) continue;
            return spawnPosition;
        }
        return null;
    }

    public static boolean isChunkFullyLoaded(World world, BlockPos pos) {
        if (world == null || world.field_72995_K || pos == null) {
            return true;
        }
        long i = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        Chunk chunk = (Chunk)((ChunkProviderServer)world.func_72863_F()).field_73244_f.get(i);
        return chunk != null && !chunk.field_189550_d;
    }

    public static Boolean trySpawnEntity(World world, BlockPos spawnPosition, Function<World, ?> createFunc) {
        if (world == null || spawnPosition == null || createFunc == null) {
            return false;
        }
        EntityLiving entity = (EntityLiving)createFunc.apply(world);
        if (entity == null) {
            return false;
        }
        entity.func_70012_b((double)spawnPosition.func_177958_n() + 0.5, (double)spawnPosition.func_177956_o(), (double)spawnPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.func_180482_a(world.func_175649_E(spawnPosition), null);
        return world.func_72838_d((Entity)entity);
    }

    public static boolean trySpawnPersistenceEntity(World world, BlockPos spawnPosition, Function<World, ?> createFunc) {
        if (world == null || spawnPosition == null || createFunc == null) {
            return false;
        }
        EntityLiving entity = (EntityLiving)createFunc.apply(world);
        if (entity == null) {
            return false;
        }
        entity.func_70012_b((double)spawnPosition.func_177958_n() + 0.5, (double)spawnPosition.func_177956_o(), (double)spawnPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.func_180482_a(world.func_175649_E(spawnPosition), null);
        entity.func_110163_bv();
        return world.func_72838_d((Entity)entity);
    }
}

