/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.entities.renders;

import com.leviathanstudio.craftstudio.client.model.ModelCraftStudio;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.tangotek.tektopia.client.LayerVillagerHeldItem;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class RenderVillager<T extends EntityVillagerTek>
extends RenderLiving<T> {
    protected final String modId;
    protected final String textureName;
    protected final ModelCraftStudio maleModel;
    protected final ModelCraftStudio femaleModel;
    protected ResourceLocation[] maleTextures;
    protected ResourceLocation[] femaleTextures;

    public RenderVillager(RenderManager manager, String modId, String modelName, boolean hasGenderModels, int textureWidth, int textureHeight, String textureName) {
        this(manager, modId, modelName, hasGenderModels, textureWidth, textureHeight, textureName, 0.4f);
    }

    public RenderVillager(RenderManager manager, String modId, String modelName, boolean hasGenderModels, int textureWidth, int textureHeight, String textureName, float shadowSize) {
        super(manager, (ModelBase)new ModelCraftStudio(modId, modelName + "_m", textureWidth, textureHeight), shadowSize);
        this.func_177094_a((LayerRenderer)new LayerVillagerHeldItem((RenderLivingBase)this));
        this.modId = modId;
        this.textureName = textureName;
        this.maleModel = (ModelCraftStudio)this.field_77045_g;
        this.femaleModel = hasGenderModels ? new ModelCraftStudio(modId, modelName + "_f", textureWidth, textureHeight) : null;
        this.setupTextures();
    }

    protected void setupTextures() {
        this.maleTextures = new ResourceLocation[]{new ResourceLocation(this.modId, "textures/entity/" + this.textureName + "_m.png")};
        this.femaleTextures = new ResourceLocation[]{new ResourceLocation(this.modId, "textures/entity/" + this.textureName + "_f.png")};
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = !entity.isMale() && this.femaleModel != null ? this.femaleModel : this.maleModel;
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return entity.isMale() ? this.maleTextures[0] : this.femaleTextures[0];
    }

    protected void applyRotations(T entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        if (entityLiving.getForceAxis() >= 0) {
            GlStateManager.func_179114_b((float)(entityLiving.getForceAxis() * -90), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.func_77043_a(entityLiving, p_77043_2_, rotationYaw, partialTicks);
        }
    }
}

