/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.entities.ai;

import bletch.common.entities.ai.EntityAIMoveToBlock;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class EntityAIVisitVillage
extends EntityAIMoveToBlock {
    protected final Function<EntityVillagerTek, BlockPos> whereFunc;
    protected final Predicate<EntityVillagerTek> shouldPred;
    protected final Runnable resetRunner;
    protected final Runnable startRunner;
    protected final EntityVillagerTek entity;
    protected final EntityVillagerTek.MovementMode moveMode;

    public EntityAIVisitVillage(EntityVillagerTek entity, Predicate<EntityVillagerTek> shouldPred, Function<EntityVillagerTek, BlockPos> whereFunc, EntityVillagerTek.MovementMode moveMode, Runnable startRunner, Runnable resetRunner) {
        super((EntityVillageNavigator)entity);
        this.entity = entity;
        this.shouldPred = shouldPred;
        this.whereFunc = whereFunc;
        this.resetRunner = resetRunner;
        this.startRunner = startRunner;
        this.moveMode = moveMode;
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity.isAITick() && this.entity.hasVillage() && this.shouldPred.test(this.entity)) {
            return super.func_75250_a();
        }
        return false;
    }

    @Override
    public void func_75249_e() {
        if (this.startRunner != null) {
            this.startRunner.run();
        }
        super.func_75249_e();
    }

    @Override
    public void func_75251_c() {
        if (this.resetRunner != null) {
            this.resetRunner.run();
        }
        super.func_75251_c();
    }

    @Override
    protected BlockPos getDestinationBlock() {
        return this.whereFunc.apply(this.entity);
    }

    @Override
    protected boolean isNearWalkPos() {
        return this.entity.func_180425_c().func_177951_i((Vec3i)this.destinationPos) < 4.0;
    }

    @Override
    protected void updateMovementMode() {
        this.entity.setMovementMode(this.moveMode);
    }
}

