/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.entities;

import com.google.common.base.Predicate;
import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tangotek.tektopia.TekVillager;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.entities.ai.EntityAIReadBook;
import net.tangotek.tektopia.entities.ai.EntityAIWanderStructure;

public abstract class EntityVendorBase
extends EntityVillagerTek
implements IMerchant,
INpc {
    protected static final DataParameter<String> ANIMATION_KEY = EntityDataManager.func_187226_a(EntityVendorBase.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final AnimationHandler<EntityVendorBase> animationHandler = TekVillager.getNewAnimationHandler(EntityVendorBase.class);
    protected String modId;
    protected BlockPos firstCheck;
    @Nullable
    protected EntityPlayer buyingPlayer;
    @Nullable
    protected MerchantRecipeList vendorList;

    public EntityVendorBase(World worldIn, String modId) {
        super(worldIn, null, VillagerRole.VENDOR.value | VillagerRole.VISITOR.value);
        this.sleepOffset = 0;
        this.modId = modId;
    }

    protected void addTask(int priority, EntityAIBase task) {
        if (task instanceof EntityAIWanderStructure && priority <= 100) {
            return;
        }
        if (task instanceof EntityAIReadBook) {
            return;
        }
        super.addTask(priority, task);
    }

    public void addVillagerPosition() {
    }

    protected void bedCheck() {
    }

    public boolean canNavigate() {
        return !this.isTrading() && super.canNavigate();
    }

    protected abstract void checkStuck();

    public float func_70689_ay() {
        return super.func_70689_ay() * 0.9f;
    }

    protected boolean getCanUseDoors() {
        return true;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.vendorList == null) {
            this.populateBuyingList();
        }
        return this.vendorList;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    protected void initEntityAIBase() {
        this.setupAITasks();
    }

    public boolean isFleeFrom(Entity e) {
        return false;
    }

    public Predicate<Entity> isHostile() {
        return e -> false;
    }

    public boolean isLearningTime() {
        return false;
    }

    public boolean isSleepingTime() {
        return false;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public boolean isWorkTime() {
        return EntityVendorBase.isWorkTime(this.field_70170_p, this.sleepOffset) && !this.field_70170_p.func_72896_J();
    }

    protected abstract void populateBuyingList();

    protected void prepStuck() {
        this.firstCheck = this.func_190671_u_();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!(!this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af() || this.field_70170_p.field_72995_K)) {
            if (this.vendorList == null) {
                this.populateBuyingList();
            }
            if (this.vendorList != null && !this.vendorList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
                this.func_70661_as().func_75499_g();
            }
        }
        return true;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
        this.func_70661_as().func_75499_g();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    protected abstract void setupAITasks();

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.vendorList = new MerchantRecipeList(nbttagcompound);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.vendorList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.vendorList.func_77202_a());
        }
    }

    public static boolean isWorkTime(World world, int sleepOffset) {
        return Village.isTimeOfDay((World)world, (long)WORK_START_TIME, (long)WORK_END_TIME, (long)sleepOffset);
    }

    protected static void setupCraftStudioAnimations(String modId, String modelName) {
        animationHandler.addAnim(modId, "villager_eat", modelName, true);
        animationHandler.addAnim(modId, "villager_read", modelName, true);
        animationHandler.addAnim(modId, "villager_run", modelName, true);
        animationHandler.addAnim(modId, "villager_sit", modelName, true);
        animationHandler.addAnim(modId, "villager_sit_cheer", modelName, true);
        animationHandler.addAnim(modId, "villager_sleep", modelName, true);
        animationHandler.addAnim(modId, "villager_walk", modelName, true);
        animationHandler.addAnim(modId, "villager_walk_sad", modelName, true);
    }

    public AnimationHandler<EntityVendorBase> getAnimationHandler() {
        return animationHandler;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)"");
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ANIMATION_KEY, (Object)"");
        super.func_70088_a();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.isWorldRemote() && ANIMATION_KEY.equals(key)) {
            this.updateClientAnimation((String)this.field_70180_af.func_187225_a(ANIMATION_KEY));
        }
    }

    public void playClientAnimation(String animationName) {
        if (!this.getAnimationHandler().isAnimationActive(this.modId, animationName, (IAnimated)this)) {
            this.getAnimationHandler().startAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    public void stopClientAnimation(String animationName) {
        super.stopClientAnimation(animationName);
        if (this.getAnimationHandler().isAnimationActive(this.modId, animationName, (IAnimated)this)) {
            this.getAnimationHandler().stopAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    protected void updateClientAnimation(String animationName) {
        ClientAnimationHandler clientAnimationHandler = (ClientAnimationHandler)this.getAnimationHandler();
        Set animChannels = clientAnimationHandler.getAnimChannels().keySet();
        animChannels.forEach(a -> clientAnimationHandler.stopAnimation(a, (IAnimated)this));
        if (!animationName.isEmpty()) {
            clientAnimationHandler.startAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    public boolean isPlayingAnimation(String animationName) {
        return Objects.equals(animationName, this.field_70180_af.func_187225_a(ANIMATION_KEY));
    }

    public void playServerAnimation(String animationName) {
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)animationName);
    }

    public void stopServerAnimation(String animationName) {
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)"");
    }
}

