/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.events.EndGameEvent;
import com.pixelmonmod.tcg.api.events.EndTurnEvent;
import com.pixelmonmod.tcg.api.events.StartGameEvent;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.api.util.helper.TitleHelper;
import com.pixelmonmod.tcg.block.BattleControllerBlock;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.PendingAttack;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.dto.CustomGUI;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.AvailableActions;
import com.pixelmonmod.tcg.duel.state.CardSelectorResult;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CoinFlipState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.CustomGUIResult;
import com.pixelmonmod.tcg.duel.state.DelayEffect;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.battles.EndGamePacket;
import com.pixelmonmod.tcg.network.packets.battles.GameStateSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.PrizeSelectorToClientPacket;
import com.pixelmonmod.tcg.network.packets.battles.RenderStatePreBattleSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.RenderStateSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.TrainerPlayedPacket;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ServerOwnedTileEntityBattleController
extends BattleOwnedTileEntityController {
    private GameServerState server;
    private boolean readyToEndTurn = false;
    private static final int MILLIS_EVERY_RENDER_SYNC = 500;
    private static final int MILLIS_EVERY_GAME_SYNC = 100;
    private static final int MILLIS_EVERY_GAME_SYNC_SPECTATOR = 1000;
    private static final int MILLIS_EVERY_AVAILABILITY_SYNC = 2000;
    private long syncRenderTime = 0L;
    private long syncGameTime = 0L;
    private long syncGameSpectatorTime = 0L;
    private long syncAvailabilityTime = 0L;
    private int mulliganDifference = 0;
    private final List<CardSelectorState> mulliganStates0 = new ArrayList<CardSelectorState>();
    private final List<CardSelectorState> mulliganStates1 = new ArrayList<CardSelectorState>();

    @Override
    public GameServerState getGameServer() {
        return this.server;
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            super.initialize();
            return;
        }
        if (!this.init) {
            this.newGame();
        }
        if (this.server.isGameInProgress()) {
            int nullCount = 0;
            PlayerServerState[] playerServerStateArray = this.server.getPlayers();
            int n = playerServerStateArray.length;
            for (int i = 0; i < n; ++i) {
                PlayerServerState player = playerServerStateArray[i];
                if (player == null || player.getEntityPlayer() == null) {
                    ++nullCount;
                    continue;
                }
                if (player.getEntityPlayer().func_130014_f_().func_217371_b(player.getEntityPlayer().func_110124_au()) != null) continue;
                player.setInGUI(false);
                ++nullCount;
            }
            if (nullCount == 2) {
                this.endGame(null, null, false);
                return;
            }
        }
        if (!this.server.isGameInProgress()) {
            this.sendRenderPreBattleSyncPackets();
            for (int i = 0; i < this.server.getPlayers().length; ++i) {
                PlayerServerState player = this.server.getPlayers()[i];
                if (player == null) {
                    return;
                }
                if (!player.isInGUI() || player.getEntityPlayer() == null) {
                    this.server.getPlayers()[i] = null;
                    return;
                }
                if (!player.hasDeck()) {
                    this.server.getPlayers()[i] = null;
                    NetworkHelper.sendPacket(new EndGamePacket(this.field_174879_c), (ServerPlayerEntity)player.getEntityPlayer());
                    ChatHandler.sendChat((Entity)player.getEntityPlayer(), TextFormatting.RED + "You don't have a valid deck!", new Object[0]);
                    return;
                }
                if (player.getEntityPlayer().func_130014_f_().func_217371_b(player.getEntityPlayer().func_110124_au()) != null) continue;
                this.server.getPlayers()[i] = null;
                return;
            }
            this.server.setGameInProgress(true);
            if (this.startingCommand != null) {
                this.trigger(this.func_145831_w(), this.startingCommand, this.server.getPlayers()[0].getPlayerName(), this.server.getPlayers()[1].getPlayerName());
            }
            for (PlayerServerState player : this.server.getPlayers()) {
                player.prepareDeck();
            }
        }
        if (!this.server.isGameInProgress()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.syncRenderTime < currentTime - 500L) {
            this.syncRenderTime = currentTime;
            this.sendRenderSyncPackets();
        }
        if (this.syncGameTime < currentTime - 100L) {
            this.syncGameTime = currentTime;
            this.sendGameSyncPackets();
        }
        if (this.syncGameSpectatorTime < currentTime - 1000L) {
            this.syncGameSpectatorTime = currentTime;
            this.sendGameSyncPacketsToSpectators();
        }
        if (this.syncAvailabilityTime < currentTime - 2000L) {
            this.syncAvailabilityTime = currentTime;
            for (PlayerServerState player : this.server.getPlayers()) {
                if (player == null || player.getEntityPlayer() == null || player.getEntityPlayer().func_130014_f_().func_217371_b(player.getEntityPlayer().func_110124_au()) != null) continue;
                player.setInGUI(false);
            }
        }
        if (this.readyToEndTurn) {
            this.endTurn();
            return;
        }
        GamePhase nextPhase = this.server.getGamePhase();
        switch (this.server.getGamePhase()) {
            case FlippingCoin: {
                nextPhase = this.handleFlippingCoin();
                break;
            }
            case PreMatch: {
                nextPhase = this.handlePreMatch(nextPhase);
                break;
            }
            case BetweenTurns: {
                this.handleBetweenTurn();
                return;
            }
        }
        if (this.server.getGamePhase() == GamePhase.PreMatch) {
            for (int i = 0; i < 2; ++i) {
                PlayerServerState player = this.server.getPlayer(i);
                if (player == this.server.getPlayer(0) && !this.mulliganStates0.isEmpty()) {
                    if (player.getCardSelectorState() == null) {
                        player.setCardSelectorState(this.mulliganStates0.get(0));
                        return;
                    }
                    if (player.getCardSelectorState().getDisplayType() == CardSelectorDisplay.Select && player.getCardSelectorResult() != null && player.getCardSelectorResult().getSelection() != null) {
                        player.setCardSelectorResult(null);
                        player.setCardSelectorState(null);
                        this.mulliganStates0.remove(0);
                        return;
                    }
                }
                if (player == this.server.getPlayer(1) && !this.mulliganStates1.isEmpty()) {
                    if (player.getCardSelectorState() == null) {
                        player.setCardSelectorState(this.mulliganStates1.get(0));
                        return;
                    }
                    if (player.getCardSelectorState().getDisplayType() == CardSelectorDisplay.Select && player.getCardSelectorResult() != null && player.getCardSelectorResult().getSelection() != null) {
                        player.setCardSelectorResult(null);
                        player.setCardSelectorState(null);
                        this.mulliganStates1.remove(0);
                        return;
                    }
                }
                if (player.getCardSelectorState() != null && player.getCardSelectorState().getDisplayType() == CardSelectorDisplay.Draw && player.getCardSelectorResult() == null) {
                    return;
                }
                if (player.getCardSelectorResult() == null || player.getCardSelectorState().getDisplayType() != CardSelectorDisplay.Draw || player.getCardSelectorResult().getSelection() == null) continue;
                int count = 0;
                for (boolean b : player.getCardSelectorResult().getSelection()) {
                    if (!b) continue;
                    ++count;
                }
                player.drawCards(count, this.server);
                player.setCardSelectorResult(null);
                player.setCardSelectorState(null);
            }
        }
        if (this.server.getGamePhase().after(GamePhase.PreMatch)) {
            boolean hasPending = false;
            if (this.server.exceedTimeLimit()) {
                PlayerServerState current = this.server.getPlayer(this.server.getCurrentTurn());
                if (current.isChoosingOppAttack()) {
                    this.requestPickAttack(this.server.getCurrentTurn(), 0);
                }
                if (current.getCustomGUI() != null) {
                    current.useCustomGUIDefaultResult();
                }
            }
            if (this.server.getPendingAbility() != null) {
                if (this.handlePendingAbility()) {
                    return;
                }
                hasPending = true;
            }
            if (this.server.getPendingAttack() != null) {
                if (this.server.getCurrentEffectIndex() >= 0 && this.handlePendingEffects()) {
                    return;
                }
                if (this.handlePendingAttack()) {
                    return;
                }
                hasPending = true;
            }
            for (PlayerServerState player : this.server.getPlayers()) {
                if (player.getTrainerCard() == null || player.getTrainerCard().getData().getEffect() == null) continue;
                if (this.handlePendingTrainer(player)) {
                    return;
                }
                hasPending = true;
            }
            for (PlayerServerState player : this.server.getPlayers()) {
                if (player.getCardSelectorState() == null || player.getCardSelectorState().getDisplayType() != CardSelectorDisplay.Reveal || player.getCardSelectorResult() == null || !player.getCardSelectorResult().isOpened()) continue;
                player.setCardSelectorState(null);
            }
            for (int playerIndex = 0; playerIndex < 2; ++playerIndex) {
                PlayerServerState player = this.server.getPlayer(playerIndex);
                int prizeIndex = player.getOpeningPrizeIndex();
                if (prizeIndex < 0) continue;
                if (player.getPrizeCards()[prizeIndex] != null) {
                    ImmutableCard prize = player.getPrizeCards()[prizeIndex];
                    player.getHand().add(prize);
                    player.getPrizeCards()[prizeIndex] = null;
                    player.addPendingPrizeCount(playerIndex, -1);
                    NetworkHelper.sendPacket(new PrizeSelectorToClientPacket(this.field_174879_c, prizeIndex, prize), (ServerPlayerEntity)player.getEntityPlayer());
                }
                player.setOpeningPrizeIndex(-1);
            }
            boolean hasFainted = false;
            for (int playerIndex = 0; playerIndex < 2; ++playerIndex) {
                PlayerServerState player = this.server.getPlayer(playerIndex);
                MutableInt prizeCount = new MutableInt(0);
                PokemonCardState activeCard = player.getActiveCard();
                if (activeCard != null && this.checkKnockedOut(player, activeCard, prizeCount)) {
                    hasFainted = true;
                    player.setActiveCard(null);
                }
                for (int i = 0; i < player.getBenchCards().length; ++i) {
                    if (player.getBenchCards()[i] == null || !this.checkKnockedOut(player, player.getBenchCards()[i], prizeCount)) continue;
                    hasFainted = true;
                    player.getBenchCards()[i] = null;
                }
                if (prizeCount.intValue() <= 0) continue;
                this.server.getOpponent(player).addPendingPrizeCount((playerIndex + 1) % 2, prizeCount.getValue());
            }
            if (hasFainted) {
                this.requestSyncGame();
                return;
            }
            int[] winningScores = new int[this.server.getPlayers().length];
            for (int i = 0; i < this.server.getPlayers().length; ++i) {
                PlayerServerState player = this.server.getPlayer(i);
                if (!player.hasPokemonLeft()) {
                    ChatHandler.sendFormattedChat((ICommandSource)player.getEntityPlayer(), TextFormatting.RED, "You have no Pokemon cards left on the board!", new Object[0]);
                    ChatHandler.sendFormattedChat((ICommandSource)this.server.getOpponent(player).getEntityPlayer(), TextFormatting.YELLOW, player.getPlayerName() + " has no Pokemon cards left on the board!", new Object[0]);
                    int n = (i + 1) % 2;
                    winningScores[n] = winningScores[n] + 1;
                }
                if (player.getPrizeCards() == null || player.hasPrizeLeft()) continue;
                ChatHandler.sendFormattedChat((ICommandSource)player.getEntityPlayer(), TextFormatting.YELLOW, "You have won all prize cards!", new Object[0]);
                ChatHandler.sendFormattedChat((ICommandSource)this.server.getOpponent(player).getEntityPlayer(), TextFormatting.RED, player.getPlayerName() + " has won all prize cards!", new Object[0]);
                int n = i;
                winningScores[n] = winningScores[n] + 1;
            }
            if (winningScores[0] > 0 || winningScores[1] > 0) {
                PlayerServerState winner = null;
                PlayerServerState loser = null;
                boolean tiedGame = false;
                if (winningScores[0] > winningScores[1]) {
                    winner = this.server.getPlayer(0);
                    loser = this.server.getPlayer(1);
                } else if (winningScores[0] < winningScores[1]) {
                    winner = this.server.getPlayer(1);
                    loser = this.server.getPlayer(0);
                } else {
                    winner = this.server.getPlayer(0);
                    loser = this.server.getPlayer(1);
                    tiedGame = true;
                }
                if (winner != null && loser != null) {
                    this.endGame(winner, loser, tiedGame);
                    return;
                }
            }
            for (PlayerServerState player : this.server.getPlayers()) {
                if (player.getActiveCard() != null || !player.hasPokemonLeft() || !this.server.getOpponent(player).hasPrizeLeft()) continue;
                if (this.server.exceedTimeLimit()) {
                    player.setActiveCard(player.getActiveAndBenchCards().get(0));
                }
                return;
            }
            if (this.server.exceedTimeLimit()) {
                PlayerServerState current = this.server.getPlayer(this.server.getCurrentTurn());
                PlayerServerState next = this.server.getPlayer(this.server.getNextTurn());
                CardSelectorState selector = current.getCardSelectorState();
                if (selector != null && selector.getMaximumCount() > 0) {
                    if (selector.isCancellable()) {
                        current.setCardSelectorState(null);
                    } else {
                        CardSelectorResult result = new CardSelectorResult();
                        result.setSelection(new boolean[selector.getCardList().size()]);
                        result.setOpened(true);
                        for (int i = 0; i < selector.getMinimumCount(); ++i) {
                            result.getSelection()[i] = true;
                        }
                        current.setCardSelectorResult(result);
                    }
                    return;
                }
                if (current.getPendingPrizeCount() > 0) {
                    for (int i = 0; i < current.getPendingPrizeCount(); ++i) {
                        if (current.getPrizeCards()[i] == null) continue;
                        this.setPrizeSelection(current.getEntityPlayer(), i);
                    }
                    return;
                }
                if (!hasPending) {
                    this.requestEndTurn(this.server.getPlayer(this.server.getCurrentTurn()));
                }
            }
        }
        if (this.server.isGameInProgress()) {
            this.server.setGamePhase(nextPhase);
        } else {
            this.func_195044_w().func_206870_a((Property)BattleControllerBlock.ON, (Comparable)Boolean.valueOf(false));
        }
    }

    private void handleBetweenTurn() {
        if (this.handleConditionEffects()) {
            return;
        }
        PlayerServerState lastPlayer = this.server.getPlayer(this.server.getCurrentTurn());
        PlayerServerState nextPlayer = this.server.getPlayer(this.server.getNextTurn());
        if (nextPlayer.getActiveCard() != null) {
            nextPlayer.getActiveCard().getStatus().setDamageImmune(false);
            nextPlayer.getActiveCard().getStatus().setConditionImmune(false);
        }
        for (PokemonCardState benchCard : nextPlayer.getBenchCards()) {
            if (benchCard == null) continue;
            benchCard.getStatus().setDamageImmune(false);
            benchCard.getStatus().setConditionImmune(false);
        }
        for (PokemonCardState card : lastPlayer.getActiveAndBenchCards()) {
            for (PokemonAttackStatus attackStatus : card.getAttacksStatus()) {
                attackStatus.reduceTurnCount();
            }
        }
        this.server.setCurrentTurn(this.server.getNextTurn());
        PlayerServerState currentPlayer = this.server.getPlayer(this.server.getCurrentTurn());
        if (currentPlayer.getDeck().size() == 0) {
            if (currentPlayer.getEntityPlayer() != null) {
                ChatHandler.sendFormattedChat((ICommandSource)currentPlayer.getEntityPlayer(), TextFormatting.RED, "You ran out of card to draw!", new Object[0]);
            }
            if (lastPlayer.getEntityPlayer() != null) {
                ChatHandler.sendFormattedChat((ICommandSource)lastPlayer.getEntityPlayer(), TextFormatting.RED, (currentPlayer.getEntityPlayer() != null ? currentPlayer.getEntityPlayer().func_145748_c_().getString() : "Your opponent") + " ran out of card to draw!", new Object[0]);
            }
            this.endGame(lastPlayer, currentPlayer, false);
            return;
        }
        this.server.setTurnCount(this.server.getTurnCount() + 1);
        TitleHelper.showTitle((ITextComponent)new StringTextComponent("Your turn started"), (ServerPlayerEntity)currentPlayer.getEntityPlayer(), 10, 30, 10);
        this.server.getLog().trackStartTurn(this.server.getTurn(nextPlayer), this.server);
        this.setTurnTimeLimit();
        currentPlayer.drawCards(1, this.server);
        this.server.setGamePhase(GamePhase.NormalTurn);
        currentPlayer.getAvailableActions().setForNormalTurn();
        this.server.setHandledPoisoned(false);
        this.server.setHandledBurned(false);
        this.server.setHandledAsleep(false);
        this.server.setHandledParalyzed(false);
        for (DelayEffect effect : this.server.getDelayEffects()) {
            if (effect.getTurn() != this.server.getTurnCount()) continue;
            effect.getEffect().modifyTurn(effect.getPokemon(), this.server);
        }
    }

    private void setTurnTimeLimit() {
        if (this.timeLimit > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, this.timeLimit);
            this.server.getPlayer(this.server.getCurrentTurn()).setCounterEndTime(calendar.getTime());
            this.server.getPlayer(this.server.getNextTurn()).setCounterEndTime(null);
        }
    }

    private boolean handleConditionEffects() {
        ArrayList<CoinSide> coinFlips;
        int playerIndex;
        Pair<PokemonCardState, Integer> pair;
        Optional<Pair> status;
        if (!this.server.isHandledPoisoned()) {
            for (PlayerServerState player : this.server.getPlayers()) {
                for (PokemonCardState card : player.getActiveAndBenchCards()) {
                    status = card.getStatus().getConditions().stream().filter(s -> s.getLeft() == CardCondition.POISONED).findFirst();
                    if (!status.isPresent()) continue;
                    Integer modifier = (Integer)status.get().getRight();
                    if (modifier == null || modifier < 2) {
                        modifier = 1;
                    }
                    card.addDamageFromCondition(10 * modifier);
                    this.server.getLog().trackCondition(CardCondition.POISONED, card, 10 * modifier, false, this.server.getTurn(player), this.server);
                }
            }
            this.server.setHandledPoisoned(true);
        }
        if (!this.server.isHandledBurned()) {
            if (this.server.getBurningCard() != null) {
                if (this.server.getRevealedCoinFlipResults() > 1) {
                    if (this.server.getCoinFlip().getResults().get(0) == CoinSide.Tail) {
                        this.server.getBurningCard().addDamageFromCondition(20);
                    }
                    this.server.setBurningCard(null);
                    this.server.setCoinFlip(null);
                } else {
                    return true;
                }
            }
            if (this.server.getResolvingConditionCards() == null) {
                this.server.setResolvingConditionCards(this.getCardsWithCondition(CardCondition.BURNT));
            }
            if (!this.server.getResolvingConditionCards().isEmpty()) {
                pair = this.server.getResolvingConditionCards().remove();
                PokemonCardState card = (PokemonCardState)pair.getLeft();
                playerIndex = (Integer)pair.getRight();
                this.server.setBurningCard(card);
                coinFlips = new ArrayList<CoinSide>();
                coinFlips.add(CoinSide.getRandom());
                this.server.setCoinFlip(new CoinFlipState(coinFlips, playerIndex));
                this.server.setRevealedCoinFlipResults(1);
                return true;
            }
            this.server.setResolvingConditionCards(null);
            this.server.setHandledBurned(true);
        }
        if (!this.server.isHandledAsleep()) {
            if (this.server.getSleepingCard() != null) {
                if (this.server.getRevealedCoinFlipResults() > 1) {
                    boolean healed;
                    boolean bl = healed = this.server.getCoinFlip().getResults().get(0) == CoinSide.Head;
                    if (healed) {
                        this.server.getSleepingCard().getStatus().removeCondition(CardCondition.ASLEEP);
                    }
                    this.server.getLog().trackCondition(CardCondition.ASLEEP, this.server.getSleepingCard(), 0, healed, this.server.getNextTurn(), this.server);
                    this.server.setSleepingCard(null);
                    this.server.setCoinFlip(null);
                } else {
                    return true;
                }
            }
            if (this.server.getResolvingConditionCards() == null) {
                this.server.setResolvingConditionCards(this.getCardsWithCondition(CardCondition.ASLEEP));
            }
            if (!this.server.getResolvingConditionCards().isEmpty()) {
                pair = this.server.getResolvingConditionCards().remove();
                PokemonCardState card = (PokemonCardState)pair.getLeft();
                playerIndex = (Integer)pair.getRight();
                this.server.setSleepingCard(card);
                coinFlips = new ArrayList();
                coinFlips.add(CoinSide.getRandom());
                this.server.setCoinFlip(new CoinFlipState(coinFlips, playerIndex));
                this.server.setRevealedCoinFlipResults(1);
                return true;
            }
            this.server.setResolvingConditionCards(null);
            this.server.setHandledAsleep(true);
        }
        if (!this.server.isHandledParalyzed()) {
            for (PlayerServerState player : this.server.getPlayers()) {
                for (PokemonCardState card : player.getActiveAndBenchCards()) {
                    status = card.getStatus().getConditions().stream().filter(s -> s.getLeft() == CardCondition.PARALYZED).findFirst();
                    if (!status.isPresent()) continue;
                    if (card.getStatus().isStartTurnParalyzed()) {
                        card.getStatus().removeCondition(CardCondition.PARALYZED);
                        this.server.getLog().trackCondition(CardCondition.PARALYZED, card, 0, true, this.server.getTurn(player), this.server);
                        continue;
                    }
                    if (player == this.server.getPlayer(this.server.getCurrentTurn())) continue;
                    card.getStatus().setStartTurnParalyzed(true);
                    this.server.getLog().trackCondition(CardCondition.PARALYZED, card, 0, false, this.server.getTurn(player), this.server);
                }
            }
            this.server.setHandledParalyzed(true);
        }
        return false;
    }

    private boolean handlePendingAbility() {
        PlayerServerState player = this.server.getPlayer(this.server.getCurrentTurn());
        PokemonCardState pokemon = this.server.getPendingAbility();
        BasePowerEffect effect = pokemon.getAbility().getEffect();
        if (effect != null) {
            CardSelectorState mySelector;
            CustomGUI customGUI;
            if (this.server.getCoinFlip() == null) {
                List<CoinSide> flips = effect.flipCoin();
                this.server.setCoinFlip(new CoinFlipState(flips, this.server.getCurrentTurn()));
                if (flips.isEmpty()) {
                    this.server.setRevealedCoinFlipResults(0);
                } else {
                    this.server.setRevealedCoinFlipResults(1);
                }
            }
            if (this.server.getCoinFlip() != null && !this.server.getCoinFlip().getResults().isEmpty() && this.server.getRevealedCoinFlipResults() <= this.server.getCoinFlip().getResults().size()) {
                this.forceRevealingCoinFlips();
                return true;
            }
            CustomGUI customGUI2 = customGUI = player.getCustomGUI() == null ? effect.getCustomGUI(pokemon, this.server) : null;
            if (customGUI != null) {
                player.setCustomGUI(customGUI);
                this.requestSyncGame();
                return true;
            }
            PlayerServerState opp = this.server.getOpponent(player);
            CardSelectorState cardSelectorState = mySelector = player.getCardSelectorState() == null ? effect.getSelectorState(pokemon, this.server) : null;
            if (mySelector != null) {
                player.setCardSelectorState(mySelector);
                this.requestSyncGame();
                return true;
            }
            this.saveSelectorResult(pokemon.getParameters(), player, player.getCardSelectorResult());
            if (effect.canActivate(pokemon, this.server)) {
                effect.activate(pokemon, this.server, player);
                this.server.setPendingAbility(null);
                player.setCardSelectorState(null);
                player.setCardSelectorResult(null);
                effect.cleanUp(pokemon, this.server);
                this.server.getLog().trackAbility(pokemon, this.server.getTurn(player), this.server);
                this.server.setCoinFlip(null);
                return true;
            }
        }
        return false;
    }

    private boolean handlePendingAttack() {
        PokemonAttackStatus attack = this.server.getPendingAttack().getAttack();
        PlayerServerState player = this.server.getPendingAttack().getPlayer();
        PokemonCardState active = this.server.getPendingAttack().getPokemon();
        if (!this.server.isHandledConfusedFlip() && active.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.CONFUSED)) {
            if (this.server.getCoinFlip() == null) {
                ArrayList<CoinSide> coinFlips = new ArrayList<CoinSide>();
                coinFlips.add(CoinSide.getRandom());
                this.server.setCoinFlip(new CoinFlipState(coinFlips, this.server.getCurrentTurn()));
                this.server.setRevealedCoinFlipResults(1);
                return true;
            }
            if (this.server.getRevealedCoinFlipResults() <= this.server.getCoinFlip().getResults().size()) {
                this.forceRevealingCoinFlips();
                return true;
            }
            CoinSide flipResult = this.server.getCoinFlip().getResults().get(0);
            this.server.setCoinFlip(null);
            this.server.setRevealedCoinFlipResults(0);
            if (flipResult == CoinSide.Tail) {
                active.addDamage(active, 30, this.server);
                this.server.setHandledConfusedFlip(false);
                this.server.setPendingAttack(null);
                this.requestEndTurn(player);
                return true;
            }
            this.server.setHandledConfusedFlip(true);
        }
        CardAttack data = attack.getData();
        if (!attack.isMissed()) {
            List<Object> flips;
            if (attack.getTemporaryEffect() != null && this.server.getCoinFlip() == null) {
                flips = attack.getTemporaryEffect().flipCoin(new ArrayList<CoinSide>(), active, this.server);
                this.server.setCoinFlip(new CoinFlipState(flips, this.server.getCurrentTurn()));
                if (flips.isEmpty()) {
                    this.server.setRevealedCoinFlipResults(0);
                } else {
                    this.server.setRevealedCoinFlipResults(1);
                }
            }
            if (data.hasEffects() && this.server.getCoinFlip() == null) {
                flips = new ArrayList();
                for (BaseAttackEffect effect : data.getEffects()) {
                    flips = effect.flipCoin(flips, active, this.server);
                }
                this.server.setCoinFlip(new CoinFlipState(flips, this.server.getCurrentTurn()));
                if (flips.isEmpty()) {
                    this.server.setRevealedCoinFlipResults(0);
                } else {
                    this.server.setRevealedCoinFlipResults(1);
                }
            }
        }
        if (this.server.getCoinFlip() != null && !this.server.getCoinFlip().getResults().isEmpty() && this.server.getRevealedCoinFlipResults() <= this.server.getCoinFlip().getResults().size()) {
            this.forceRevealingCoinFlips();
            return true;
        }
        if (!attack.isMissed()) {
            ArrayList<List<Object>> parameters;
            if (attack.getTemporaryEffect() != null) {
                parameters = new ArrayList<List<Object>>();
                parameters.add(new ArrayList());
                this.server.setEffectsParameters(parameters);
            } else if (data.hasEffects()) {
                parameters = new ArrayList();
                for (int i = 0; i < data.getEffects().size(); ++i) {
                    parameters.add(new ArrayList());
                }
                this.server.setEffectsParameters(parameters);
            }
        }
        this.server.setCurrentEffectIndex(0);
        this.server.setRevealedCoinFlipResults(0);
        this.server.setHandledConfusedFlip(false);
        return true;
    }

    private boolean handlePendingEffects() {
        PokemonAttackStatus attack = this.server.getPendingAttack().getAttack();
        List<BaseAttackEffect> effects = attack.getData().getEffects();
        PlayerServerState player = this.server.getPendingAttack().getPlayer();
        PokemonCardState active = this.server.getPendingAttack().getPokemon();
        PlayerServerState opp = this.server.getOpponent(player);
        PokemonCardState oppPokemon = opp.getActiveCard();
        oppPokemon.getStatus().cloneConditions();
        if (oppPokemon.getAbility() != null && oppPokemon.getAbility().getEffect() != null) {
            if (oppPokemon.getAbility().getEffect().onAttacked(oppPokemon, active, this.server) == 0) {
                attack.setMissed(true);
            }
            if (oppPokemon.getAbility().getEffect().onAttacked(oppPokemon, active, this.server) == 1) {
                attack.setMissed(false);
            }
        }
        if (!attack.isMissed()) {
            TrainerCardState trainer;
            int effectIndex = this.server.getCurrentEffectIndex();
            List<List<Object>> parameters = this.server.getEffectsParameters();
            BaseAttackEffect currentEffect = null;
            if (attack.getTemporaryEffect() != null) {
                currentEffect = attack.getTemporaryEffect();
            } else if (effects != null && effectIndex >= 0 && effectIndex < effects.size()) {
                currentEffect = effects.get(effectIndex);
            }
            if (currentEffect != null) {
                CustomGUI customGUI;
                CustomGUI customGUI2 = customGUI = player.getCustomGUI() == null ? currentEffect.getCustomGUI(active, this.server) : null;
                if (currentEffect.isOptional()) {
                    if (customGUI != null) {
                        player.setCustomGUI(customGUI);
                        this.requestSyncGame();
                        return true;
                    }
                    if (player.getCustomGUI() != null && (player.getCustomGUIResult() == null || player.getCustomGUIResult().getResult() == null || player.getCustomGUIResult().getResult().length == 0)) {
                        return true;
                    }
                }
                if (currentEffect.isOptional() && this.server.getPlayer(this.server.getCurrentTurn()).getCustomGUIResult().getResult()[0] == 2) {
                    player.setCardSelectorState(null);
                    player.setCardSelectorResult(null);
                } else {
                    CardSelectorState cardSelectorState;
                    CardSelectorState mySelector = player.getCardSelectorState() == null ? currentEffect.getSelectorState(parameters.get(effectIndex), this.server) : null;
                    CardSelectorState cardSelectorState2 = cardSelectorState = opp.getCardSelectorState() == null ? currentEffect.getOpponentSelectorState(this.server) : null;
                    if (mySelector != null) {
                        player.setCardSelectorState(mySelector);
                    }
                    if (cardSelectorState != null) {
                        opp.setCardSelectorState(cardSelectorState);
                    }
                    if (mySelector != null || cardSelectorState != null) {
                        this.requestSyncGame();
                        return true;
                    }
                    this.saveSelectorResult(parameters.get(effectIndex), player, player.getCardSelectorResult());
                    this.saveSelectorResult(parameters.get(effectIndex), opp, opp.getCardSelectorResult());
                }
                if (currentEffect.chooseOppAttack()) {
                    player.setChoosingOppAttack(true);
                }
                if (currentEffect.canApply(parameters.get(effectIndex), attack.getData(), this.server)) {
                    currentEffect.applyBeforeDamage(parameters.get(effectIndex), attack, active, this.server);
                    if (attack.getTemporaryEffect() == null) {
                        this.server.setCurrentEffectIndex(this.server.getCurrentEffectIndex() + 1);
                    } else {
                        attack.setTemporaryEffect(null, null);
                        this.server.setCoinFlip(null);
                        this.server.setCurrentEffectIndex(-1);
                        this.server.setEffectsParameters(null);
                    }
                    player.setChoosingOppAttack(false);
                    player.setCardSelectorState(null);
                    opp.setCardSelectorState(null);
                    player.setCardSelectorResult(null);
                    opp.setCardSelectorResult(null);
                }
                return true;
            }
            ArrayList<Pair<CardCondition, Integer>> conditionsEffect = new ArrayList<Pair<CardCondition, Integer>>();
            if (oppPokemon.getStatus().getConditions() != null) {
                conditionsEffect.addAll(oppPokemon.getStatus().getConditions());
            }
            for (Pair<CardCondition, Integer> pair : oppPokemon.getStatus().getClonedConditions()) {
                Optional<Pair> matched = conditionsEffect.stream().filter(p -> p.getLeft() == pair.getLeft()).findFirst();
                if (!matched.isPresent()) continue;
                Integer oldCondition = (Integer)matched.get().getRight();
                Integer newCondition = (Integer)pair.getRight();
                if ((oldCondition != null || newCondition != null) && (oldCondition == null || newCondition == null || !oldCondition.equals(newCondition))) continue;
                conditionsEffect.remove(matched.get());
            }
            int damage = attack.getDamage();
            if (oppPokemon.getWeakness() == active.getMainEnergy()) {
                damage = oppPokemon.getWeaknessModifier().apply(damage, oppPokemon.getWeaknessValue());
            } else if (oppPokemon.getResistance() == active.getMainEnergy()) {
                damage = oppPokemon.getResistanceModifier().apply(damage, oppPokemon.getResistanceValue());
            }
            for (DelayEffect effect : this.server.getDelayEffects()) {
                if (effect.getTurn() != this.server.getTurnCount()) continue;
                damage = effect.getEffect().modifyDamage(damage, effect.getPokemon(), this.server);
            }
            for (CommonCardState attachment : oppPokemon.getAttachments()) {
                if (!(attachment instanceof TrainerCardState)) continue;
                trainer = (TrainerCardState)attachment;
                damage = trainer.getData().getEffect().modifyDamage(damage, trainer, this.server);
            }
            for (CommonCardState attachment : active.getAttachments()) {
                if (!(attachment instanceof TrainerCardState)) continue;
                trainer = (TrainerCardState)attachment;
                damage = trainer.getData().getEffect().modifyDamage(damage, trainer, this.server);
            }
            if (this.server.getOpponent(player).hasItem(TCGItems.scales) && damage > 10) {
                damage = 10;
            }
            int n = oppPokemon.getStatus().getDamage();
            oppPokemon.addDamage(active, damage, this.server);
            int finalDamage = oppPokemon.getStatus().getDamage() - n;
            if (effects != null) {
                for (int i = 0; i < effects.size(); ++i) {
                    BaseAttackEffect effect = effects.get(i);
                    effect.applyAfterDamage(parameters.get(i), attack, active, this.server, finalDamage);
                }
            }
            this.server.getLog().trackAttack(attack.getData(), active, oppPokemon, damage, conditionsEffect, this.server.getTurn(player), this.server);
        } else {
            this.server.getLog().trackAttack(attack.getData(), active, oppPokemon, 0, new ArrayList<Pair<CardCondition, Integer>>(), this.server.getTurn(player), this.server);
        }
        for (DelayEffect effect : this.server.getDelayEffects()) {
            if (effect.getTurn() != this.server.getTurnCount()) continue;
            effect.getEffect().applyDelayAfterDamage(effect.getPokemon(), this.server);
        }
        this.requestEndTurn(player);
        this.server.setCoinFlip(null);
        this.server.setPendingAttack(null);
        this.server.setCurrentEffectIndex(-1);
        this.server.setEffectsParameters(null);
        return true;
    }

    private boolean handlePendingTrainer(PlayerServerState player) {
        BaseTrainerEffect effect;
        TrainerCardState trainer = player.getTrainerCard();
        BaseTrainerEffect baseTrainerEffect = effect = trainer == null ? null : trainer.getData().getEffect();
        if (trainer != null && effect != null) {
            CardSelectorState mySelector;
            if (this.server.getCoinFlip() == null) {
                List<CoinSide> flips = effect.flipCoin();
                this.server.setCoinFlip(new CoinFlipState(flips, this.server.getCurrentTurn()));
                if (flips.isEmpty()) {
                    this.server.setRevealedCoinFlipResults(0);
                } else {
                    this.server.setRevealedCoinFlipResults(1);
                }
            }
            if (this.server.getCoinFlip() != null && !this.server.getCoinFlip().getResults().isEmpty() && this.server.getRevealedCoinFlipResults() <= this.server.getCoinFlip().getResults().size()) {
                this.forceRevealingCoinFlips();
                return true;
            }
            PlayerServerState opp = this.server.getOpponent(player);
            CardSelectorState cardSelectorState = mySelector = player.getCardSelectorState() == null ? effect.getSelectorState(trainer, this.server) : null;
            if (mySelector != null) {
                player.setCardSelectorState(mySelector);
            }
            if (mySelector != null) {
                this.requestSyncGame();
                return true;
            }
            CardSelectorResult selectorResult = player.getCardSelectorResult();
            this.saveSelectorResult(trainer.getParameters(), player, selectorResult);
            if (effect.canApply(trainer, this.server)) {
                CardSelectorState oppSelector;
                CardSelectorState cardSelectorState2 = oppSelector = opp.getCardSelectorState() == null ? effect.getOpponentRevealingSelectorState(trainer, this.server) : null;
                if (oppSelector != null) {
                    opp.setCardSelectorState(oppSelector);
                }
                if (oppSelector != null) {
                    this.requestSyncGame();
                    return true;
                }
                player.setCardSelectorState(null);
                opp.setCardSelectorState(null);
                player.setCardSelectorResult(null);
                opp.setCardSelectorResult(null);
                effect.apply(trainer, this.server);
                if (!effect.preventDiscard()) {
                    player.getDiscardPile().add(trainer.getData());
                }
                player.setTrainerCard(null);
                this.server.setCoinFlip(null);
                return true;
            }
        }
        return false;
    }

    private void saveSelectorResult(List parameters, PlayerServerState player, CardSelectorResult selectorResult) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters cannot be null!");
        }
        if (selectorResult != null && selectorResult.getSelection() != null) {
            if (player.getCardSelectorState() == null) {
                throw new IllegalArgumentException("cardSelectorState cannot be null!");
            }
            if (player.getCardSelectorState().getCardList() == null) {
                throw new IllegalArgumentException("cardSelectorState.cardList cannot be null!");
            }
            List<CardWithLocation> cards = player.getCardSelectorState().getCardList();
            for (int i = 0; i < selectorResult.getSelection().length; ++i) {
                if (!selectorResult.getSelection()[i]) continue;
                parameters.add(cards.get(i).getCard());
            }
            player.setCardSelectorState(null);
            selectorResult.setSelection(null);
        }
    }

    private GamePhase handlePreMatch(GamePhase nextPhase) {
        int readyCount = 0;
        for (PlayerServerState player : this.server.getPlayers()) {
            if (!player.isReady()) continue;
            ++readyCount;
        }
        if (readyCount == 2 && !TCG.EVENT_BUS.post((Event)new StartGameEvent(Arrays.asList(this.server.getPlayers())))) {
            this.server.getPlayer(this.server.getCurrentTurn()).getAvailableActions().setForFirstTurnP1();
            this.setPrizes();
            nextPhase = GamePhase.FirstTurn;
            this.server.getLog().trackStartGame(this.server);
            this.setTurnTimeLimit();
            for (PlayerServerState player0 : this.server.getPlayers()) {
                for (PokemonCardState pokemon : player0.getActiveAndBenchCards()) {
                    if (pokemon.getAbility() != null && pokemon.getAbility().getEffect() != null) {
                        pokemon.getAbility().getEffect().onStartGame(pokemon, this.server);
                    }
                    if (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null) continue;
                    pokemon.getHiddenAbility().getEffect().onStartGame(pokemon, this.server);
                }
            }
        }
        return nextPhase;
    }

    private GamePhase handleFlippingCoin() {
        int i;
        PlayerServerState player;
        this.server.setCurrentTurn(this.coinFlip() ? 0 : 1);
        for (PlayerServerState player2 : this.server.getPlayers()) {
            player2.drawCards(7, this.server);
            this.mulligan(player2, this.server);
            player2.getAvailableActions().setForPreMatch();
        }
        if (this.mulliganDifference > 0) {
            player = this.server.getPlayer(1);
            CardSelectorState mulliganBonus = new CardSelectorState(0, Math.abs(this.mulliganDifference), CardSelectorDisplay.Draw, false);
            for (i = 0; i < Math.abs(this.mulliganDifference); ++i) {
                mulliganBonus.getCardList().add(null);
            }
            player.setCardSelectorState(mulliganBonus);
        } else if (this.mulliganDifference < 0) {
            player = this.server.getPlayer(0);
            CardSelectorState mulliganBonus = new CardSelectorState(0, Math.abs(this.mulliganDifference), CardSelectorDisplay.Draw, false);
            for (i = 0; i < Math.abs(this.mulliganDifference); ++i) {
                mulliganBonus.getCardList().add(null);
            }
            player.setCardSelectorState(mulliganBonus);
        }
        return GamePhase.PreMatch;
    }

    private Queue<Pair<PokemonCardState, Integer>> getCardsWithCondition(CardCondition cardCondition) {
        LinkedList<Pair<PokemonCardState, Integer>> queue = new LinkedList<Pair<PokemonCardState, Integer>>();
        for (int i = 0; i < this.server.getPlayers().length; ++i) {
            for (PokemonCardState card : this.server.getPlayer(i).getActiveAndBenchCards()) {
                if (!card.getStatus().getConditions().stream().anyMatch(s -> s.getLeft() == cardCondition)) continue;
                queue.add((Pair<PokemonCardState, Integer>)new ImmutablePair((Object)card, (Object)i));
            }
        }
        return queue;
    }

    @Override
    public void requestEndTurn(PlayerServerState player) {
        player.setInGUI(true);
        if (this.server.getGamePhase() == GamePhase.PreMatch) {
            player.setReady(true);
        } else {
            this.readyToEndTurn = true;
        }
    }

    private void requestSyncGame() {
        this.syncGameTime = 0L;
    }

    private void newGame() {
        this.server = new GameServerState();
        this.server.setGamePhase(GamePhase.FlippingCoin);
        this.init = true;
        this.readyToEndTurn = false;
    }

    @Override
    public void endGame(PlayerServerState winner, PlayerServerState loser, boolean tiedGame) {
        if (winner != null && loser != null) {
            TCG.EVENT_BUS.post((Event)new EndGameEvent(winner, loser, tiedGame));
            if (tiedGame) {
                TitleHelper.showTitle((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "You tied!"), (ServerPlayerEntity)winner.getEntityPlayer());
                TitleHelper.showTitle((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "You tied!"), (ServerPlayerEntity)loser.getEntityPlayer());
                ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "[TCG] " + TextFormatting.GREEN + winner.getEntityPlayer().func_145748_c_().getString() + " just tied with " + loser.getEntityPlayer().func_145748_c_().getString() + "!"), ChatType.CHAT, Util.field_240973_b_);
                this.server.getLog().trackStalemate(this.server);
            } else {
                TitleHelper.showTitle((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "You win!"), (ServerPlayerEntity)winner.getEntityPlayer());
                TitleHelper.showTitle((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "You lose!"), (ServerPlayerEntity)loser.getEntityPlayer());
                ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "[TCG] " + TextFormatting.GREEN + winner.getEntityPlayer().func_145748_c_().getString() + " just won against " + loser.getEntityPlayer().func_145748_c_().getString() + "!"), ChatType.CHAT, Util.field_240973_b_);
                this.server.getLog().trackEndGame(this.server.getTurn(winner), this.server);
                if (this.endingCommand != null) {
                    this.trigger(this.func_145831_w(), this.endingCommand, winner.getPlayerName(), loser.getPlayerName());
                }
            }
        }
        if (this.server != null) {
            for (PlayerServerState player : this.server.getPlayers()) {
                if (player == null) continue;
                NetworkHelper.sendPacket(new EndGamePacket(this.field_174879_c), (ServerPlayerEntity)player.getEntityPlayer());
            }
            for (UUID spectator : this.server.getSpectators().keySet()) {
                PlayerHelper.getPlayer(spectator).ifPresent(p -> NetworkHelper.sendPacket(new EndGamePacket(this.field_174879_c), p));
            }
        }
        this.newGame();
        this.sendRenderSyncPackets();
    }

    private void endTurn() {
        if (this.server.getGamePhase().after(GamePhase.PreMatch)) {
            for (PlayerServerState player : this.server.getPlayers()) {
                for (PokemonCardState pokemon : player.getActiveAndBenchCards()) {
                    pokemon.handleEndTurn(null, player, this.server);
                    for (CommonCardState attachment : pokemon.getAttachments().toArray(new CommonCardState[0])) {
                        attachment.handleEndTurn(pokemon, player, this.server);
                    }
                }
            }
            TCG.EVENT_BUS.post((Event)new EndTurnEvent(this.server.getPlayer(this.server.getCurrentTurn()), this.server.getCurrentTurn()));
            this.server.getPlayer(this.server.getCurrentTurn()).setAreTrainersDisabled(false);
            this.server.setGamePhase(GamePhase.BetweenTurns);
        }
        this.readyToEndTurn = false;
    }

    private boolean coinFlip() {
        return RandomHelper.getRandomChance(0.5f);
    }

    private boolean checkKnockedOut(PlayerServerState player, PokemonCardState card, MutableInt prizeCount) {
        if (card.getStatus().getDamage() >= card.getHP()) {
            for (CommonCardState commonCardState : card.getAttachments()) {
                player.getDiscardPile().add(commonCardState.getData());
            }
            boolean isAttached = false;
            block1: for (PokemonCardState pokemon : player.getActiveAndBenchCards()) {
                for (CommonCardState attachment : pokemon.getAttachments()) {
                    if (attachment != card) continue;
                    isAttached = true;
                    continue block1;
                }
            }
            if (!isAttached) {
                player.getDiscardPile().add(card.getData());
            }
            PlayerServerState playerServerState = this.server.getOpponent(player);
            ChatHandler.sendFormattedChat((ICommandSource)player.getEntityPlayer(), TextFormatting.RED, "Your " + card.getData().getTranslatedName().getString() + " has fainted!", new Object[0]);
            ChatHandler.sendFormattedChat((ICommandSource)playerServerState.getEntityPlayer(), TextFormatting.YELLOW, "You have knocked out " + card.getData().getTranslatedName().getString() + "!", new Object[0]);
            if (card.getData().getCardType() == CardType.TRAINER) {
                return true;
            }
            prizeCount.increment();
            if (playerServerState.hasItem(TCGItems.ring)) {
                prizeCount.increment();
            }
            if (card.getCardType() == CardType.EX) {
                prizeCount.increment();
                if (playerServerState.hasItem(TCGItems.ring)) {
                    prizeCount.increment();
                }
            }
            this.server.getLog().trackKnockout(card, this.server.getTurn(playerServerState), this.server);
            return true;
        }
        return false;
    }

    public void sendRenderPreBattleSyncPackets() {
        NetworkHelper.sendNearbyPacket(new TargetPoint(this.func_145831_w(), this.field_174879_c, 50.0).toMojang(), new RenderStatePreBattleSyncPacket(this.field_174879_c, this));
    }

    public void sendRenderSyncPackets() {
        NetworkHelper.sendNearbyPacket(new TargetPoint(this.func_145831_w(), this.field_174879_c, 50.0), p -> new RenderStateSyncPacket(this.field_174879_c, this.server, (PlayerEntity)p, this));
    }

    public void setPrizes() {
        for (PlayerServerState player : this.server.getPlayers()) {
            ImmutableCard[] cards = new ImmutableCard[this.prizeCount];
            for (int x = 0; x < this.prizeCount; ++x) {
                cards[x] = player.getDeck().get(0);
                player.getDeck().remove(0);
            }
            player.setPrizeCards(cards);
        }
    }

    public void mulligan(PlayerServerState player, GameServerState server) {
        while (!this.doesCardListContainCardType(player.getHand(), CardType.BASIC) && !this.doesCardListContainCardType(player.getHand(), CardType.EX)) {
            player.getDeck().addAll(player.getHand());
            CardSelectorState failedHand = new CardSelectorState(0, 0, CardSelectorDisplay.Select, false);
            for (ImmutableCard c : player.getHand()) {
                failedHand.getCardList().add(new CardWithLocation(new CommonCardState(c), false, BoardLocation.Hand, 0));
            }
            if (player == server.getPlayer(0)) {
                this.mulliganStates1.add(failedHand);
            } else {
                this.mulliganStates0.add(failedHand);
            }
            player.getHand().clear();
            LogicHelper.shuffleCardList(player.getDeck());
            player.drawCards(7, server);
            if (server.getPlayer(0) == player) {
                ++this.mulliganDifference;
                continue;
            }
            --this.mulliganDifference;
        }
    }

    @Override
    public void playCardFromHandToActive(PlayerServerState player, int cardIndex, ImmutableCard check) {
        List<ImmutableCard> hand = player.getHand();
        ImmutableCard card = hand.get(cardIndex);
        if (card != check) {
            return;
        }
        if (this.server.getGamePhase() != GamePhase.PreMatch && !this.server.isCurrentTurn(player)) {
            return;
        }
        PokemonCardState newActiveCard = null;
        AvailableActions availableActions = player.getAvailableActions();
        PokemonCardState activeCard = player.getActiveCard();
        switch (card.getCardType()) {
            case EX: 
            case BASIC: {
                if (activeCard != null) break;
                newActiveCard = new PokemonCardState(card, this.server.getTurnCount());
                player.setActiveCard(newActiveCard);
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                hand.remove(cardIndex);
                this.server.getLog().trackPlayCard(player.getActiveCard(), this.server.getTurn(player), this.server);
                break;
            }
            case ENERGY: {
                if (!availableActions.isCanPlayEnergy() || activeCard == null) break;
                CommonCardState cardState = new CommonCardState(card);
                activeCard.getAttachments().add(cardState);
                if (player.hasItem(TCGItems.key)) {
                    CommonCardState cardState2 = new CommonCardState(card);
                    activeCard.getAttachments().add(cardState2);
                }
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                hand.remove(cardIndex);
                availableActions.setCanPlayEnergy(false);
                this.server.getLog().trackAttachCard(cardState, activeCard, this.server.getTurn(player), this.server);
                break;
            }
            case TOOL: {
                if (activeCard == null) break;
                activeCard.getAttachments().add(new CommonCardState(card));
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                hand.remove(cardIndex);
                break;
            }
            case TRAINER: {
                TrainerCardState trainerState;
                if (player.getAvailableActions().isCanPlayTrainer() && card.getEffect() != null && card.getEffect().canPlay(this.server) && (trainerState = new TrainerCardState(card)).getData().getEffect().canSkipSelector() && trainerState.getData().getEffect().canPlaceOn(new CardWithLocation(activeCard, true, BoardLocation.Active, 0))) {
                    trainerState.getData().getEffect().applySkipSelector(trainerState, activeCard, this.server, BoardLocation.Active, 0);
                    this.server.getLog().trackPlayCard(trainerState, this.server.getTurn(player), this.server);
                    if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                        this.server.getOpponent(player).getHand().add(card);
                    }
                    hand.remove(cardIndex);
                    ServerPlayerEntity entityPlayer = (ServerPlayerEntity)this.server.getOpponent(player).getEntityPlayer();
                    NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainerState), entityPlayer);
                    for (UUID spectator : this.server.getSpectators().keySet()) {
                        NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainerState), ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(spectator));
                    }
                    if (!trainerState.getData().getEffect().preventDiscard()) {
                        player.getDiscardPile().add(trainerState.getData());
                    }
                }
            }
            case STAGE1: 
            case STAGE2: 
            case LVLX: 
            case MEGA: {
                if (activeCard == null || activeCard.getPokemonID() != card.getPreviousEvolutionDexID() || !LogicHelper.canEvolve(activeCard.getTurn(), this.server.getTurnCount()) || new GameClientState(this.server).isDisablingEvolution(activeCard)) break;
                newActiveCard = LogicHelper.evolveCard(card, activeCard, this.server.getTurnCount());
                this.server.getLog().trackEvolve(activeCard, newActiveCard, this.server.getTurn(player), this.server);
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                player.setActiveCard(newActiveCard);
                player.getActiveCard().getParameters().clear();
                hand.remove(cardIndex);
            }
        }
        if (newActiveCard != null) {
            for (PlayerServerState player0 : this.server.getPlayers()) {
                for (PokemonCardState pokemon : player0.getActiveAndBenchCards()) {
                    if (pokemon.getAbility() != null && pokemon.getAbility().getEffect() != null) {
                        pokemon.getAbility().getEffect().onPlay(newActiveCard, player, pokemon, player0, this.server);
                        pokemon.getAbility().getEffect().onSwitchActiveCard(newActiveCard, activeCard, player, pokemon, player0, this.server);
                    }
                    if (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null) continue;
                    pokemon.getHiddenAbility().getEffect().onPlay(newActiveCard, player, pokemon, player0, this.server);
                    pokemon.getHiddenAbility().getEffect().onSwitchActiveCard(newActiveCard, activeCard, player, pokemon, player0, this.server);
                }
            }
        }
    }

    @Override
    public void playPokemonCardToBench(PlayerServerState player, int cardIndex, ImmutableCard check, int benchIndex) {
        List<ImmutableCard> hand = player.getHand();
        ImmutableCard card = hand.get(cardIndex);
        if (card != check) {
            return;
        }
        if (this.server.getGamePhase() != GamePhase.PreMatch && !this.server.isCurrentTurn(player)) {
            return;
        }
        if (player.getActiveCard() == null) {
            return;
        }
        AvailableActions availableActions = player.getAvailableActions();
        PokemonCardState[] benchCards = player.getBenchCards();
        PokemonCardState benchCard = benchCards[benchIndex];
        PokemonCardState newBenchCard = null;
        switch (card.getCardType()) {
            case EX: 
            case BASIC: {
                if (benchCard != null) break;
                benchCards[benchIndex] = newBenchCard = new PokemonCardState(card, this.server.getTurnCount());
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                hand.remove(cardIndex);
                this.server.getLog().trackPlayCard(benchCards[benchIndex], this.server.getTurn(player), this.server);
                break;
            }
            case ENERGY: {
                if (benchCard == null || !availableActions.isCanPlayEnergy()) break;
                CommonCardState cardState = new CommonCardState(card);
                benchCard.getAttachments().add(cardState);
                if (player.hasItem(TCGItems.key)) {
                    CommonCardState cardState2 = new CommonCardState(card);
                    benchCard.getAttachments().add(cardState2);
                }
                this.server.getLog().trackAttachCard(cardState, benchCard, this.server.getTurn(player), this.server);
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(cardState.getData());
                }
                hand.remove(cardIndex);
                availableActions.setCanPlayEnergy(false);
                break;
            }
            case ITEM: {
                if (benchCard == null || !availableActions.isCanPlayItem()) break;
                CommonCardState cardState = new CommonCardState(card);
                benchCard.getAttachments().add(cardState);
                this.server.getLog().trackAttachCard(cardState, benchCard, this.server.getTurn(player), this.server);
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                hand.remove(cardIndex);
                break;
            }
            case TRAINER: {
                TrainerCardState trainerState;
                if (player.getAvailableActions().isCanPlayTrainer() && card.getEffect() != null && card.getEffect().canPlay(this.server) && (trainerState = new TrainerCardState(card)).getData().getEffect().canSkipSelector() && trainerState.getData().getEffect().canPlaceOn(new CardWithLocation(benchCard, true, BoardLocation.Bench, benchIndex))) {
                    trainerState.getData().getEffect().applySkipSelector(trainerState, benchCard, this.server, BoardLocation.Bench, benchIndex);
                    this.server.getLog().trackPlayCard(trainerState, this.server.getTurn(player), this.server);
                    if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                        this.server.getOpponent(player).getHand().add(card);
                    }
                    hand.remove(cardIndex);
                    ServerPlayerEntity entityPlayer = (ServerPlayerEntity)this.server.getOpponent(player).getEntityPlayer();
                    NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainerState), entityPlayer);
                    for (UUID spectator : this.server.getSpectators().keySet()) {
                        PlayerHelper.getPlayer(spectator).ifPresent(p -> NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainerState), p));
                    }
                    if (!trainerState.getData().getEffect().preventDiscard()) {
                        player.getDiscardPile().add(trainerState.getData());
                    }
                }
            }
            case STAGE1: 
            case STAGE2: 
            case LVLX: 
            case MEGA: {
                if (benchCard == null || benchCard.getPokemonID() != card.getPreviousEvolutionDexID() || !LogicHelper.canEvolve(benchCard.getTurn(), this.server.getTurnCount()) || new GameClientState(this.server).isDisablingEvolution(benchCard)) break;
                newBenchCard = LogicHelper.evolveCard(card, benchCard, this.server.getTurnCount());
                this.server.getLog().trackEvolve(benchCard, newBenchCard, this.server.getTurn(player), this.server);
                if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                    this.server.getOpponent(player).getHand().add(card);
                }
                benchCards[benchIndex] = newBenchCard;
                player.getBenchCards()[benchIndex].getParameters().clear();
                hand.remove(cardIndex);
            }
        }
        if (newBenchCard != null) {
            for (PlayerServerState player0 : this.server.getPlayers()) {
                for (PokemonCardState pokemon : player0.getActiveAndBenchCards()) {
                    if (pokemon.getAbility() != null && pokemon.getAbility().getEffect() != null) {
                        pokemon.getAbility().getEffect().onPlay(newBenchCard, player, pokemon, player0, this.server);
                    }
                    if (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null) continue;
                    pokemon.getHiddenAbility().getEffect().onPlay(newBenchCard, player, pokemon, player0, this.server);
                }
            }
        }
    }

    @Override
    public void playTrainerCard(PlayerServerState player, int cardIndex, ImmutableCard check) {
        List<ImmutableCard> hand = player.getHand();
        ImmutableCard card = hand.get(cardIndex);
        if (card != check) {
            return;
        }
        if (!this.server.isCurrentTurn(player)) {
            return;
        }
        if (player.getAvailableActions().isCanPlayTrainer() && card.getCardType() == CardType.TRAINER && card.getEffect() != null && card.getEffect().canPlay(this.server)) {
            TrainerCardState trainer = new TrainerCardState(card);
            player.setTrainerCard(trainer);
            this.server.getLog().trackPlayCard(trainer, this.server.getTurn(player), this.server);
            if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                this.server.getOpponent(player).getHand().add(card);
            }
            hand.remove(cardIndex);
            ServerPlayerEntity entityPlayer = (ServerPlayerEntity)this.server.getOpponent(player).getEntityPlayer();
            NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainer), entityPlayer);
            for (UUID spectator : this.server.getSpectators().keySet()) {
                PlayerHelper.getPlayer(spectator).ifPresent(p -> NetworkHelper.sendPacket(new TrainerPlayedPacket(player.getPlayerName(), trainer), p));
            }
        }
    }

    @Override
    public void playStadiumCard(PlayerServerState player, int cardIndex, ImmutableCard check) {
        List<ImmutableCard> hand = player.getHand();
        ImmutableCard card = hand.get(cardIndex);
        if (card != check) {
            return;
        }
        if (!this.server.isCurrentTurn(player)) {
            return;
        }
        if (card.getCardType() == CardType.STADIUM) {
            this.server.setStadiumCard(card);
            if (this.server.getOpponent(player).hasItem(TCGItems.rod)) {
                this.server.getOpponent(player).getHand().add(card);
            }
            hand.remove(cardIndex);
        }
    }

    @Override
    public void requestAbility(int playerIndex, BoardLocation location, int locationIndex) {
        PokemonCardState pokemon;
        for (PlayerServerState player : this.server.getPlayers()) {
            if (player.getActiveCard() != null) continue;
            return;
        }
        PlayerServerState player = this.server.getPlayer(playerIndex);
        if (location == BoardLocation.Active) {
            pokemon = player.getActiveCard();
        } else if (location == BoardLocation.Bench) {
            pokemon = player.getBenchCards()[locationIndex];
        } else {
            return;
        }
        if (pokemon.getAbility() == null || pokemon.getAbility().getEffect() == null || pokemon.getAbility().getEffect().isPassive() || !pokemon.getAbility().getEffect().isEnabled(pokemon, new GameClientState(this.server))) {
            return;
        }
        this.getGameServer().setPendingAbility(pokemon);
    }

    @Override
    public void requestAttack(int playerIndex, int attackIndex) {
        for (PlayerServerState player : this.server.getPlayers()) {
            if (player.getActiveCard() != null) continue;
            return;
        }
        PlayerServerState player = this.server.getPlayer(playerIndex);
        PokemonCardState active = player.getActiveCard();
        if (active.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.ASLEEP || c.getLeft() == CardCondition.PARALYZED)) {
            return;
        }
        PokemonAttackStatus attack = active.getAttacksStatus()[attackIndex];
        if (attack == null) {
            throw new IllegalArgumentException("Cannot find attack index " + attackIndex);
        }
        if (attack.isDisabled() || !LogicHelper.isEnoughEnergy(attack.getData(), active.getAttachments(), active)) {
            return;
        }
        this.server.setPendingAttack(new PendingAttack(player, active, attack));
    }

    @Override
    public void requestPickAttack(int playIndex, int attackIndex) {
        PlayerServerState player = this.server.getPlayer(this.server.getCurrentTurn());
        PlayerServerState opp = this.server.getPlayer(this.server.getNextTurn());
        this.server.getEffectsParameters().get(this.server.getCurrentEffectIndex()).add(opp.getActiveCard().getAttacksStatus()[attackIndex]);
        player.setChoosingOppAttack(false);
    }

    private void sendGameSyncPackets() {
        for (int playerIndex = 0; playerIndex < 2; ++playerIndex) {
            PlayerServerState player = this.server.getPlayer(playerIndex);
            NetworkHelper.sendPacket(new GameStateSyncPacket(this.field_174879_c, playerIndex, false, this.server, player.getEntityPlayer()), (ServerPlayerEntity)player.getEntityPlayer());
        }
    }

    private void sendGameSyncPacketsToSpectators() {
        for (UUID spectator : this.server.getSpectators().keySet()) {
            int playerIndex = this.server.getSpectators().get(spectator);
            PlayerServerState player = this.server.getPlayer(playerIndex);
            PlayerHelper.getPlayer(spectator).ifPresent(p -> NetworkHelper.sendPacket(new GameStateSyncPacket(this.field_174879_c, playerIndex, true, this.server, player.getEntityPlayer()), p));
        }
    }

    @Override
    public void requestRetreatAndSwitch(PlayerServerState player, List<CommonCardState> energyPayment, int benchIndex) {
        if (player.getAvailableActions().isCanRetreatActive() && player.getBenchCards()[benchIndex] != null && player.getActiveCard().getAttachments().containsAll(energyPayment) && player.getActiveCard().canRetreat()) {
            for (CommonCardState energy : energyPayment) {
                player.getActiveCard().getAttachments().remove(energy);
                player.getDiscardPile().add(energy.getData());
            }
            player.switchActive(player.getBenchCards()[benchIndex], this.server);
            player.getAvailableActions().setCanRetreatActive(false);
        }
    }

    @Override
    public void requestSwitch(PlayerServerState player, int benchIndex) {
        if (player.getBenchCards()[benchIndex] != null) {
            player.switchActive(player.getBenchCards()[benchIndex], this.server);
        }
    }

    @Override
    public void setCardSelection(PlayerEntity entityPlayer, boolean isOpened, boolean[] cardSelection) {
        PlayerServerState player = this.server.getPlayer((ServerPlayerEntity)entityPlayer);
        if (player.getCardSelectorState() == null) {
            return;
        }
        if (player.getCardSelectorResult() == null) {
            player.setCardSelectorResult(new CardSelectorResult());
        }
        player.getCardSelectorResult().setOpened(isOpened);
        player.getCardSelectorResult().setSelection(cardSelection);
    }

    @Override
    public void setPrizeSelection(PlayerEntity entityPlayer, int index) {
        PlayerServerState player = this.server.getPlayer((ServerPlayerEntity)entityPlayer);
        if (player != null && player.getPendingPrizeCount() > 0) {
            player.setOpeningPrizeIndex(index);
        }
    }

    @Override
    public void setCustomGUIResult(PlayerEntity entityPlayer, boolean isOpened, int[] result) {
        PlayerServerState player = this.server.getPlayer((ServerPlayerEntity)entityPlayer);
        if (player.getCustomGUIResult() == null) {
            player.setCustomGUIResult(new CustomGUIResult());
        }
        player.getCustomGUIResult().setOpened(isOpened);
        player.getCustomGUIResult().setResult(result);
    }

    @Override
    public void requestFlip(PlayerServerState player) {
        this.server.setRevealedCoinFlipResults(this.server.getRevealedCoinFlipResults() + 1);
    }

    @Override
    public String formatCommand(String command, String winnerName, String loserName) {
        return command.replace(" @player1 ", " " + winnerName + " ").replace(" @player2 ", " " + loserName + " ").replace(" @winner ", " " + winnerName + " ").replace(" @loser ", " " + loserName + " ");
    }

    @Override
    public void discard(PlayerServerState player, BoardLocation location, int locationSubIndex) {
        PokemonCardState card = player.getCard(location, locationSubIndex);
        for (CommonCardState attachment : card.getAttachments()) {
            player.getDiscardPile().add(attachment.getData());
        }
        player.getDiscardPile().add(card.getData());
        switch (location) {
            case Active: {
                player.setActiveCard(null);
                break;
            }
            case Bench: {
                player.getBenchCards()[locationSubIndex] = null;
            }
        }
        this.server.getLog().trackDiscard(card, this.server.getCurrentTurn(), this.server);
    }

    private void forceRevealingCoinFlips() {
        if (this.server.exceedTimeLimit()) {
            this.server.setRevealedCoinFlipResults(this.server.getCoinFlip().getResults().size() + 1);
        }
    }
}

