/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.listener;

import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.client.container.BinderContainer;
import com.pixelmonmod.tcg.client.container.DeckContainer;
import com.pixelmonmod.tcg.tileentity.EssenceJarTileEntity;
import java.awt.Color;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TCGServerEventListeners {
    @SubscribeEvent
    public void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().field_71070_bA instanceof BinderContainer) {
            ((BinderContainer)event.getPlayer().field_71070_bA).binder.inventory.func_174886_c(event.getPlayer());
        }
        if (event.getPlayer().field_71070_bA instanceof DeckContainer) {
            ((DeckContainer)event.getPlayer().field_71070_bA).inventory.func_174886_c(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onKnockoutEvent(BeatWildPixelmonEvent event) {
        int essence = 0;
        for (PixelmonWrapper wrapper : event.wpp.allPokemon) {
            essence += TCGConfigProxy.getConfig().getEssenceDropped(wrapper.pokemon.isLegendary() || wrapper.pokemon.isMythical() || wrapper.pokemon.isUltraBeast());
        }
        for (ItemStack stack : event.player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != TCGBlocks.essence_jar.func_199767_j() || (essence = EssenceJarBlock.addEssence(stack, essence, event.player)) > 0) continue;
            return;
        }
        ServerWorld world = event.player.func_71121_q();
        ChunkPos origin = new ChunkPos(event.player.func_233580_cy_());
        double radius = TCGConfigProxy.getConfig().getEssenceRadius();
        double radiusSqr = radius * radius;
        int chunkRadius = (int)(radius / 16.0) + 1;
        TreeMap<Double, EssenceJarTileEntity> jars = new TreeMap<Double, EssenceJarTileEntity>();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                IChunk chunk = world.func_217353_a(origin.field_77276_a + x, origin.field_77275_b + z, ChunkStatus.field_222617_m, false);
                if (chunk == null) continue;
                for (BlockPos pos : chunk.func_203066_o()) {
                    TileEntity te;
                    double dist = pos.func_177951_i((Vector3i)event.player.func_233580_cy_());
                    if (!(dist <= radiusSqr) || !((te = chunk.func_175625_s(pos)) instanceof EssenceJarTileEntity)) continue;
                    jars.put(dist, (EssenceJarTileEntity)te);
                }
            }
        }
        for (EssenceJarTileEntity jar : jars.values()) {
            essence = jar.addEssence(essence);
            if (essence > 0) continue;
            return;
        }
    }

    public static void playEssenceJarEffect(int totalEssence, int essence, int current, int target, ServerWorld world, BlockPos pos, Color color) {
        int added = essence - Math.max(0, current - target);
        if (added > 0) {
            int i;
            for (i = 0; i < added; ++i) {
                world.func_195598_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.65, (double)pos.func_177952_p() + 0.5, 0, (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f), 1.0);
            }
            if (totalEssence >= target) {
                for (i = 0; i < 10; ++i) {
                    world.func_195598_a((IParticleData)new RedstoneParticleData((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, RandomHelper.getRandom().nextFloat() + 1.0f), (double)pos.func_177958_n() + 0.5 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, (double)pos.func_177956_o() + 0.4 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.5, (double)pos.func_177952_p() + 0.5 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, 0, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, 1.0);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.75f, 1.5f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187621_J, SoundCategory.BLOCKS, Math.min(2.0f, 0.25f * (float)added), 1.0f);
            }
        }
    }
}

