/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.List;

public class Recycle
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return client.getMe().getDeckSize() > 0;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false);
        for (int i = 0; i < me.getDiscardPile().size(); ++i) {
            if (me.getDiscardPile().get(i).getCardType() != CardType.TRAINER) continue;
            selector.getCardList().add(new CardWithLocation(new CommonCardState(me.getDiscardPile().get(i)), true, BoardLocation.DiscardPile, i));
        }
        return selector;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        if (server.getPlayer(server.getCurrentTurn()).getDeck().isEmpty()) {
            return true;
        }
        return trainer.getParameters().size() == 1;
    }

    @Override
    public List<CoinSide> flipCoin() {
        ArrayList<CoinSide> coin = new ArrayList<CoinSide>();
        coin.add(CoinSide.getRandom());
        return coin;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        if (trainer.getParameters().size() != 1) {
            return;
        }
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        ImmutableCard card = trainer.getParameters().get(0).getData();
        if (this.isCorrectCoinSide(server)) {
            me.getDeck().add(0, card);
            me.getDiscardPile().remove(card);
        }
    }

    private boolean isCorrectCoinSide(GameServerState server) {
        return server.getCoinFlip() != null && server.getCoinFlip().getResults().get(0) == CoinSide.Head;
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

