/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class Maintenance
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return client.getMe().getHand().size() >= 3;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        return SelectorHelper.generateSelectorForDiscardFromHand(server.getPlayer(server.getCurrentTurn()), 2, "trainer.maintenance.selector.choose");
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == 2;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        CommonCardState card1 = trainer.getParameters().get(0);
        CommonCardState card2 = trainer.getParameters().get(1);
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        me.getHand().remove(card1.getData());
        me.getHand().remove(card2.getData());
        me.getDeck().add(card1.getData());
        me.getDeck().add(card2.getData());
        LogicHelper.shuffleCardList(me.getDeck());
        me.drawCards(1, server);
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

