/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;

public class EnergyTransfer
extends BasePowerEffect {
    public EnergyTransfer() {
        super("EnergyTransfer");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        return super.isEnabled(pokemon, client) && client.getMe().getActiveAndBenchCards().size() > 1 && pokemon.getAttachments().stream().anyMatch(c -> c.getCardType() == CardType.ENERGY && c.getMainEnergy() == Energy.GRASS && c.getSecondaryEnergy() == null);
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        switch (pokemon.getParameters().size()) {
            case 0: {
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.energytransfer.selector.from");
                for (CardWithLocation location2 : server.getPlayer(server.getCurrentTurn()).getActiveAndBenchCards(true)) {
                    PokemonCardState card = (PokemonCardState)location2.getCard();
                    if (!card.getAttachments().stream().anyMatch(c -> c.getCardType() == CardType.ENERGY && c.getMainEnergy() == Energy.GRASS && c.getSecondaryEnergy() == null)) continue;
                    selector.getCardList().add(location2);
                }
                return selector;
            }
            case 1: {
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.energytransfer.selector.to");
                server.getPlayer(server.getCurrentTurn()).getActiveAndBenchCards(true).stream().filter(location -> location.getCard() != pokemon.getParameters().get(0)).forEach(location -> selector.getCardList().add((CardWithLocation)location));
                return selector;
            }
        }
        return null;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return pokemon.getParameters().size() == 2;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        PokemonCardState from = (PokemonCardState)pokemon.getParameters().get(0);
        PokemonCardState to = (PokemonCardState)pokemon.getParameters().get(1);
        CommonCardState energy = from.getAttachments().stream().filter(c -> c.getCardType() == CardType.ENERGY && c.getMainEnergy() == Energy.GRASS && c.getSecondaryEnergy() == null).findFirst().get();
        from.getAttachments().remove(energy);
        to.getAttachments().add(energy);
    }
}

