/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;
import java.util.stream.Collectors;

public class DamageSwapToSelfOnly
extends BasePowerEffect {
    public DamageSwapToSelfOnly() {
        super("DamageSwapToSelfOnly");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        if (!super.isEnabled(pokemon, client)) {
            return false;
        }
        List hasDamage = client.getMe().getActiveAndBenchCards().stream().filter(c -> c.getStatus().getDamage() > 0).collect(Collectors.toList());
        if (hasDamage.size() == 0) {
            return false;
        }
        if (hasDamage.contains(pokemon)) {
            hasDamage.remove(pokemon);
        }
        if (hasDamage.size() == 0) {
            return false;
        }
        return pokemon.getStatus().getDamage() + 10 < pokemon.getHP();
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.damageswap.selector.from");
        player.getActiveAndBenchCards(true).stream().filter(location -> ((PokemonCardState)location.getCard()).getStatus().getDamage() > 0 && location.getCard() != pokemon).forEach(location -> selector.getCardList().add((CardWithLocation)location));
        return selector;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return pokemon.getParameters().size() == 1;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        PokemonCardState fromPokemon = (PokemonCardState)pokemon.getParameters().get(0);
        fromPokemon.getStatus().healDamage(10);
        pokemon.getStatus().setDamage(pokemon.getStatus().getDamage() + 10);
    }
}

