/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class Bounce
extends BasePowerEffect {
    public Bounce() {
        super("Bounce");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        return LogicHelper.canEvolve(pokemon.getTurn(), client.getTurnCount());
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState server) {
        return true;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        for (PokemonCardState card : player.getActiveAndBenchCards()) {
            List<CommonCardState> cards = card.getAttachments();
            if (pokemon != card) continue;
            if (player.isInBench(card)) {
                for (int i = 0; i < player.getBenchCards().length; ++i) {
                    if (player.getBenchCards()[i] != pokemon) continue;
                    player.getHand().add(player.getBenchCards()[i].getData());
                    for (CommonCardState attach : cards) {
                        player.getDiscardPile().add(attach.getData());
                        player.getBenchCards()[i].getAttachments().remove(attach);
                    }
                    player.getBenchCards()[i] = null;
                }
                continue;
            }
            if (player.getActiveCard() != pokemon) continue;
            player.getHand().add(player.getActiveCard().getData());
            for (CommonCardState attach : cards) {
                player.getDiscardPile().add(attach.getData());
            }
            player.getActiveCard().getAttachments().clear();
            player.setActiveCard(null);
        }
    }
}

