/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.log.parameters;

import com.pixelmonmod.tcg.api.accessors.CardAttacks;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogParameters;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DuelLogAttackParameters
extends DuelLogParameters {
    private final CardAttack cardAttack;
    private final PokemonCardState attacker;
    private final PokemonCardState attacking;
    private final int damage;
    private final List<Pair<CardCondition, Integer>> conditions;

    public DuelLogAttackParameters(CardAttack cardAttack, PokemonCardState attacker, PokemonCardState attacking, int damage, List<Pair<CardCondition, Integer>> conditions) {
        this.cardAttack = cardAttack;
        this.attacker = attacker;
        this.attacking = attacking;
        this.damage = damage;
        this.conditions = conditions;
    }

    public DuelLogAttackParameters(PacketBuffer buf) {
        this.cardAttack = CardAttacks.get(buf.func_218666_n());
        this.attacker = new PokemonCardState(ByteBufTCG.readCard(buf), 0);
        this.attacking = new PokemonCardState(ByteBufTCG.readCard(buf), 0);
        this.damage = buf.readInt();
        if (buf.readBoolean()) {
            int count = buf.readInt();
            this.conditions = new ArrayList<Pair<CardCondition, Integer>>();
            for (int i = 0; i < count; ++i) {
                CardCondition cardCondition = CardCondition.values()[buf.readInt()];
                Integer modifier = null;
                if (buf.readBoolean()) {
                    modifier = buf.readInt();
                }
                this.conditions.add((Pair<CardCondition, Integer>)new ImmutablePair((Object)cardCondition, (Object)modifier));
            }
        } else {
            this.conditions = null;
        }
    }

    @Override
    public void write(PacketBuffer buf, GamePhase gamePhase, int itemPlayerIndex, int receiverIndex, boolean isMyTurn) {
        buf.func_180714_a(this.cardAttack.getID());
        ByteBufTCG.writeCard(buf, this.attacker.getData());
        ByteBufTCG.writeCard(buf, this.attacking.getData());
        buf.writeInt(this.damage);
        buf.writeBoolean(this.conditions != null);
        if (this.conditions != null) {
            buf.writeInt(this.conditions.size());
            for (Pair<CardCondition, Integer> pair : this.conditions) {
                buf.writeInt(((CardCondition)((Object)pair.getLeft())).ordinal());
                buf.writeBoolean(pair.getRight() != null);
                if (pair.getRight() == null) continue;
                buf.writeInt(((Integer)pair.getRight()).intValue());
            }
        }
    }

    public CardAttack getAttack() {
        return this.cardAttack;
    }

    public PokemonCardState getAttacker() {
        return this.attacker;
    }

    public PokemonCardState getAttacking() {
        return this.attacking;
    }

    public int getDamage() {
        return this.damage;
    }

    public List<Pair<CardCondition, Integer>> getConditions() {
        return this.conditions;
    }
}

