/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;

public class FindPokemonEffect
extends BaseAttackEffect {
    private static final String CODE = "FIND_POKEMON";
    private int count;
    private Type type;
    private List<Integer> pokedexNumbers;
    private Energy energy;

    public FindPokemonEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        int emptySlot = 0;
        for (PokemonCardState pokemonCardState : player.getBenchCards()) {
            if (pokemonCardState != null) continue;
            ++emptySlot;
        }
        int realCount = Math.min(this.count, emptySlot);
        if (realCount == 0) {
            return null;
        }
        CardSelectorState selector = new CardSelectorState(1, realCount, CardSelectorDisplay.Draw, false);
        for (int i = 0; i < player.getDeck().size(); ++i) {
            ImmutableCard immutableCard = player.getDeck().get(i);
            if (!immutableCard.isPokemonCard() || (this.type != Type.ByPokemon || !this.pokedexNumbers.contains(immutableCard.getPokemonID())) && (this.type != Type.ByType || immutableCard.getMainEnergy() != this.energy || immutableCard.getCardType() != CardType.BASIC)) continue;
            selector.getCardList().add(new CardWithLocation(new CommonCardState(immutableCard), true, BoardLocation.Deck, i));
        }
        if (selector.getCardList().isEmpty()) {
            return null;
        }
        return selector;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        CardSelectorState selector = this.getSelectorState(parameters, server);
        return selector == null || parameters.size() > 0;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (parameters == null) {
            return;
        }
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        for (Object obj : parameters) {
            CommonCardState selected = (CommonCardState)obj;
            for (int i = 0; i < player.getBenchCards().length; ++i) {
                if (player.getBenchCards()[i] != null) continue;
                player.getBenchCards()[i] = new PokemonCardState(selected.getData(), server.getTurnCount());
                break;
            }
            player.getDeck().remove(selected.getData());
        }
        LogicHelper.shuffleCardList(player.getDeck());
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.count = Integer.parseInt(args[1]);
        this.pokedexNumbers = null;
        this.energy = null;
        if (args[2].equalsIgnoreCase("POKEMON")) {
            this.type = Type.ByPokemon;
            this.pokedexNumbers = Lists.newArrayList();
            for (String idString : args[3].split(",")) {
                this.pokedexNumbers.add(Integer.parseInt(idString));
            }
        } else {
            this.type = Type.ByType;
            this.energy = Energy.getEnergyFromString(args[3]);
        }
        return super.parse(args);
    }

    public static enum Type {
        ByPokemon,
        ByType;

    }
}

