/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class DisableAttackEffect
extends BaseAttackEffect {
    private static final String[] CODES = new String[]{"OPP_DISABLE", "OPP_DISABLED", "SELF_DISABLE", "SELF_DISABLED"};
    private int turnCount;
    private boolean onMe;

    public DisableAttackEffect() {
        super(CODES);
    }

    @Override
    public void applyAfterDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server, int finalDamage) {
        if (this.onMe) {
            attack.disable(this.turnCount);
        }
    }

    @Override
    public boolean chooseOppAttack() {
        return !this.onMe;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        if (this.onMe) {
            return true;
        }
        return !parameters.isEmpty();
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (!this.onMe) {
            PokemonAttackStatus chosenAttack = (PokemonAttackStatus)parameters.get(0);
            chosenAttack.disable(this.turnCount);
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        String[] token = args[0].split("_");
        this.onMe = token[0].equalsIgnoreCase("SELF");
        int count = args[1].equalsIgnoreCase("FOREVER") ? 1000000 : Integer.parseInt(args[1]);
        this.turnCount = count + (this.onMe ? 1 : 0);
        return super.parse(args);
    }
}

