/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorPurpose;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.network.packets.battles.CardSelectorToServerPacket;
import com.pixelmonmod.tcg.network.packets.battles.RetreatAndSwitchPacket;
import com.pixelmonmod.tcg.network.packets.battles.SwitchPacket;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CardSelector
extends TCGScreenBase {
    protected static final ResourceLocation DISCARD = ResourceLocationHelper.of("tcg", "gui/cards/discard.png");
    protected static final ResourceLocation SELECT = ResourceLocationHelper.of("tcg", "gui/cards/select.png");
    private static final int SCROLL_SPEED = 70;
    private static final int BUTTON_ACCEPT_ID = 101;
    private static final int BUTTON_CANCEL_ID = 102;
    private final TCGScreen parent;
    private CardSelectorState data = null;
    private CardSelectorPurpose purpose = null;
    private CardWithLocation renderLast = null;
    private int renderLastPos = -1;
    private BattleOwnedTileEntityController controller;
    private boolean[] isSelectedAtPosition;
    private int scrollModifier = 0;
    private boolean mousePressed = false;
    private boolean isMouseInGrid = false;
    private boolean tooFarLeft = false;
    private boolean tooFarRight = false;
    private boolean canScroll = true;
    private IndexedButton acceptButton = new IndexedButton(101, 0, 0, 40, 20, "OK", this::actionPerformed);
    private IndexedButton cancelButton = new IndexedButton(102, 0, 0, 40, 20, "Cancel", this::actionPerformed);

    public CardSelector(TCGScreen parent, BattleOwnedTileEntityController controller) {
        this.parent = parent;
        this.controller = controller;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        if (!this.parent.isSpectating) {
            this.func_230480_a_((Widget)this.acceptButton);
            this.func_230480_a_((Widget)this.cancelButton);
        }
    }

    @Override
    public void func_231023_e_() {
        if (this.data == null) {
            return;
        }
        super.func_231023_e_();
        this.cancelButton.field_230694_p_ = this.data.isCancellable();
        this.acceptButton.field_230694_p_ = this.getSelectionCount() >= this.data.getMinimumCount();
        this.acceptButton.field_230690_l_ = this.getScaledWidth() / 2 - (this.data.isCancellable() ? 45 : 20);
        this.acceptButton.field_230691_m_ = this.getScaledHeight() / 2 + 50;
        this.cancelButton.field_230690_l_ = this.getScaledWidth() / 2 + (this.data.getMaximumCount() > 0 ? 5 : -20);
        this.cancelButton.field_230691_m_ = this.getScaledHeight() / 2 + 50;
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        TranslationTextComponent hint;
        if (this.data == null) {
            return;
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        List<CardWithLocation> cardList = this.data.getCardList();
        TranslationTextComponent translationTextComponent = hint = this.data.getCustomText() == null ? null : new TranslationTextComponent(this.data.getCustomText());
        if (hint == null) {
            if (this.data.getMaximumCount() > 0) {
                String rangeText = this.data.getMaximumCount() + "";
                if (this.data.getMaximumCount() > this.data.getMinimumCount()) {
                    rangeText = this.data.getMinimumCount() + "-" + this.data.getMaximumCount();
                }
                String suffix = this.data.getMaximumCount() > 1 ? (this.data.isCountEnergy() ? I18n.func_135052_a((String)"tcg.energy.plural", (Object[])new Object[0]) : I18n.func_135052_a((String)"tcg.card.plural", (Object[])new Object[0])) : (this.data.isCountEnergy() ? I18n.func_135052_a((String)"tcg.energy.singular", (Object[])new Object[0]) : I18n.func_135052_a((String)"tcg.card.singular", (Object[])new Object[0]));
                hint = new TranslationTextComponent(I18n.func_135052_a((String)"tcg.cardselector.hint", (Object[])new Object[]{this.data.getDisplayType().toString(), rangeText, suffix}));
            } else if (this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
                hint = new TranslationTextComponent(I18n.func_135052_a((String)"tcg.battle.reveal", (Object[])new Object[]{this.controller.getClient().getOpponent().getPlayerName()}));
            }
        }
        if (hint != null) {
            ScreenHelper.drawString(matrix, hint.getString(), this.getScaledWidth() / 2 - this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)hint) / 2, this.getScaledHeight() / 2 - 65, 0xFFFFFF, true);
        }
        GameClientState client = this.controller.getClient();
        PlayerClientMyState me = client.getMe();
        PlayerClientOpponentState opp = client.getOpponent();
        int size = cardList.size();
        boolean isMouseOut = true;
        for (int cardIndex = 0; cardIndex < size; ++cardIndex) {
            CardWithLocation card = cardList.get(cardIndex);
            Button target = this.getGuiTarget(cardIndex, size);
            this.isMouseInGrid = target.func_231047_b_((double)mouseX, (double)mouseY);
            float scaleFactor = 0.5f;
            if (this.isMouseInGrid) {
                this.renderLast = card;
                this.renderLastPos = cardIndex;
                isMouseOut = false;
                this.canScroll = false;
            } else {
                this.canScroll = true;
                matrix.func_227860_a_();
                matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
                int cardX = (int)((float)(this.getScaledWidth() * 2 + cardIndex * 250 - (size - 1) * 125 + this.scrollModifier) / (scaleFactor * 2.0f));
                int cardY = (int)((float)(this.getScaledHeight() * 2) / (scaleFactor * 2.0f));
                float cardZ = this.isMouseInGrid ? 1.1f : 1.0f;
                float opacity = this.getCardOpacity(cardIndex);
                if (card == null) {
                    CardRenderingHelper.drawCardBack(matrix, cardX, cardY, cardZ - 0.1f, me);
                } else {
                    CardRenderingHelper.drawCard(matrix, card.getCard(), cardX, cardY, cardZ - 0.1f, opacity, 0.0, me, opp);
                }
                matrix.func_227862_a_(-scaleFactor, -scaleFactor, -scaleFactor);
                matrix.func_227865_b_();
                String title = "";
                if (card == null) {
                    title = BoardLocation.Deck.toString();
                } else if (card.getLocation() != null) {
                    title = card.getLocation().toString();
                }
                this.field_230706_i_.field_71466_p.func_238421_b_(matrix, title, (float)((int)((float)cardX * scaleFactor / 2.0f) - this.field_230706_i_.field_71466_p.func_78256_a(title) / 2), (float)(this.getScaledHeight() / 2 - 51), 0xFFFFFF);
                if (this.isSelectedAtPosition[cardIndex]) {
                    this.drawSelectionOverlay(matrix, target, scaleFactor, 0.9f);
                }
                if (cardIndex == 0) {
                    boolean bl = this.tooFarLeft = cardX > 285;
                }
                if (cardIndex == size - 1) {
                    boolean bl = this.tooFarRight = cardX < this.field_230708_k_ + 1180;
                }
            }
            if (!this.parent.isSpectating && this.isLeftMousePressed()) {
                if (!this.isMouseInGrid || this.mousePressed) continue;
                if (this.getSelectionCount() == this.getData().getMaximumCount() && !this.isSelectedAtPosition[cardIndex]) {
                    if (this.getData().getMaximumCount() == 1) {
                        this.isSelectedAtPosition = new boolean[this.isSelectedAtPosition.length];
                        this.isSelectedAtPosition[cardIndex] = true;
                    }
                } else {
                    this.isSelectedAtPosition[cardIndex] = !this.isSelectedAtPosition[cardIndex];
                }
                this.mousePressed = true;
                continue;
            }
            if (this.isLeftMousePressed() || !this.mousePressed) continue;
            this.mousePressed = false;
        }
        if (isMouseOut) {
            this.renderLast = null;
            this.renderLastPos = -1;
        }
        if (this.renderLast != null || this.renderLastPos != -1) {
            float cardZ;
            Button target = this.getGuiTarget(this.renderLastPos, size);
            this.isMouseInGrid = target.func_231047_b_((double)mouseX, (double)mouseY);
            float scaleFactor = 0.5f;
            if (this.mousePressed && this.isMouseInGrid) {
                scaleFactor = 0.9f;
            } else if (this.isMouseInGrid) {
                scaleFactor = 1.0f;
            }
            float opacity = this.getCardOpacity(this.renderLastPos);
            matrix.func_227860_a_();
            matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            int cardX = (int)((float)(this.getScaledWidth() * 2 + this.renderLastPos * 250 - (size - 1) * 125 + this.scrollModifier) / (scaleFactor * 2.0f));
            int cardY = (int)((float)(this.getScaledHeight() * 2) / (scaleFactor * 2.0f));
            float f = cardZ = this.isMouseInGrid ? 1.1f : 1.0f;
            if (this.renderLast == null) {
                CardRenderingHelper.drawCardBack(matrix, cardX, cardY, cardZ - 0.1f, me);
            } else {
                CardRenderingHelper.drawCard(matrix, this.renderLast.getCard(), cardX, cardY, cardZ - 0.1f, opacity, 0.0, me, opp);
            }
            matrix.func_227862_a_(-scaleFactor, -scaleFactor, -scaleFactor);
            matrix.func_227865_b_();
            if (this.isSelectedAtPosition[this.renderLastPos]) {
                this.drawSelectionOverlay(matrix, target, scaleFactor, 0.5f);
            }
            String title = null;
            if (this.renderLast == null) {
                title = I18n.func_135052_a((String)"tcg.deck.title", (Object[])new Object[0]);
            } else if (this.renderLast.getLocation() != null) {
                title = this.renderLast.getLocation().toString();
            }
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, title, (float)((int)((float)cardX * scaleFactor / 2.0f) - this.field_230706_i_.field_71466_p.func_78256_a(title) / 2), (float)(this.getScaledHeight() / 2 - 93), 0xFFFFFF);
        }
    }

    private void drawSelectionOverlay(MatrixStack matrixStack, Button target, float scaleFactor, float opacity) {
        switch (this.data.getDisplayType()) {
            case Discard: {
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(opacity / 2.0f));
                ScreenHelper.drawImageQuad(DISCARD, matrixStack, (float)((double)((float)(target.field_230690_l_ + target.func_230998_h_() / 2) - 24.0f * scaleFactor) + 0.5), (float)((double)((float)(target.field_230691_m_ + target.func_238483_d_() / 2) - 24.0f * scaleFactor) + 0.5), 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)opacity);
                ScreenHelper.drawImageQuad(DISCARD, matrixStack, (float)(target.field_230690_l_ + target.func_230998_h_() / 2) - 24.0f * scaleFactor, (float)(target.field_230691_m_ + target.func_238483_d_() / 2) - 24.0f * scaleFactor, 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                break;
            }
            case Draw: 
            case Select: {
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(opacity / 2.0f));
                ScreenHelper.drawImageQuad(SELECT, matrixStack, (float)((double)((float)(target.field_230690_l_ + target.func_230998_h_() / 2) - 24.0f * scaleFactor) + 0.5), (float)((double)((float)(target.field_230691_m_ + target.func_238483_d_() / 2) - 24.0f * scaleFactor) + 0.5), 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                RenderSystem.color4f((float)0.2f, (float)0.3f, (float)1.0f, (float)opacity);
                ScreenHelper.drawImageQuad(SELECT, matrixStack, (float)(target.field_230690_l_ + target.func_230998_h_() / 2) - 24.0f * scaleFactor, (float)(target.field_230691_m_ + target.func_238483_d_() / 2) - 24.0f * scaleFactor, 48.0f * scaleFactor, 48.0f * scaleFactor, 0.0f, 0.0f, 1.0f, 1.0f, 1.2f);
                break;
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Button getGuiTarget(int cardIndex, int size) {
        int sizeModXA = -26;
        int sizeModXB = 27;
        int sizeModYA = -42;
        int sizeModYB = 40;
        return new Button(this.getScaledWidth() / 2 + cardIndex * 250 / 4 - (size - 1) * 125 / 4 + this.scrollModifier / 4 - sizeModXB, this.getScaledHeight() / 2 - sizeModYB, sizeModXB - sizeModXA, sizeModYB - sizeModYA, StringTextComponent.field_240750_d_, p_onPress_1_ -> {});
    }

    protected void actionPerformed(Button button) {
        if (this.data == null || !(button instanceof IndexedButton)) {
            return;
        }
        switch (((IndexedButton)button).getID()) {
            case 101: {
                this.scrollModifier = 0;
                this.acceptSelection();
                break;
            }
            case 102: {
                this.scrollModifier = 0;
                this.set(null, null);
            }
        }
    }

    @Override
    public boolean func_231042_a_(char key, int code) {
        if (this.data == null) {
            return true;
        }
        return super.func_231042_a_(key, code);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.data == null) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void set(CardSelectorPurpose purpose, CardSelectorState data) {
        if (data == null && this.data != null && this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
            return;
        }
        CardSelectorState oldData = this.data;
        this.purpose = purpose;
        this.data = data;
        if (data == null && oldData != null || data != null && oldData == null || data != null && oldData != null && oldData.getId() != data.getId()) {
            this.initialize();
            if (purpose == CardSelectorPurpose.Trainer) {
                NetworkHelper.sendToServer(new CardSelectorToServerPacket(this.controller.func_174877_v(), true, null));
            }
        }
    }

    public CardSelectorState getData() {
        return this.data;
    }

    public CardSelectorPurpose getPurpose() {
        return this.purpose;
    }

    public void initialize() {
        this.isSelectedAtPosition = null;
        if (this.data != null) {
            this.isSelectedAtPosition = new boolean[this.data.getCardList().size()];
        }
    }

    public List<CommonCardState> getSelectedCards() {
        ArrayList<CommonCardState> cards = new ArrayList<CommonCardState>();
        for (int i = 0; i < this.data.getCardList().size(); ++i) {
            if (!this.isSelectedAtPosition[i]) continue;
            cards.add(this.data.getCardList().get(i).getCard());
        }
        return cards;
    }

    void acceptSelection() {
        if (this.data.getDisplayType() == CardSelectorDisplay.Reveal) {
            this.data = null;
            this.purpose = null;
            return;
        }
        int selectionCount = this.getSelectionCount();
        switch (this.purpose) {
            case Trainer: {
                if (selectionCount > this.data.getMaximumCount() || selectionCount < this.data.getMinimumCount()) break;
                NetworkHelper.sendToServer(new CardSelectorToServerPacket(this.controller.func_174877_v(), true, this.isSelectedAtPosition));
                break;
            }
            case StartRetreating: {
                if (selectionCount >= this.data.getMinimumCount()) {
                    this.controller.energySelectionForRetreat = this.isSelectedAtPosition;
                }
                PlayerClientMyState me = this.controller.getClient().getMe();
                CardSelectorState state = SelectorHelper.generateSelectorForBench(me, "battle.selector.newactive");
                state.setCancellable(true);
                this.set(CardSelectorPurpose.FinishRetreating, state);
                break;
            }
            case FinishRetreating: {
                for (int i = 0; i < this.data.getCardList().size(); ++i) {
                    if (!this.isSelectedAtPosition[i]) continue;
                    NetworkHelper.sendToServer(new RetreatAndSwitchPacket(this.controller.func_174877_v(), this.controller.energySelectionForRetreat, this.data.getCardList().get(i).getLocationSubIndex()));
                }
                this.controller.energySelectionForRetreat = null;
                this.set(null, null);
                break;
            }
            case KnockoutSwitch: {
                for (int i = 0; i < this.data.getCardList().size(); ++i) {
                    if (!this.isSelectedAtPosition[i]) continue;
                    NetworkHelper.sendToServer(new SwitchPacket(this.controller.func_174877_v(), this.data.getCardList().get(i).getLocationSubIndex()));
                }
                this.set(null, null);
            }
        }
    }

    private int getSelectionCount() {
        int selectionCount = 0;
        for (int i = 0; i < this.isSelectedAtPosition.length; ++i) {
            if (!this.isSelectedAtPosition[i]) continue;
            ++selectionCount;
            if (!this.data.isCountEnergy() || this.data.getCardList().get(i).getCard().getSecondaryEnergy() == null) continue;
            ++selectionCount;
        }
        return selectionCount;
    }

    private float getCardOpacity(int pos) {
        return 1.0f;
    }
}

