/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.base;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class TCGScreenBase
extends Screen
implements INestedGuiEventHandler {
    public boolean visible = true;
    private int buttonPressed = -1;
    protected List<TextFieldWidget> textFieldList = new ArrayList<TextFieldWidget>();

    public TCGScreenBase() {
        super(StringTextComponent.field_240750_d_);
        if (this.field_230706_i_ == null) {
            this.field_230706_i_ = Minecraft.func_71410_x();
        }
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        super.func_231160_c_();
    }

    public void func_231023_e_() {
        if (this.visible) {
            super.func_231023_e_();
            this.textFieldList.forEach(TextFieldWidget::func_146178_a);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.textFieldList.forEach(field -> field.func_230430_a_(matrix, mouseX, mouseY, partialTicks));
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        for (TextFieldWidget textField : this.textFieldList) {
            if (!textField.func_231046_a_(key, scanCode, modifiers)) continue;
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_231042_a_(char key, int code) {
        for (TextFieldWidget textField : this.textFieldList) {
            if (!textField.func_231042_a_(key, code)) continue;
            return true;
        }
        return super.func_231042_a_(key, code);
    }

    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231175_as__();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.buttonPressed = mouseButton;
        if (this.visible) {
            for (TextFieldWidget textField : this.textFieldList) {
                if (!textField.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.buttonPressed = -1;
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean isLeftMousePressed() {
        return this.buttonPressed == 0;
    }

    public boolean isRightMousePressed() {
        return this.buttonPressed == 1;
    }

    public void drawEffectTooltip(MatrixStack matrix, CommonCardState card, int mouseX, int mouseY, int xOffset, int yOffset) {
        int lines = 0;
        int x0 = this.field_230708_k_ / 2 + xOffset;
        int y0 = this.field_230709_l_ / 2 + yOffset;
        PokemonAttackStatus[] attacks = null;
        if (card instanceof PokemonCardState) {
            attacks = ((PokemonCardState)card).getAttacksStatus();
        } else if (card.getData().getAttacks() != null) {
            attacks = (PokemonAttackStatus[])card.getData().getAttacks().stream().map(PokemonAttackStatus::new).toArray(PokemonAttackStatus[]::new);
        }
        CardPower cardAbility = card.getData().getAbility();
        if (cardAbility != null) {
            int linesForAbility;
            int n = linesForAbility = attacks != null && attacks.length > 0 ? 2 : 5;
            if (attacks.length == 1 && !attacks[0].hasDescription()) {
                linesForAbility = 4;
            }
            int x1 = x0 - 46;
            int x2 = x0 + 46;
            int y1 = y0 + 9;
            int y2 = y0 - 1 + (linesForAbility + 1) * 9;
            if (mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2) {
                ArrayList list = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(cardAbility.getName()).func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent(cardAbility.getDescription()).func_240699_a_(TextFormatting.BOLD)});
                this.drawHoveringText(matrix, list, mouseX, mouseY, card.getMainEnergy());
            }
            lines += linesForAbility;
        }
        if (attacks != null && attacks.length > 0) {
            int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(attacks, cardAbility != null, 94);
            for (int i = 0; i < attacks.length; ++i) {
                if (attacks[i] == null) continue;
                if (attacks[i].hasDescription()) {
                    int x1 = x0 - 46;
                    int x2 = x0 + 46;
                    int y1 = y0 - 1 + (lines + 1 + (cardAbility != null ? 1 : 0)) * 9;
                    int y2 = y0 - 1 + (lines + 1 + (cardAbility != null ? 1 : 0) + descriptionLines[i]) * 9;
                    if (mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2) {
                        this.drawHoveringText(matrix, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(attacks[i].getData().getName()).func_240699_a_(TextFormatting.BOLD), attacks[i].getLocalizedDescription()}), mouseX, mouseY, card.getMainEnergy());
                    }
                    lines += 1 + descriptionLines[i];
                    continue;
                }
                ++lines;
            }
        }
    }

    public void drawHoveringText(MatrixStack matrix, List<ITextComponent> textLines, int x, int y, Energy type) {
        if (!textLines.isEmpty()) {
            int popupWidth = 130;
            int lineCount = 0;
            for (ITextComponent s : textLines) {
                List<String> lines = ScreenHelper.splitString(s.getString(), popupWidth);
                lineCount += lines.size();
            }
            int startX = x + 12;
            int startY = y - 12;
            int popupHeight = 2 + lineCount * 9;
            if (startX + popupWidth > this.field_230708_k_) {
                startX -= 20 + popupWidth;
            }
            if (startY + popupHeight + 6 > this.field_230709_l_) {
                startY = this.field_230709_l_ - popupHeight - 6;
            }
            this.field_230707_j_.field_77023_b = 300.0f;
            int j1 = CardRenderingHelper.getBackgroundColor(type);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 4, 300.0f, startX + popupWidth + 3, startY - 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY + popupHeight + 3, 300.0f, startX + popupWidth + 3, startY + popupHeight + 4, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX - 5, startY - 3, 300.0f, startX - 3, startY + popupHeight + 3, j1, j1);
            ScreenHelper.drawGradientRect(matrix, startX + popupWidth + 3, startY - 3, 300.0f, startX + popupWidth + 4, startY + popupHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3 + 1, 300.0f, startX - 4 + 1, startY + popupHeight + 3 - 1, k1, l1);
            ScreenHelper.drawGradientRect(matrix, startX + popupWidth + 2, startY - 3 + 1, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3 - 1, k1, l1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY - 3, 300.0f, startX + popupWidth + 3, startY - 3 + 1, k1, k1);
            ScreenHelper.drawGradientRect(matrix, startX - 4, startY + popupHeight + 2, 300.0f, startX + popupWidth + 3, startY + popupHeight + 3, l1, l1);
            for (int i = 0; i < textLines.size(); ++i) {
                ScreenHelper.drawSplitString(matrix, textLines.get(i).getString(), startX, startY + i * 12, popupWidth, CardRenderingHelper.getForegroundColor(type));
            }
            this.field_230707_j_.field_77023_b = 0.0f;
        }
    }

    public void drawRectWithBorder(MatrixStack matrix, int x1, int y1, int x2, int y2, int backgroundColor, int borderColor) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x1, (int)y1, (int)x2, (int)y2, (int)backgroundColor);
        this.func_238465_a_(matrix, x1, x2, y1, borderColor);
        this.func_238465_a_(matrix, x1, x2, y2, borderColor);
        this.func_238473_b_(matrix, x1, y1, y2, borderColor);
        this.func_238473_b_(matrix, x2, y1, y2, borderColor);
    }

    public int getScaledWidth() {
        return this.field_230706_i_.func_228018_at_().func_198107_o();
    }

    public int getScaledHeight() {
        return this.field_230706_i_.func_228018_at_().func_198087_p();
    }
}

