/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.typeadapters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.util.helpers.JsonHelper;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import java.lang.reflect.Type;
import java.util.List;

public class CardAttackTypeAdapter
implements JsonDeserializer<CardAttack>,
JsonSerializer<CardAttack> {
    public CardAttack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String name = object.getAsJsonPrimitive("name").getAsString();
        ImmutableList<Energy> cost = JsonHelper.deserializeList(object.getAsJsonArray("costs"), e -> (Energy)((Object)((Object)context.deserialize(e, Energy.class))));
        int damage = object.getAsJsonPrimitive("damage").getAsInt();
        CardModifier modifier = (CardModifier)((Object)context.deserialize(object.get("modifier"), CardModifier.class));
        String text = JsonHelper.getOrDefault(object, "text", String.class, "", context);
        if (object.has("effects") && !object.get("effects").isJsonNull()) {
            ImmutableList<BaseAttackEffect> effects = JsonHelper.deserializeList(object.getAsJsonArray("effects"), e -> (BaseAttackEffect)context.deserialize(e, BaseAttackEffect.class));
            return new CardAttack(name, (List<Energy>)cost, damage, modifier, text, (List<BaseAttackEffect>)effects);
        }
        return new CardAttack(name, (List<Energy>)cost, damage, modifier, text, Lists.newArrayList());
    }

    public JsonElement serialize(CardAttack src, Type typeOfSrc, JsonSerializationContext context) {
        return null;
    }
}

