/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.duel.trainer.Bill;
import com.pixelmonmod.tcg.duel.trainer.ClefairyDoll;
import com.pixelmonmod.tcg.duel.trainer.ComputerSearch;
import com.pixelmonmod.tcg.duel.trainer.Defender;
import com.pixelmonmod.tcg.duel.trainer.DevolutionSpray;
import com.pixelmonmod.tcg.duel.trainer.EnergyRemoval;
import com.pixelmonmod.tcg.duel.trainer.EnergyRetrieval;
import com.pixelmonmod.tcg.duel.trainer.EnergySearch;
import com.pixelmonmod.tcg.duel.trainer.FullHeal;
import com.pixelmonmod.tcg.duel.trainer.Gambler;
import com.pixelmonmod.tcg.duel.trainer.GustOfWind;
import com.pixelmonmod.tcg.duel.trainer.ImposterProfOak;
import com.pixelmonmod.tcg.duel.trainer.ItemFinder;
import com.pixelmonmod.tcg.duel.trainer.Lass;
import com.pixelmonmod.tcg.duel.trainer.Maintenance;
import com.pixelmonmod.tcg.duel.trainer.MrFuji;
import com.pixelmonmod.tcg.duel.trainer.MysteriousFossil;
import com.pixelmonmod.tcg.duel.trainer.PlusPower;
import com.pixelmonmod.tcg.duel.trainer.PokeBall;
import com.pixelmonmod.tcg.duel.trainer.PokeFlute;
import com.pixelmonmod.tcg.duel.trainer.Pokedex;
import com.pixelmonmod.tcg.duel.trainer.PokemonBreeder;
import com.pixelmonmod.tcg.duel.trainer.PokemonCenter;
import com.pixelmonmod.tcg.duel.trainer.PokemonTrader;
import com.pixelmonmod.tcg.duel.trainer.Potion;
import com.pixelmonmod.tcg.duel.trainer.ProfOak;
import com.pixelmonmod.tcg.duel.trainer.Recycle;
import com.pixelmonmod.tcg.duel.trainer.Revive;
import com.pixelmonmod.tcg.duel.trainer.ScoopUp;
import com.pixelmonmod.tcg.duel.trainer.SuperEnergyRemoval;
import com.pixelmonmod.tcg.duel.trainer.SuperPotion;
import com.pixelmonmod.tcg.duel.trainer.Switch;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ImmutableCard {
    private static final ResourceLocation FALL_BACK_TEXTURE = new ResourceLocation("tcg", "gui/cards/foreground/fallback.png");
    @Deprecated
    public static int FACE_DOWN_ID = -1;
    public static String FACE_DOWN_CODE = "FACEDOWN";
    @Deprecated
    public static String CARD_ID_NBT_KEY = "CardID";
    public static String CARD_CODE_NBT_KEY = "CardCode";
    public static String IS_HOLO_NBT_KEY = "ReverseHolo";
    private final int id;
    private final int setId;
    private final CardType cardType;
    private final boolean isSpecial;
    private final int hp;
    private final Energy energy1;
    private final Energy energy2;
    private final int pokemonId;
    private final String code;
    private final String name;
    private final String description;
    private final int previousPokemonId;
    private final CardPower cardAbility;
    private final List<CardAttack> cardAttacks;
    private final Energy energyResistance;
    private final int resistanceValue;
    private final CardModifier resistanceCardModifier;
    private final Energy energyWeakness;
    private final int weaknessValue;
    private final CardModifier weaknessCardModifier;
    private final int retreatCost;
    private final CardRarity cardRarity;
    private final ResourceLocation customTexture;
    private final int customTextureX;
    private final int customTextureY;
    private BaseTrainerEffect effect;
    private final transient String json;
    private transient RegistryValue<ImmutableCard> registryValue = null;

    public static ImmutableCard faceDown() {
        return new ImmutableCard("{}", FACE_DOWN_ID, 0, null, false, 0, null, null, 0, FACE_DOWN_CODE, "", "", 0, null, null, null, 0, null, null, 0, null, 0, null, null, 0, 0, null);
    }

    public ImmutableCard(String json, int id, int setId, CardType cardType, boolean isSpecial, int hp, Energy energy1, Energy energy2, int pokemonId, String code, String name, String description, int previousPokemonId, CardPower cardAbility, List<CardAttack> cardAttacks, Energy energyResistance, int resistanceValue, CardModifier resistanceCardModifier, Energy energyWeakness, int weaknessValue, CardModifier weaknessCardModifier, int retreatCost, CardRarity cardRarity, ResourceLocation customTexture, int customTextureX, int customTextureY, BaseTrainerEffect effect) {
        this.json = json;
        this.id = id;
        this.setId = setId;
        this.cardType = cardType;
        this.isSpecial = isSpecial;
        this.hp = hp;
        this.energy1 = energy1;
        this.energy2 = energy2;
        this.pokemonId = pokemonId;
        this.code = code.toLowerCase();
        this.name = name.toLowerCase();
        this.description = description.toLowerCase();
        this.previousPokemonId = previousPokemonId;
        this.cardAbility = cardAbility;
        this.cardAttacks = cardAttacks;
        this.energyResistance = energyResistance;
        this.resistanceValue = resistanceValue;
        this.resistanceCardModifier = resistanceCardModifier;
        this.energyWeakness = energyWeakness;
        this.weaknessValue = weaknessValue;
        this.weaknessCardModifier = weaknessCardModifier;
        this.retreatCost = retreatCost;
        this.cardRarity = cardRarity;
        this.customTexture = customTexture;
        this.customTextureX = customTextureX;
        this.customTextureY = customTextureY;
        this.effect = this.attachTrainerEffect();
    }

    public RegistryValue<ImmutableCard> getRegistryValue() {
        if (this.registryValue == null) {
            this.registryValue = RegistryManager.getRegistryValue(this);
        }
        return this.registryValue;
    }

    public String getJson() {
        return this.json;
    }

    public boolean isHolo() {
        return this.cardRarity == CardRarity.HOLORARE;
    }

    public void calculateTrainerEffect() {
        this.effect = this.attachTrainerEffect();
    }

    private BaseTrainerEffect attachTrainerEffect() {
        switch (this.id) {
            case 70: {
                return new ClefairyDoll();
            }
            case 71: {
                return new ComputerSearch();
            }
            case 72: {
                return new DevolutionSpray();
            }
            case 73: {
                return new ImposterProfOak();
            }
            case 74: {
                return new ItemFinder();
            }
            case 75: {
                return new Lass();
            }
            case 76: {
                return new PokemonBreeder();
            }
            case 77: {
                return new PokemonTrader();
            }
            case 78: {
                return new ScoopUp();
            }
            case 79: {
                return new SuperEnergyRemoval();
            }
            case 80: {
                return new Defender();
            }
            case 81: {
                return new EnergyRetrieval();
            }
            case 82: {
                return new FullHeal();
            }
            case 83: {
                return new Maintenance();
            }
            case 84: {
                return new PlusPower();
            }
            case 85: {
                return new PokemonCenter();
            }
            case 86: {
                return new PokeFlute();
            }
            case 87: {
                return new Pokedex();
            }
            case 88: {
                return new ProfOak();
            }
            case 89: {
                return new Revive();
            }
            case 90: {
                return new SuperPotion();
            }
            case 91: {
                return new Bill();
            }
            case 92: {
                return new EnergyRemoval();
            }
            case 93: {
                return new GustOfWind();
            }
            case 94: {
                return new Potion();
            }
            case 95: {
                return new Switch();
            }
            case 166: {
                return new PokeBall();
            }
            case 224: {
                return new MrFuji();
            }
            case 225: {
                return new EnergySearch();
            }
            case 226: {
                return new Gambler();
            }
            case 227: {
                return new Recycle();
            }
            case 228: {
                return new MysteriousFossil();
            }
        }
        return null;
    }

    public int getID() {
        return this.id;
    }

    public boolean isFaceDown() {
        return this.code.equalsIgnoreCase(FACE_DOWN_CODE);
    }

    public int getSetID() {
        return this.setId;
    }

    public String getCode() {
        return this.code;
    }

    public int getHP() {
        return this.hp;
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public BaseTrainerEffect getEffect() {
        return this.effect;
    }

    public boolean isPokemonCard() {
        switch (this.cardType) {
            case BASIC: 
            case STAGE1: 
            case STAGE2: 
            case LVLX: 
            case EX: 
            case BREAK: 
            case LEGEND: 
            case MEGA: {
                return true;
            }
        }
        return false;
    }

    public boolean isEvolution() {
        switch (this.cardType) {
            case STAGE1: 
            case STAGE2: 
            case MEGA: {
                return true;
            }
        }
        return false;
    }

    public boolean isCosmetic() {
        return this.cardType.isCosmetic();
    }

    public Energy getMainEnergy() {
        return this.energy1;
    }

    public Energy getSecondaryEnergy() {
        return this.energy2;
    }

    public int getPokemonID() {
        return this.pokemonId;
    }

    public String getName() {
        return this.name;
    }

    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent(this.getName().toLowerCase(Locale.ROOT));
    }

    public String getDescription() {
        return this.description;
    }

    public int getPreviousEvolutionDexID() {
        return this.previousPokemonId;
    }

    public CardPower getAbility() {
        return this.cardAbility;
    }

    public List<CardAttack> getAttacks() {
        return this.cardAttacks;
    }

    public Energy getEnergyResistance() {
        return this.energyResistance;
    }

    public int getResistanceValue() {
        return this.resistanceValue;
    }

    public CardModifier getResistanceModifier() {
        return this.resistanceCardModifier;
    }

    public Energy getEnergyWeakness() {
        return this.energyWeakness;
    }

    public int getWeaknessValue() {
        return this.weaknessValue;
    }

    public CardModifier getWeaknessModifier() {
        return this.weaknessCardModifier;
    }

    public int getRetreatCost() {
        return this.retreatCost;
    }

    public CardRarity getRarity() {
        return this.cardRarity;
    }

    public boolean getHasCustomTex() {
        return this.customTexture != null;
    }

    public ResourceLocation getCustomTexture() {
        if (this.customTexture == null) {
            if (this.getCardType() == CardType.ENERGY) {
                if (this.getMainEnergy().getHighResTexture() != null) {
                    return this.getMainEnergy().getHighResTexture();
                }
                if (this.getMainEnergy().getTexture() != null) {
                    return this.getMainEnergy().getTexture();
                }
                return FALL_BACK_TEXTURE;
            }
            return FALL_BACK_TEXTURE;
        }
        return this.customTexture;
    }

    public int getImageXFromCard() {
        return this.customTextureX;
    }

    public int getImageYFromCard() {
        return this.customTextureY;
    }

    public ItemStack getItemStack(int count) {
        ItemStack itemStack = new ItemStack((IItemProvider)TCGItems.card, count);
        CompoundNBT tag = new CompoundNBT();
        itemStack.func_200302_a(this.getTranslatedName());
        this.write(tag);
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public void write(CompoundNBT tag) {
        tag.func_74778_a(CARD_CODE_NBT_KEY, this.code);
    }
}

