/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.world.structure.AdvancedMovingJigsawPiece;
import com.pixelmonmod.pixelmon.world.structure.MovingJigsawPiece;
import com.pixelmonmod.pixelmon.world.structure.type.BasicStructure;
import com.pixelmonmod.pixelmon.world.structure.type.BiomeGenericStructure;
import com.pixelmonmod.pixelmon.world.structure.type.BoatStructure;
import com.pixelmonmod.pixelmon.world.structure.type.DenStructure;
import com.pixelmonmod.pixelmon.world.structure.type.FlyingStructure;
import com.pixelmonmod.pixelmon.world.structure.type.GymConfig;
import com.pixelmonmod.pixelmon.world.structure.type.GymStructure;
import com.pixelmonmod.pixelmon.world.structure.type.HauntedTowerStructure;
import com.pixelmonmod.pixelmon.world.structure.type.ShrineStructure;
import com.pixelmonmod.pixelmon.world.structure.type.WayPointStructure;
import com.pixelmonmod.pixelmon.world.structure.type.ultraspace.CraterGeyserPiece;
import com.pixelmonmod.pixelmon.world.structure.type.ultraspace.CraterGyserStructure;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PixelmonStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"pixelmon");
    public static final List<RegistryObject<Structure<NoFeatureConfig>>> ALL_STRUCTURES = Lists.newArrayList();
    public static final RegistryObject<Structure<NoFeatureConfig>> UNO_SHRINE = PixelmonStructures.add(PixelmonStructures.register("uno_shrine", () -> new ShrineStructure("uno_shrine", Biome.Category.ICY)));
    public static final RegistryObject<Structure<NoFeatureConfig>> DOS_SHRINE = PixelmonStructures.add(PixelmonStructures.register("dos_shrine", () -> new ShrineStructure("dos_shrine", Biome.Category.SAVANNA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> TRES_SHRINE = PixelmonStructures.add(PixelmonStructures.register("tres_shrine", () -> new ShrineStructure("tres_shrine", Biome.Category.MESA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ILEX_SHRINE = PixelmonStructures.add(PixelmonStructures.register("ilex_shrine", () -> new ShrineStructure("ilex_shrine", Biome.Category.FOREST)));
    public static final RegistryObject<Structure<NoFeatureConfig>> LAND_CHALICE = PixelmonStructures.add(PixelmonStructures.register("land_chalice", () -> new BasicStructure("land_chalice", Biome.Category.EXTREME_HILLS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> WATER_CHALICE = PixelmonStructures.add(PixelmonStructures.register("water_chalice", () -> new BasicStructure("water_chalice", Biome.Category.OCEAN)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SPEAR_PILLAR = PixelmonStructures.add(PixelmonStructures.register("spear_pillar", () -> new HauntedTowerStructure("spear_pillar", "minecraft:desert_hills")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PLASMA_SHIP = PixelmonStructures.add(PixelmonStructures.register("plasma_ship", () -> new FlyingStructure("plasma_ship", "minecraft:ice_spikes", "minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:snowy_tundra")));
    public static final RegistryObject<Structure<NoFeatureConfig>> BOATS = PixelmonStructures.add(PixelmonStructures.register("boats", () -> new BoatStructure("boats", Biome.Category.OCEAN)));
    public static final RegistryObject<Structure<NoFeatureConfig>> GRAVEYARD = PixelmonStructures.add(PixelmonStructures.register("graveyard", () -> new BoatStructure("graveyards", Biome.Category.FOREST)));
    public static final RegistryObject<Structure<NoFeatureConfig>> BADLANDS_DEN = PixelmonStructures.add(PixelmonStructures.register("badlands_den", () -> new DenStructure("badlands_den", Biome.Category.MESA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> BEACH_DEN = PixelmonStructures.add(PixelmonStructures.register("beach_den", () -> new DenStructure("beach_den", Biome.Category.BEACH)));
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERT_DEN = PixelmonStructures.add(PixelmonStructures.register("desert_den", () -> new DenStructure("desert_den", Biome.Category.DESERT)));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_DEN = PixelmonStructures.add(PixelmonStructures.register("end_den", () -> new DenStructure("end_den", Biome.Category.THEEND)));
    public static final RegistryObject<Structure<NoFeatureConfig>> FOREST_DEN = PixelmonStructures.add(PixelmonStructures.register("forest_den", () -> new DenStructure("forest_den", Biome.Category.FOREST)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICE_DEN = PixelmonStructures.add(PixelmonStructures.register("ice_den", () -> new DenStructure("ice_den", Biome.Category.ICY)));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_DEN = PixelmonStructures.add(PixelmonStructures.register("jungle_den", () -> new DenStructure("jungle_den", Biome.Category.JUNGLE)));
    public static final RegistryObject<Structure<NoFeatureConfig>> MOUNTAIN_DEN = PixelmonStructures.add(PixelmonStructures.register("mountain_den", () -> new DenStructure("mountain_den", Biome.Category.EXTREME_HILLS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_DEN = PixelmonStructures.add(PixelmonStructures.register("mushroom_den", () -> new DenStructure("mushroom_den", Biome.Category.MUSHROOM)));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_DEN = PixelmonStructures.add(PixelmonStructures.register("nether_den", () -> new DenStructure("nether_den", Biome.Category.NETHER)));
    public static final RegistryObject<Structure<NoFeatureConfig>> PLAINS_DEN = PixelmonStructures.add(PixelmonStructures.register("plains_den", () -> new DenStructure("plains_den", Biome.Category.PLAINS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SNOW_DEN = PixelmonStructures.add(PixelmonStructures.register("snow_den", () -> new DenStructure("snow_den", Biome.Category.ICY)));
    public static final RegistryObject<Structure<NoFeatureConfig>> TAIGA_DEN = PixelmonStructures.add(PixelmonStructures.register("taiga_den", () -> new DenStructure("taiga_den", Biome.Category.TAIGA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> WATER_DEN = PixelmonStructures.add(PixelmonStructures.register("water_den", () -> new DenStructure("water_den", Biome.Category.OCEAN)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_DEN = PixelmonStructures.add(PixelmonStructures.register("swamp_den", () -> new DenStructure("swamp_den", Biome.Category.SWAMP)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_DEEP_SEA_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_deep_sea_den", () -> new BiomeGenericStructure("ultra_deep_sea_den", "pixelmon:ultra_deep_sea")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_DESERT_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_desert_den", () -> new BiomeGenericStructure("ultra_desert_den", "pixelmon:ultra_desert")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_FOREST_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_forest_den", () -> new BiomeGenericStructure("ultra_forest_den", "pixelmon:ultra_forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_JUNGLE_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_jungle_den", () -> new BiomeGenericStructure("ultra_jungle_den", "pixelmon:ultra_jungle")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_PLANT_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_plant_den", () -> new BiomeGenericStructure("ultra_space/plant/den", "pixelmon:ultra_plant")));
    public static final RegistryObject<Structure<NoFeatureConfig>> BADLANDS_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_badlands", () -> new BiomeGenericStructure("grotto_badlands", "minecraft:badlands")));
    public static final RegistryObject<Structure<NoFeatureConfig>> DARK_FOREST_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_dark_forest", () -> new BiomeGenericStructure("grotto_dark_forest", "minecraft:dark_forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERT_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_desert", () -> new BiomeGenericStructure("grotto_desert", "minecraft:desert")));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_end", () -> new BiomeGenericStructure("grotto_end", "minecraft:the_end", "minecraft:end_highlands")));
    public static final RegistryObject<Structure<NoFeatureConfig>> FOREST_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_forest", () -> new BiomeGenericStructure("grotto_forest", "minecraft:forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> HILLS_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_hills", () -> new BiomeGenericStructure("grotto_hills", "minecraft:mountains")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICY_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_icy", () -> new DenStructure("grotto_icy", Biome.Category.ICY)));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_jungle", () -> new DenStructure("grotto_jungle", Biome.Category.JUNGLE)));
    public static final RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_mushroom", () -> new DenStructure("grotto_mushroom", Biome.Category.MUSHROOM)));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_nether", () -> new DenStructure("grotto_nether", Biome.Category.NETHER)));
    public static final RegistryObject<Structure<NoFeatureConfig>> OCEANS_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_oceans", () -> new DenStructure("grotto_ocean", Biome.Category.OCEAN)));
    public static final RegistryObject<Structure<NoFeatureConfig>> PLAINS_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_plains", () -> new DenStructure("grotto_plains", Biome.Category.PLAINS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SAVANNA_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_savanna", () -> new DenStructure("grotto_savanna", Biome.Category.SAVANNA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_swamp", () -> new DenStructure("grotto_swamp", Biome.Category.SWAMP)));
    public static final RegistryObject<Structure<NoFeatureConfig>> TAIGA_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_taiga", () -> new DenStructure("grotto_taiga", Biome.Category.TAIGA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_DESERT_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_ultra_desert", () -> new BiomeGenericStructure("ultra_space/desert/grotto", "pixelmon:ultra_desert")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_SEA_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_ultra_deep_sea", () -> new BiomeGenericStructure("ultra_space/sea/grotto", "pixelmon:ultra_deep_sea")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_FOREST_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_ultra_forest", () -> new BiomeGenericStructure("ultra_space/forest/grotto", "pixelmon:ultra_forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_JUNGLE_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_ultra_jungle", () -> new BiomeGenericStructure("ultra_space/jungle/grotto", "pixelmon:ultra_jungle")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_PLANT_GROTTO = PixelmonStructures.add(PixelmonStructures.register("grotto_ultra_plant", () -> new BiomeGenericStructure("ultra_space/plant/grotto", "pixelmon:ultra_plant")));
    public static final RegistryObject<Structure<NoFeatureConfig>> HAUNTED_TOWER = PixelmonStructures.add(PixelmonStructures.register("haunted_tower", () -> new HauntedTowerStructure("hauntedtower", "minecraft:dark_forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> BADLANDS_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("badlands_way_point", () -> new WayPointStructure("badlands_way_point", Biome.Category.MESA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERT_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("desert_way_point", () -> new WayPointStructure("desert_way_point", Biome.Category.DESERT)));
    public static final RegistryObject<Structure<NoFeatureConfig>> FOREST_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("forest_way_point", () -> new WayPointStructure("forest_way_point", Biome.Category.FOREST)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICE_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("ice_way_point", () -> new WayPointStructure("ice_way_point", Biome.Category.ICY)));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("jungle_way_point", () -> new WayPointStructure("jungle_way_point", Biome.Category.JUNGLE)));
    public static final RegistryObject<Structure<NoFeatureConfig>> MOUNTAIN_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("mountain_way_point", () -> new WayPointStructure("mountain_way_point", Biome.Category.EXTREME_HILLS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("mushroom_way_point", () -> new WayPointStructure("mushroom_way_point", Biome.Category.MUSHROOM)));
    public static final RegistryObject<Structure<NoFeatureConfig>> PLAINS_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("plains_way_point", () -> new WayPointStructure("plains_way_point", Biome.Category.PLAINS)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SAVANNA_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("savanna_way_point", () -> new WayPointStructure("savanna_way_point", Biome.Category.SAVANNA)));
    public static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_WAY_POINT = PixelmonStructures.add(PixelmonStructures.register("swamp_way_point", () -> new WayPointStructure("swamp_way_point", Biome.Category.SWAMP)));
    public static final RegistryObject<Structure<NoFeatureConfig>> WATER_TOWER = PixelmonStructures.add(PixelmonStructures.register("tower_water", () -> new DenStructure("tower_water", Biome.Category.BEACH)));
    public static final RegistryObject<Structure<NoFeatureConfig>> DARKNESS_TOWER = PixelmonStructures.add(PixelmonStructures.register("tower_darkness", () -> new DenStructure("tower_darkness", Biome.Category.BEACH)));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_DESERT_DECO = PixelmonStructures.add(PixelmonStructures.register("ultra_desert_deco", () -> new BiomeGenericStructure("ultra_space/desert/ruins", "pixelmon:ultra_desert")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_JUNGLE_DECO = PixelmonStructures.add(PixelmonStructures.register("ultra_jungle_deco", () -> new BiomeGenericStructure("ultra_space/jungle/ruins", "pixelmon:ultra_jungle")));
    public static final RegistryObject<Structure<NoFeatureConfig>> ULTRA_CRATER_DEN = PixelmonStructures.add(PixelmonStructures.register("ultra_crater_den", () -> new BiomeGenericStructure("ultra_crater_den", "pixelmon:ultra_crater")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PUMPKIN_HOUSE = PixelmonStructures.add(PixelmonStructures.register("pumpkin_house", () -> new BiomeGenericStructure("pumpkin_house", "minecraft:plains")));
    public static final RegistryObject<Structure<GymConfig>> GYMS = PixelmonStructures.register("gyms", () -> new GymStructure(GymConfig.CODEC));
    public static final IJigsawDeserializer<MovingJigsawPiece> MOVING = PixelmonStructures.register("moving", MovingJigsawPiece.CODEC);
    public static final IJigsawDeserializer<AdvancedMovingJigsawPiece> ADVANCED_MOVING = PixelmonStructures.register("advanced_moving", AdvancedMovingJigsawPiece.CODEC);
    public static IStructurePieceType GEYSER = PixelmonStructures.setPieceId(CraterGeyserPiece::new, "geyser");
    public static final RegistryObject<Structure<NoFeatureConfig>> CRATER_GYSER = PixelmonStructures.add(PixelmonStructures.register("crater_geyser", () -> new CraterGyserStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));

    static <P extends JigsawPiece> IJigsawDeserializer<P> register(String p_236851_0_, Codec<P> p_236851_1_) {
        return (IJigsawDeserializer)Registry.func_218322_a((Registry)Registry.field_218365_F, (ResourceLocation)new ResourceLocation("pixelmon", p_236851_0_), () -> p_236851_1_);
    }

    public static RegistryObject<Structure<NoFeatureConfig>> add(RegistryObject<Structure<NoFeatureConfig>> value) {
        ALL_STRUCTURES.add(value);
        return value;
    }

    public static <F extends Structure<?>> RegistryObject<F> register(String name, Supplier<Structure<?>> supplier) {
        RegistryObject structure = STRUCTURE_REGISTRY.register(name, supplier);
        return structure;
    }

    private static <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, F> register2(String p_244162_0_, StructureFeature<FC, F> p_244162_1_) {
        return (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("pixelmon", p_244162_0_), p_244162_1_);
    }

    public static void setupStuctures() {
        PixelmonStructures.setupMapSpacingAndLand((Structure)HAUNTED_TOWER.get(), new StructureSeparationSettings(40, 30, 734341285), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)UNO_SHRINE.get(), new StructureSeparationSettings(20, 10, 84316135), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DOS_SHRINE.get(), new StructureSeparationSettings(20, 10, 83316135), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)TRES_SHRINE.get(), new StructureSeparationSettings(20, 10, 82316135), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ILEX_SHRINE.get(), new StructureSeparationSettings(20, 10, 85216132), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)LAND_CHALICE.get(), new StructureSeparationSettings(50, 40, 85216132), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)WATER_CHALICE.get(), new StructureSeparationSettings(50, 40, 85416132), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SPEAR_PILLAR.get(), new StructureSeparationSettings(50, 40, 82316132), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)PLASMA_SHIP.get(), new StructureSeparationSettings(70, 65, 182324632), false);
        PixelmonStructures.setupMapSpacingAndLand((Structure)BOATS.get(), new StructureSeparationSettings(20, 10, 22324352), false);
        PixelmonStructures.setupMapSpacingAndLand((Structure)GRAVEYARD.get(), new StructureSeparationSettings(20, 10, 392261212), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)BADLANDS_DEN.get(), new StructureSeparationSettings(12, 8, 69583270), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)BEACH_DEN.get(), new StructureSeparationSettings(12, 8, 69583270), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DESERT_DEN.get(), new StructureSeparationSettings(12, 8, 69583271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)FOREST_DEN.get(), new StructureSeparationSettings(12, 8, 69583272), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ICE_DEN.get(), new StructureSeparationSettings(12, 8, 69583272), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)JUNGLE_DEN.get(), new StructureSeparationSettings(12, 8, 69583272), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)MOUNTAIN_DEN.get(), new StructureSeparationSettings(12, 8, 69583273), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)PLAINS_DEN.get(), new StructureSeparationSettings(12, 8, 69583274), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SNOW_DEN.get(), new StructureSeparationSettings(12, 8, 69583275), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)TAIGA_DEN.get(), new StructureSeparationSettings(12, 8, 69583276), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)WATER_DEN.get(), new StructureSeparationSettings(12, 8, 69583277), false);
        PixelmonStructures.setupMapSpacingAndLand((Structure)MUSHROOM_DEN.get(), new StructureSeparationSettings(12, 8, 69583278), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)NETHER_DEN.get(), new StructureSeparationSettings(12, 8, 69583279), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)END_DEN.get(), new StructureSeparationSettings(12, 8, 69583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SWAMP_DEN.get(), new StructureSeparationSettings(12, 8, 69583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_DEEP_SEA_DEN.get(), new StructureSeparationSettings(12, 8, 69583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_DESERT_DEN.get(), new StructureSeparationSettings(12, 8, 23583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_FOREST_DEN.get(), new StructureSeparationSettings(12, 8, 23583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_JUNGLE_DEN.get(), new StructureSeparationSettings(12, 8, 74583280), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_PLANT_DEN.get(), new StructureSeparationSettings(12, 8, 47116206), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)BADLANDS_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DARK_FOREST_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DESERT_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)END_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)FOREST_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)HILLS_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ICY_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)JUNGLE_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)MUSHROOM_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)NETHER_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)OCEANS_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)PLAINS_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SAVANNA_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SWAMP_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)TAIGA_GROTTO.get(), new StructureSeparationSettings(12, 8, 992833271), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)BADLANDS_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DESERT_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)FOREST_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ICE_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)JUNGLE_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)MOUNTAIN_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)MUSHROOM_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)PLAINS_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SAVANNA_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)SWAMP_WAY_POINT.get(), new StructureSeparationSettings(6, 4, 72534885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)WATER_TOWER.get(), new StructureSeparationSettings(20, 15, -1274647121), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)DARKNESS_TOWER.get(), new StructureSeparationSettings(20, 15, 1537557437), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_DESERT_DECO.get(), new StructureSeparationSettings(4, 2, 23344885), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_JUNGLE_DECO.get(), new StructureSeparationSettings(4, 2, 133125685), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_DESERT_GROTTO.get(), new StructureSeparationSettings(4, 2, 24561125), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_SEA_GROTTO.get(), new StructureSeparationSettings(4, 2, 133213985), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_FOREST_GROTTO.get(), new StructureSeparationSettings(4, 2, 133213985), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_JUNGLE_GROTTO.get(), new StructureSeparationSettings(4, 2, 133213985), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_PLANT_GROTTO.get(), new StructureSeparationSettings(4, 2, 731106734), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)CRATER_GYSER.get(), new StructureSeparationSettings(4, 2, 912387111), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)ULTRA_CRATER_DEN.get(), new StructureSeparationSettings(8, 4, 194957136), false);
        PixelmonStructures.setupMapSpacingAndLand((Structure)GYMS.get(), new StructureSeparationSettings(64, 24, 233215985), true);
        PixelmonStructures.setupMapSpacingAndLand((Structure)PUMPKIN_HOUSE.get(), new StructureSeparationSettings(32, 12, 1331801172), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings settings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)settings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(s -> {
            Map structureMap = ((DimensionSettings)s.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap tempMap = Maps.newHashMap((Map)structureMap);
                tempMap.put(structure, settings);
                ((DimensionSettings)s.getValue()).func_236108_a_().func_236195_a_();
            } else {
                structureMap.put(structure, settings);
            }
        });
    }

    static IStructurePieceType setPieceId(IStructurePieceType p_214750_0_, String p_214750_1_) {
        return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)p_214750_1_.toLowerCase(Locale.ROOT), (Object)p_214750_0_);
    }
}

