/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.gyms;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.world.generation.gyms.MovesetDefinition;
import java.util.ArrayList;

public class PokemonDefinition {
    private Species pokemon;
    private float rarity = 1.0f;
    private int minLevel = 0;
    private int maxLevel = PixelmonServerConfig.maxLevel;
    private ArrayList<MovesetDefinition> movesets = new ArrayList();

    public static PokemonDefinition readPokemonDefinition(String gymName, JsonObject obj) {
        PokemonDefinition def = new PokemonDefinition();
        Species pokemon = PixelmonSpecies.fromNameOrDex(obj.get("name").getAsString()).orElse(null);
        if (pokemon == null) {
            Pixelmon.LOGGER.warn("Couldn't find pokemon " + obj.get("name").getAsString() + " for gym " + gymName);
        } else {
            def.pokemon = pokemon;
        }
        if (obj.has("minLevel")) {
            def.minLevel = obj.get("minLevel").getAsInt();
        }
        if (obj.has("maxLevel")) {
            def.maxLevel = obj.get("maxLevel").getAsInt();
        }
        if (obj.has("rarity")) {
            def.rarity = obj.get("rarity").getAsFloat();
        }
        JsonArray movesetArray = obj.getAsJsonArray("sets");
        for (int j = 0; j < movesetArray.size(); ++j) {
            JsonObject setObj = movesetArray.get(j).getAsJsonObject();
            def.movesets.add(MovesetDefinition.readMovesetDefinition(setObj));
        }
        return def;
    }

    public Species getPokemon() {
        return this.pokemon;
    }

    public void setPokemon(Species pokemon) {
        this.pokemon = pokemon;
    }

    public float getRarity() {
        return this.rarity;
    }

    public void setRarity(float rarity) {
        this.rarity = rarity;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public void setMinLevel(int minLevel) {
        this.minLevel = minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public ArrayList<MovesetDefinition> getMovesets() {
        return this.movesets;
    }

    public void setMovesets(ArrayList<MovesetDefinition> movesets) {
        this.movesets = movesets;
    }
}

