/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.plant;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.TumblestoneBlock;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.fml.RegistryObject;

public class PlantMonolithFeature
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation LOOT_TABLE = ResourceLocationHelper.of("pixelmon", "chests/ultraspace/plant_monolith");

    public PlantMonolithFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.025f)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos.func_177958_n(), generator.func_222532_b(pos.func_177958_n(), pos.func_177956_o(), Heightmap.Type.WORLD_SURFACE_WG), pos.func_177952_p());
        while (mutablePos.func_177956_o() > 20 && ((blockState = level.func_180495_p((BlockPos)mutablePos)).func_203425_a(Blocks.field_150350_a) || blockState.func_203425_a(Blocks.field_150355_j))) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
        }
        int originY = mutablePos.func_177956_o();
        int radius = RandomHelper.getRandomNumberBetween(5, 15);
        int height = this.generateSphereWithRadius(level, mutablePos, pos, radius, 65, 90);
        int tumblestone = RandomHelper.getRandomNumberBetween(5, (int)(0.75 * (double)radius));
        for (int i = 0; i < tumblestone; ++i) {
            int randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            int randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            while (randomX * randomX + randomZ * randomZ - (radius - 1) * (radius - 1) >= 0) {
                randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
                randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            }
            this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_181079_c(pos.func_177958_n() + randomX, originY + height, pos.func_177952_p() + randomZ), (BlockState)this.getRandomTumblestone().func_176223_P().func_206870_a((Property)TumblestoneBlock.AGE, (Comparable)Integer.valueOf(5)));
        }
        if (RandomHelper.getRandomChance(0.25f)) {
            int randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            int randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            while (randomX * randomX + randomZ * randomZ - (radius - 1) * (radius - 1) >= 0) {
                randomX = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
                randomZ = RandomHelper.getRandomNumberBetween(0, 2 * radius) - radius;
            }
            this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_181079_c(pos.func_177958_n() + randomX, originY + height, pos.func_177952_p() + randomZ), Blocks.field_150486_ae.func_176223_P());
            LockableLootTileEntity.func_195479_a((IBlockReader)level, (Random)random, (BlockPos)mutablePos, (ResourceLocation)LOOT_TABLE);
        }
        return true;
    }

    private int generateSphereWithRadius(ISeedReader level, BlockPos.Mutable mutablePos, BlockPos pos, int radius, int minHeight, int maxHeight) {
        int originalY = mutablePos.func_177956_o();
        int height = RandomHelper.getRandomNumberBetween(minHeight, maxHeight);
        for (int y = 0; y < height; ++y) {
            mutablePos.func_185336_p(originalY + y);
            int calculatedRadius = radius + Math.max(0, height / 10 - y / radius);
            for (int x = -calculatedRadius; x < calculatedRadius; ++x) {
                for (int z = -calculatedRadius; z < calculatedRadius; ++z) {
                    mutablePos.func_223471_o(pos.func_177958_n() + x);
                    mutablePos.func_223472_q(pos.func_177952_p() + z);
                    if (x * x + z * z - (calculatedRadius - 1) * (calculatedRadius - 1) >= 0) continue;
                    this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, Blocks.field_150343_Z.func_176223_P());
                }
            }
        }
        return height;
    }

    private Block getRandomTumblestone() {
        return (Block)((RegistryObject)RandomHelper.getRandomElementFromCollection(Lists.newArrayList((Object[])new RegistryObject[]{BlockRegistration.BLACK_TUMBLESTONE, BlockRegistration.BLUE_TUMBLESTONE, BlockRegistration.RED_TUMBLESTONE}))).get();
    }
}

