/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.debug;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class PixelmonDebugChunkGenerator
extends DebugChunkGenerator {
    public static final Codec<PixelmonDebugChunkGenerator> CODEC = RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).xmap(PixelmonDebugChunkGenerator::new, DebugChunkGenerator::func_242727_g).stable().codec();
    private static List<PokemonBase> ALL_POKEMONS;
    private static int GRID_WIDTH;
    private static int GRID_HEIGHT;

    public PixelmonDebugChunkGenerator(Registry<Biome> p_i241974_1_) {
        super(p_i241974_1_);
    }

    public void func_230351_a_(WorldGenRegion p_230351_1_, StructureManager p_230351_2_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = p_230351_1_.func_201679_a();
        int j = p_230351_1_.func_201680_b();
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (i << 4) + k;
                int j1 = (j << 4) + l;
                p_230351_1_.func_180501_a((BlockPos)blockpos$mutable.func_181079_c(i1, 60, j1), field_185935_b, 2);
                PokemonBase pokemonBaseFor = PixelmonDebugChunkGenerator.getPokemonBaseFor(i1, j1);
                if (pokemonBaseFor == null) continue;
                StatueEntity entity = new StatueEntity((World)p_230351_1_.func_201672_e());
                entity.func_70107_b(i1, 61.0, j1);
                entity.setPokemon(pokemonBaseFor.toPokemon());
                p_230351_1_.func_217376_c((Entity)entity);
            }
        }
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome p_230353_1_, StructureManager p_230353_2_, EntityClassification p_230353_3_, BlockPos p_230353_4_) {
        return super.func_230353_a_(p_230353_1_, p_230353_2_, p_230353_3_, p_230353_4_);
    }

    public static PokemonBase getPokemonBaseFor(int posX, int posZ) {
        int i;
        if (posX > 0 && posZ > 0 && posX % 10 == 0 && posZ % 10 == 0 && posX / 100 <= GRID_WIDTH && posZ / 100 <= GRID_HEIGHT && (i = MathHelper.func_76130_a((int)(posX / 100 * GRID_WIDTH + posZ / 100))) < ALL_POKEMONS.size()) {
            return ALL_POKEMONS.get(i);
        }
        return null;
    }

    public static void init() {
        ALL_POKEMONS = Lists.newArrayList();
        for (Species species : PixelmonSpecies.getAll()) {
            for (Stats form : species.getForms()) {
                for (GenderProperties genderProperty : form.getGenderProperties()) {
                    for (PaletteProperties palette : genderProperty.getPalettes()) {
                        ALL_POKEMONS.add(new PokemonBase(species, form, palette, genderProperty.getGender()));
                    }
                }
            }
        }
        GRID_WIDTH = MathHelper.func_76123_f((float)MathHelper.func_76129_c((float)ALL_POKEMONS.size()));
        GRID_HEIGHT = MathHelper.func_76123_f((float)(ALL_POKEMONS.size() / GRID_WIDTH));
    }
}

