/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnActionNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;

public class PlayerBasedLevels
implements SpawningTweak,
SpawnerCondition {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (action instanceof SpawnActionPokemon) {
            SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
            if (!(action.spawnInfo instanceof SpawnInfoPokemon)) {
                return;
            }
            SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)action.spawnInfo;
            PixelmonEntity pixelmon = (PixelmonEntity)actionPokemon.getOrCreateEntity();
            if (pixelmon.isBossPokemon() || pixelmon.isLegendary()) {
                return;
            }
            int newLevel = this.getTweakedLevel(spawner, actionPokemon, actionPokemon.pokemon.getPokemonLevel(), spawnInfo.minLevel, spawnInfo.maxLevel);
            pixelmon.getPokemon().setLevel(newLevel);
            pixelmon.func_70606_j(pixelmon.getPokemon().getHealth());
        } else if (action instanceof SpawnActionNPCTrainer) {
            SpawnActionNPCTrainer actionTrainer = (SpawnActionNPCTrainer)action;
            SpawnInfoNPCTrainer infoTrainer = (SpawnInfoNPCTrainer)actionTrainer.spawnInfo;
            NPCTrainer trainer = (NPCTrainer)((Object)actionTrainer.getOrCreateEntity());
            trainer.setPokemonLevel(this.getTweakedLevel(spawner, actionTrainer, trainer.pokemonLevel, infoTrainer.getMinLevel(), infoTrainer.getMaxLevel()));
        }
    }

    public int getTweakedLevel(AbstractSpawner spawner, SpawnAction<? extends Entity> action, int level, int min, int max) {
        int adjustedMax;
        int adjustedMin;
        if (min == max || !(action.spawnLocation.cause instanceof ServerPlayerEntity)) {
            return level;
        }
        PlayerPartyStorage storage = spawner instanceof PlayerTrackingSpawner ? ((PlayerTrackingSpawner)spawner).playerStorage : StorageProxy.getParty((ServerPlayerEntity)action.spawnLocation.cause);
        if (storage == null) {
            return level;
        }
        TransientData td = storage.transientData;
        if (td.highestLevel < 20) {
            adjustedMin = td.lowestLevel - 10;
            adjustedMax = td.highestLevel + 5;
        } else if (td.highestLevel < 40) {
            adjustedMin = td.lowestLevel - 20;
            adjustedMax = td.highestLevel + 15;
        } else {
            adjustedMin = 1;
            adjustedMax = PixelmonServerConfig.maxLevel;
        }
        if (action instanceof SpawnActionNPCTrainer && td.highestLevel >= 20) {
            adjustedMin = td.lowestLevel - 10;
            adjustedMax = td.highestLevel + 10;
        }
        return MathHelper.func_76125_a((int)RandomHelper.getRandomNumberBetween(adjustedMin, adjustedMax), (int)min, (int)max);
    }

    @Override
    public boolean fits(AbstractSpawner spawner, SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        int adjustedMax;
        int adjustedMin;
        if (!(spawnLocation.cause instanceof ServerPlayerEntity) || spawner == PixelmonSpawning.fishingSpawner) {
            return true;
        }
        PlayerPartyStorage storage = spawner instanceof PlayerTrackingSpawner ? ((PlayerTrackingSpawner)spawner).playerStorage : StorageProxy.getParty((ServerPlayerEntity)spawnLocation.cause);
        if (storage == null) {
            return true;
        }
        TransientData td = storage.transientData;
        if (td.highestLevel < 25) {
            adjustedMin = td.lowestLevel - 10;
            adjustedMax = td.highestLevel + 5;
        } else if (td.highestLevel < 40) {
            adjustedMin = td.lowestLevel - 20;
            adjustedMax = td.highestLevel + 15;
        } else {
            return true;
        }
        int min = MathHelper.func_76125_a((int)adjustedMin, (int)1, (int)PixelmonServerConfig.maxLevel);
        int max = Math.min(adjustedMax, PixelmonServerConfig.maxLevel);
        if (spawnInfo instanceof SpawnInfoPokemon) {
            SpawnInfoPokemon spawn = (SpawnInfoPokemon)spawnInfo;
            PokemonSpecification spec = spawn.getPokemonSpec();
            Species species = spawn.getSpecies();
            if (species != null) {
                Stats stats = spawn.getForm();
                if (stats == null) {
                    return false;
                }
                if (min > stats.maxLevel || max < stats.minLevel) {
                    return false;
                }
                if (spawn.minLevel > max || spawn.maxLevel < min) {
                    return false;
                }
            }
        } else if (spawnInfo instanceof SpawnInfoNPCTrainer) {
            SpawnInfoNPCTrainer spawn = (SpawnInfoNPCTrainer)spawnInfo;
            if (spawn.getMinLevel() == spawn.getMaxLevel()) {
                return true;
            }
            if (min > spawn.getMaxPartySize() || max < spawn.getMinLevel()) {
                return false;
            }
        }
        return true;
    }
}

