/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.battle;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.UUIDHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;

public class TrainerObjective
implements IObjective {
    private final String identifier;

    public TrainerObjective(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public int quantity(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments) {
        return arguments.quantity(1, progress);
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", true, false, ArgumentType.ENTITY_UUID, new String[0]), new QuestElementArgument("count", false, false, ArgumentType.WHOLE_NUMBER, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), UUIDHelper::questUUID), Argument.from(args.get(1), Integer::parseInt));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        Entity entity = (Entity)context.get(0);
        UUID uuid = (UUID)arguments.value(0, progress);
        return uuid == null || uuid.equals(Util.field_240973_b_) || entity.func_110124_au().equals(uuid);
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stage, QuestProgress progress, Objective objective, int objectiveIndex, Arguments arguments, Context context) {
        UUID uuid;
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        if (!progress.isObjectiveComplete(objectiveIndex) && (uuid = (UUID)arguments.value(0, progress)) != null) {
            markers.add(new QuestMarker(uuid, DimensionHelper.getDimension("minecraft:overworld"), progress.getQuest().getColor(), progress.getMarkerType()));
        }
        return markers;
    }
}

