/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WhiteHerbItem
extends HeldItem {
    public WhiteHerbItem() {
        super(EnumHeldItems.whiteHerb, new Item.Properties());
    }

    @Override
    public void onStatModified(PixelmonWrapper holder, PixelmonWrapper affected) {
        if (affected.getBattleStats().isLoweredThisTurn() && WhiteHerbItem.healStats(affected)) {
            affected.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        if (!WhiteHerbItem.healStats(userWrapper)) {
            userWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    public static boolean healStats(PixelmonWrapper affected) {
        boolean activated = false;
        int[] stages = affected.getBattleStats().getStages();
        for (int i = 0; i < 7; ++i) {
            if (stages[i] >= 0) continue;
            affected.getBattleStats().resetStat(i);
            activated = true;
        }
        if (activated) {
            affected.bc.sendToAll("pixelmon.helditems.whiteherb", affected.getNickname());
        }
        return activated;
    }
}

