/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.item.Item;

public class EjectPackItem
extends HeldItem {
    public EjectPackItem() {
        super(EnumHeldItems.ejectPack, new Item.Properties());
    }

    @Override
    public void onStatDecrease(PixelmonWrapper attacker, PixelmonWrapper target, int amount, BattleStatsType stat) {
        if (!attacker.bc.simulateMode && amount > 0 && target.isAlive()) {
            if (attacker.lastAttack != null && attacker.lastAttack.isAttack(AttackRegistry.PARTING_SHOT)) {
                return;
            }
            if (target.stopsForcedSwitches(target)) {
                return;
            }
            BattleParticipant targetParticipant = target.getParticipant();
            ParticipantType targetType = targetParticipant.getType();
            if (targetType == ParticipantType.WildPokemon || !targetParticipant.hasMorePokemonReserve()) {
                return;
            }
            this.setUpSwitch(target);
            if (targetType == ParticipantType.Player) {
                NetworkHelper.sendPacket(new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, targetParticipant), true), target.getPlayerOwner());
            } else {
                target.bc.switchPokemon(target.getPokemonUUID(), target.getBattleAI().getNextSwitch(target), true);
            }
        }
    }

    private void setUpSwitch(PixelmonWrapper target) {
        target.bc.sendToAll("pixelmon.helditems.ejectpack", target.getNickname());
        target.consumeItem();
        target.setUpSwitchMove();
    }
}

