/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PixelmonItem
extends Item {
    private boolean hasEffect = false;
    private boolean isDrink = false;
    private boolean tempt = false;
    private boolean searchable = true;

    public PixelmonItem(Item.Properties properties) {
        super(properties);
    }

    public PixelmonItem setDrink() {
        this.isDrink = true;
        return this;
    }

    public PixelmonItem setTempt() {
        this.tempt = true;
        return this;
    }

    public boolean func_219971_r() {
        return this.func_219967_s() != null;
    }

    public boolean isDrink() {
        return this.isDrink;
    }

    public PixelmonItem setHasEffect(boolean hasEffect) {
        this.hasEffect = hasEffect;
        return this;
    }

    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack) {
        ServerPlayerEntity player = pixelmonWrapper.getPlayerOwner();
        if (player != null) {
            return !player.func_184812_l_();
        }
        return false;
    }

    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack, int additionalInfo) {
        return this.useFromBag(pixelmonWrapper, target, stack);
    }

    public String getLocalizedName() {
        return new TranslationTextComponent(this.func_77658_a() + "").getString();
    }

    public boolean func_77636_d(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("HasEffect")) {
            return true;
        }
        return this.hasEffect || itemstack.func_77948_v();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String tt = this.getTooltipText(stack);
        if (!tt.isEmpty()) {
            if (ScreenHelper.isKeyDown(340)) {
                for (String s : tt.split("\n")) {
                    tooltip.add(TextHelper.colour(TextFormatting.GRAY + s));
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.tooltip.collapsed", (Object[])new Object[0])));
            }
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public String getTooltipText(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("tooltip")) {
            return nbt.func_74779_i("tooltip");
        }
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".tooltip"))) {
            return I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]);
        }
        return "";
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.func_219971_r()) {
            return UseAction.EAT;
        }
        if (this.isDrink()) {
            return UseAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public boolean causeTempt() {
        return this.tempt;
    }

    public PixelmonItem hideFromSearches() {
        this.searchable = false;
        return this;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && (this.isSearchable() || group != ItemGroup.field_78027_g)) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }
}

