/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NPCEditorItem
extends PixelmonItem {
    public NPCEditorItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_UTILITY).func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (world.field_72995_K || !player.func_184812_l_() || context.func_221531_n() != Hand.MAIN_HAND || !NPCEditorItem.checkPermission(player)) {
            return ActionResultType.PASS;
        }
        if (context.func_196000_l() != Direction.UP) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        OpenScreenPacket.open(player, EnumGuiScreen.CreateNpc, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return ActionResultType.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return super.onLeftClickEntity(stack, player, entity);
        }
        if (entity instanceof NPCEntity && NPCEditorItem.checkPermission(player)) {
            OpenScreenPacket.open(player, EnumGuiScreen.DeleteNpc, entity.func_145782_y());
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public static boolean checkPermission(PlayerEntity player) {
        if (PixelmonConfigProxy.getGeneral().isNpcEditorOpOnly()) {
            if (!player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.general.needop", new Object[0]);
                return false;
            }
            return true;
        }
        return PlayerHelper.hasPermission((ServerPlayerEntity)player, "pixelmon.npceditor.use");
    }
}

