/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleForceEndCause;
import com.pixelmonmod.pixelmon.api.events.battles.ForceEndBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Mist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.block.BlockState;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.Event;

public class BattleItem
extends PixelmonItem {
    public com.pixelmonmod.pixelmon.api.battles.BattleItem type;
    private boolean infinite;

    public BattleItem(com.pixelmonmod.pixelmon.api.battles.BattleItem type) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_RESTORATION).func_200917_a(16).setNoRepair());
        this.type = type;
        this.infinite = type == com.pixelmonmod.pixelmon.api.battles.BattleItem.RED_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.GREEN_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.BLUE_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.YELLOW_FLUTE;
    }

    public boolean execute(PixelmonWrapper pxm) {
        switch (this.type) {
            case RED_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Infatuated)) {
                    pxm.bc.sendToAll("pixelmon.status.infatuatedcureitem", pxm.getOwnerName(), pxm.getNickname());
                    pxm.removeStatus(StatusType.Infatuated, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case GREEN_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.getMaxHealth() > pxm.getHealth()) {
                    pxm.bc.sendToAll("pixelmon.effect.restorehealth", pxm.getNickname());
                    pxm.healEntityBy(20);
                    pxm.update(EnumUpdateType.HP);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case YELLOW_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Confusion)) {
                    pxm.bc.sendToAll("pixelmon.status.confusioncureitem", pxm.getOwnerName(), pxm.getNickname());
                    pxm.removeStatus(StatusType.Confusion, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case BLUE_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Sleep)) {
                    pxm.bc.sendToAll("pixelmon.status.wokeup", pxm.getNickname());
                    pxm.removeStatus(StatusType.Sleep, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case DIRE_HIT: {
                if (pxm.getBattleStats().getCritStage() == 0) {
                    pxm.getBattleStats().increaseCritStage(2, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case MAX_MUSHROOM: {
                pxm.getBattleStats().modifyStat(1, BattleStatsType.ATTACK);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.DEFENSE);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_ATTACK);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_DEFENSE);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPEED);
                return true;
            }
            case GUARD_SPEC: {
                if (pxm.addTeamStatus(new Mist(), pxm)) {
                    pxm.bc.sendToAll("pixelmon.effect.usemist", pxm.getNickname());
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case FLUFFY_TAIL: {
                ForceEndBattleEvent event = new ForceEndBattleEvent(pxm.bc, BattleForceEndCause.FLUFFY_TAIL);
                if (!Pixelmon.EVENT_BUS.post((Event)event)) {
                    pxm.bc.endBattle(BattleEndCause.FORCE);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
        }
        pxm.getBattleStats().modifyStat(2, this.type.getEffectType());
        return true;
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        return this.execute(userWrapper) && super.useFromBag(userWrapper, targetWrapper, stack) && !this.infinite;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_221531_n() == Hand.MAIN_HAND && this.type == com.pixelmonmod.pixelmon.api.battles.BattleItem.MAX_MUSHROOM) {
            context.func_196000_l();
            if (context.func_196000_l() == Direction.UP) {
                BlockState lower;
                BlockPos up = context.func_195995_a().func_177984_a();
                if (context.func_195991_k().func_175623_d(up) && (lower = context.func_195991_k().func_180495_p(context.func_195995_a())).func_177230_c() instanceof MyceliumBlock) {
                    if (!context.func_195991_k().field_72995_K) {
                        if (!context.func_195999_j().func_184812_l_()) {
                            context.func_195996_i().func_190918_g(1);
                        }
                        context.func_195991_k().func_175656_a(up, PixelmonBlocks.max_mushroom.func_176223_P());
                        context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    if (context.func_195999_j() != null) {
                        context.func_195999_j().func_184609_a(Hand.MAIN_HAND);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }
}

