/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.EnumSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum EnumTrainerCardUser {
    REGULAR,
    MODELER("modeler_text.png"),
    SUPPORT("support_text.png"),
    DEVELOPER("developer_text.png"),
    ADMINISTRATOR("administrator_text.png");

    public final ResourceLocation resource;

    private EnumTrainerCardUser() {
        this.resource = null;
    }

    private EnumTrainerCardUser(String file) {
        this.resource = ResourceLocationHelper.of(Resources.prefix + "gui/trainercards/" + file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EnumTrainerCardUser getFromPlayer(PlayerEntity player) {
        PixelExtrasData data = PlayerExtraDataStore.get(player);
        EnumSet<PixelExtrasData.SashType> ranks = data.getAvailableSashs();
        if (ranks.contains((Object)PixelExtrasData.SashType.RANK_ADMIN) || ranks.contains((Object)PixelExtrasData.SashType.RANK_JR)) {
            return ADMINISTRATOR;
        }
        if (ranks.contains((Object)PixelExtrasData.SashType.RANK_DEV)) {
            return DEVELOPER;
        }
        if (ranks.contains((Object)PixelExtrasData.SashType.RANK_SUPPORT)) {
            return SUPPORT;
        }
        if (ranks.contains((Object)PixelExtrasData.SashType.RANK_MODELER)) {
            return MODELER;
        }
        return REGULAR;
    }
}

