/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.WoodType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.registries.ForgeRegistries;

public enum BerryType {
    CHERI(2, 5, 5, 10, 0, 0, 0, 0, DyeColor.RED, 1, () -> PixelmonFeatures.CHERI_TREE),
    CHESTO(2, 5, 5, 0, 10, 0, 0, 0, DyeColor.PURPLE, 1, () -> PixelmonFeatures.CHESTO_TREE),
    PECHA(2, 5, 5, 0, 0, 10, 0, 0, DyeColor.PINK, 1, () -> PixelmonFeatures.PECHA_TREE),
    RAWST(2, 5, 5, 0, 0, 0, 10, 0, DyeColor.GREEN, 1, () -> PixelmonFeatures.RAWST_TREE),
    ASPEAR(2, 5, 5, 0, 0, 0, 0, 10, DyeColor.YELLOW, 1, () -> PixelmonFeatures.ASPEAR_TREE),
    LEPPA(2, 5, 5, 10, 0, 10, 10, 10, DyeColor.RED, 1, () -> PixelmonFeatures.LEPPA_TREE),
    ORAN(2, 3, 5, 10, 10, 0, 10, 10, DyeColor.BLUE, 1, () -> PixelmonFeatures.ORAN_TREE),
    PERSIM(2, 5, 5, 10, 10, 10, 0, 10, DyeColor.PINK, 2, () -> PixelmonFeatures.PERSIM_TREE),
    LUM(2, 5, 5, 10, 10, 10, 10, 0, DyeColor.GREEN, 2, () -> PixelmonFeatures.LUM_TREE),
    SITRUS(2, 5, 5, 0, 10, 10, 10, 10, DyeColor.YELLOW, 2, () -> PixelmonFeatures.SITRUS_TREE),
    FIGY(1, 5, 5, 15, 0, 0, 0, 0, DyeColor.RED, 3, () -> PixelmonFeatures.FIGY_TREE),
    WIKI(1, 5, 5, 0, 15, 0, 0, 0, DyeColor.PURPLE, 3, () -> PixelmonFeatures.WIKI_TREE),
    MAGO(1, 5, 5, 0, 0, 15, 0, 0, DyeColor.PINK, 3, () -> PixelmonFeatures.MAGO_TREE),
    AGUAV(1, 5, 5, 0, 0, 0, 15, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.AGUAV_TREE),
    IAPAPA(1, 5, 5, 0, 0, 0, 0, 15, DyeColor.YELLOW, 3, () -> PixelmonFeatures.IAPAPA_TREE),
    RAZZ(3, 6, 5, 10, 10, 0, 0, 0, DyeColor.RED, 1, () -> PixelmonFeatures.RAZZ_TREE),
    BLUK(3, 6, 5, 0, 10, 10, 0, 0, DyeColor.PURPLE, 1, () -> PixelmonFeatures.BLUK_TREE),
    NANAB(3, 6, 5, 0, 0, 10, 10, 0, DyeColor.PINK, 1, () -> PixelmonFeatures.NANAB_TREE),
    WEPEAR(3, 6, 5, 0, 0, 0, 10, 10, DyeColor.GREEN, 1, () -> PixelmonFeatures.WEPEAR_TREE),
    PINAP(2, 10, 5, 10, 0, 0, 0, 10, DyeColor.YELLOW, 1, () -> PixelmonFeatures.PINAP_TREE),
    POMEG(1, 5, 5, 10, 0, 10, 10, 0, DyeColor.RED, 3, () -> PixelmonFeatures.POMEG_TREE),
    KELPSY(1, 5, 5, 0, 10, 0, 10, 10, DyeColor.BLUE, 3, () -> PixelmonFeatures.KELPSY_TREE),
    QUALOT(1, 5, 5, 10, 0, 10, 0, 10, DyeColor.YELLOW, 3, () -> PixelmonFeatures.QUALOT_TREE),
    HONDEW(1, 5, 5, 10, 10, 0, 10, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.HONDEW_TREE),
    GREPA(1, 5, 5, 0, 10, 10, 0, 10, DyeColor.YELLOW, 3, () -> PixelmonFeatures.GREPA_TREE),
    TAMATO(1, 5, 5, 20, 10, 0, 0, 0, DyeColor.RED, 3, () -> PixelmonFeatures.TAMATO_TREE),
    CORNN(2, 10, 5, 0, 20, 10, 0, 0, DyeColor.PURPLE, 1, () -> PixelmonFeatures.CORNN_TREE),
    MAGOST(2, 10, 5, 0, 0, 20, 10, 0, DyeColor.PINK, 1, () -> PixelmonFeatures.MAGOST_TREE),
    RABUTA(2, 10, 5, 0, 0, 0, 20, 10, DyeColor.GREEN, 1, () -> PixelmonFeatures.RABUTA_TREE),
    NOMEL(2, 10, 5, 10, 0, 0, 0, 20, DyeColor.YELLOW, 1, () -> PixelmonFeatures.NOMEL_TREE),
    SPELON(2, 15, 6, 30, 10, 0, 0, 0, DyeColor.RED, 1, () -> PixelmonFeatures.SPELON_TREE),
    PAMTRE(3, 15, 6, 0, 30, 10, 0, 0, DyeColor.PURPLE, 1, () -> PixelmonFeatures.PAMTRE_TREE),
    WATMEL(2, 15, 6, 0, 0, 30, 10, 0, DyeColor.PINK, 1, () -> PixelmonFeatures.WATMEL_TREE),
    DURIN(3, 15, 6, 0, 0, 0, 30, 10, DyeColor.GREEN, 1, () -> PixelmonFeatures.DURIN_TREE),
    BELUE(2, 15, 6, 10, 0, 0, 0, 30, DyeColor.PURPLE, 1, () -> PixelmonFeatures.BELUE_TREE),
    OCCA(1, 5, 7, 15, 0, 10, 0, 0, DyeColor.RED, 2, () -> PixelmonFeatures.OCCA_TREE),
    PASSHO(1, 5, 7, 0, 15, 0, 10, 0, DyeColor.BLUE, 2, () -> PixelmonFeatures.PASSHO_TREE),
    WACAN(1, 5, 7, 0, 0, 15, 0, 10, DyeColor.YELLOW, 2, () -> PixelmonFeatures.WACAN_TREE),
    RINDO(1, 5, 7, 10, 0, 0, 15, 0, DyeColor.GREEN, 2, () -> PixelmonFeatures.RINDO_TREE),
    YACHE(1, 5, 7, 0, 10, 0, 0, 15, DyeColor.BLUE, 2, () -> PixelmonFeatures.YACHE_TREE),
    CHOPLE(1, 5, 7, 15, 0, 0, 10, 0, DyeColor.RED, 2, () -> PixelmonFeatures.CHOPLE_TREE),
    KEBIA(1, 5, 7, 0, 15, 0, 0, 10, DyeColor.GREEN, 2, () -> PixelmonFeatures.KEBIA_TREE),
    SHUCA(1, 5, 7, 10, 0, 15, 0, 0, DyeColor.YELLOW, 2, () -> PixelmonFeatures.SHUCA_TREE),
    COBA(1, 5, 7, 0, 10, 0, 15, 0, DyeColor.BLUE, 2, () -> PixelmonFeatures.COBA_TREE),
    PAYAPA(1, 5, 7, 0, 0, 10, 0, 15, DyeColor.PURPLE, 2, () -> PixelmonFeatures.PAYAPA_TREE),
    TANGA(1, 5, 7, 20, 0, 0, 0, 10, DyeColor.GREEN, 2, () -> PixelmonFeatures.TANGA_TREE),
    CHARTI(1, 5, 7, 10, 20, 0, 0, 0, DyeColor.YELLOW, 2, () -> PixelmonFeatures.CHARTI_TREE),
    KASIB(1, 5, 7, 0, 10, 20, 0, 0, DyeColor.PURPLE, 2, () -> PixelmonFeatures.KASIB_TREE),
    HABAN(1, 5, 7, 0, 0, 10, 20, 0, DyeColor.RED, 2, () -> PixelmonFeatures.HABAN_TREE),
    COLBUR(1, 5, 7, 0, 0, 0, 10, 20, DyeColor.PURPLE, 2, () -> PixelmonFeatures.COLBUR_TREE),
    BABIRI(1, 5, 7, 25, 10, 0, 0, 0, DyeColor.GREEN, 2, () -> PixelmonFeatures.BABIRI_TREE),
    CHILAN(1, 5, 7, 0, 25, 10, 0, 0, DyeColor.YELLOW, 2, () -> PixelmonFeatures.CHILAN_TREE),
    ROSELI(1, 5, 7, 0, 0, 25, 10, 0, DyeColor.PINK, 3, () -> PixelmonFeatures.ROSELI_TREE),
    LIECHI(1, 5, 10, 30, 10, 30, 0, 0, DyeColor.RED, 3, () -> PixelmonFeatures.LIECHI_TREE),
    GANLON(1, 5, 10, 0, 30, 10, 30, 0, DyeColor.PURPLE, 3, () -> PixelmonFeatures.GANLON_TREE),
    SALAC(1, 5, 10, 0, 0, 30, 10, 30, DyeColor.GREEN, 3, () -> PixelmonFeatures.SALAC_TREE),
    PETAYA(1, 2, 10, 30, 0, 0, 30, 10, DyeColor.PINK, 3, () -> PixelmonFeatures.PETAYA_TREE),
    APICOT(1, 5, 10, 10, 30, 0, 0, 30, DyeColor.BLUE, 3, () -> PixelmonFeatures.APICOT_TREE),
    LANSAT(1, 5, 10, 30, 10, 30, 10, 30, DyeColor.RED, 3, () -> PixelmonFeatures.LANSAT_TREE),
    STARF(1, 2, 10, 30, 10, 30, 10, 30, DyeColor.GREEN, 3, () -> PixelmonFeatures.STARF_TREE),
    PUMKIN(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> PixelmonFeatures.PUMKIN_TREE),
    DRASH(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PINK, 3, () -> PixelmonFeatures.DRASH_TREE),
    EGGANT(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PURPLE, 3, () -> PixelmonFeatures.EGGANT_TREE),
    STRIB(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.STRIB_TREE),
    NUTPEA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> PixelmonFeatures.NUTPEA_TREE),
    GINEMA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> PixelmonFeatures.GINEMA_TREE),
    KUO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.KUO_TREE),
    YAGO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.YAGO_TREE),
    TOUGA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.RED, 3, () -> PixelmonFeatures.TOUGA_TREE),
    NINIKU(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.BLUE, 3, () -> PixelmonFeatures.NINIKU_TREE),
    TOPO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PINK, 3, () -> PixelmonFeatures.TOPO_TREE),
    ENIGMA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PURPLE, 3, () -> PixelmonFeatures.ENIGMA_TREE),
    MICLE(1, 5, 10, 0, 40, 10, 0, 0, DyeColor.GREEN, 3, () -> PixelmonFeatures.MICLE_TREE),
    CUSTAP(1, 5, 10, 0, 0, 40, 10, 0, DyeColor.RED, 3, () -> PixelmonFeatures.CUSTAP_TREE),
    JABOCA(1, 5, 10, 0, 0, 0, 40, 10, DyeColor.YELLOW, 3, () -> PixelmonFeatures.JABOCA_TREE),
    ROWAP(1, 5, 10, 10, 0, 0, 0, 40, DyeColor.BLUE, 3, () -> PixelmonFeatures.ROWAP_TREE),
    KEE(1, 5, 10, 30, 30, 10, 10, 10, DyeColor.YELLOW, 3, () -> PixelmonFeatures.KEE_TREE),
    MARANGA(1, 5, 10, 10, 10, 30, 30, 10, DyeColor.BLUE, 3, () -> PixelmonFeatures.MARANGA_TREE);

    private static final List<BerryType> IMPLEMENTED;
    public final byte minYield;
    public final byte maxYield;
    public final byte growthTime;
    public final boolean isImplemented;
    public final byte spicy;
    public final byte dry;
    public final byte sweet;
    public final byte bitter;
    public final byte sour;
    public final DyeColor color;
    public final byte juiceGroup;
    private final Supplier<ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature;
    private final ResourceLocation berryLocation = ResourceLocationHelper.of("pixelmon:" + this.name().toLowerCase(Locale.ROOT) + "_berry");
    private final ResourceLocation logBlockLocation = ResourceLocationHelper.of("pixelmon:berry_log");
    private final ResourceLocation leavesBlockLocation = ResourceLocationHelper.of("pixelmon:berry_leaves_" + this.name().toLowerCase(Locale.ROOT));
    private final ResourceLocation saplingBlockLocation = ResourceLocationHelper.of("pixelmon:berry_plant_" + this.name().toLowerCase(Locale.ROOT));

    private BerryType(int minYield, int maxYield, int growthTime, int spicy, int dry, int sweet, int bitter, int sour, DyeColor color, int juiceGroup, boolean isImplemented, Supplier<ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature) {
        this.minYield = (byte)minYield;
        this.maxYield = (byte)maxYield;
        this.growthTime = (byte)growthTime;
        this.isImplemented = isImplemented;
        this.spicy = (byte)spicy;
        this.dry = (byte)dry;
        this.sweet = (byte)sweet;
        this.bitter = (byte)bitter;
        this.sour = (byte)sour;
        this.color = color;
        this.juiceGroup = (byte)juiceGroup;
        this.feature = feature;
    }

    private BerryType(int minYield, int maxYield, int growthTime, int spicy, int dry, int sweet, int bitter, int sour, DyeColor color, int juiceGroup, Supplier<ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature) {
        this(minYield, maxYield, growthTime, spicy, dry, sweet, bitter, sour, color, juiceGroup, true, feature);
    }

    public byte getMinYield() {
        return this.minYield;
    }

    public byte getMaxYield() {
        return this.maxYield;
    }

    public byte getGrowthTime() {
        return this.growthTime;
    }

    public boolean isImplemented() {
        return this.isImplemented;
    }

    public byte getSpicy() {
        return this.spicy;
    }

    public byte getDry() {
        return this.dry;
    }

    public byte getSweet() {
        return this.sweet;
    }

    public byte getBitter() {
        return this.bitter;
    }

    public byte getSour() {
        return this.sour;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public byte getJuiceGroup() {
        return this.juiceGroup;
    }

    public ConfiguredFeature<BaseTreeFeatureConfig, ?> getFeature() {
        return this.feature.get();
    }

    public Item getBerryItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.berryLocation);
    }

    public Block getLogBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.logBlockLocation);
    }

    public Block getLeavesBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.leavesBlockLocation);
    }

    public Block getSaplingBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.saplingBlockLocation);
    }

    public WoodType getWoodType() {
        switch (this.color) {
            case BLUE: {
                return PixelmonWoodType.BLUE_BERRY_WOOD;
            }
            case GREEN: {
                return PixelmonWoodType.GREEN_BERRY_WOOD;
            }
            case PINK: {
                return PixelmonWoodType.PINK_BERRY_WOOD;
            }
            case PURPLE: {
                return PixelmonWoodType.PURPLE_BERRY_WOOD;
            }
            case RED: {
                return PixelmonWoodType.RED_BERRY_WOOD;
            }
            case YELLOW: {
                return PixelmonWoodType.YELLOW_BERRY_WOOD;
            }
        }
        return null;
    }

    public Block getSignBlock() {
        switch (this.color) {
            case BLUE: {
                return PixelmonBlocks.blue_berry_wood_sign;
            }
            case GREEN: {
                return PixelmonBlocks.green_berry_wood_sign;
            }
            case PINK: {
                return PixelmonBlocks.pink_berry_wood_sign;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_berry_wood_sign;
            }
            case RED: {
                return PixelmonBlocks.red_berry_wood_sign;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_berry_wood_sign;
            }
        }
        return null;
    }

    public Block getWallSignBlock() {
        switch (this.color) {
            case BLUE: {
                return PixelmonBlocks.blue_berry_wood_wall_sign;
            }
            case GREEN: {
                return PixelmonBlocks.green_berry_wood_wall_sign;
            }
            case PINK: {
                return PixelmonBlocks.pink_berry_wood_wall_sign;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_berry_wood_wall_sign;
            }
            case RED: {
                return PixelmonBlocks.red_berry_wood_wall_sign;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_berry_wood_wall_sign;
            }
        }
        return null;
    }

    @Nonnull
    public static BerryType getImplementedBerry() {
        return RandomHelper.getRandomElementFromCollection(IMPLEMENTED);
    }

    static {
        IMPLEMENTED = new ArrayList<BerryType>();
        for (BerryType berry : BerryType.values()) {
            if (!berry.isImplemented) continue;
            IMPLEMENTED.add(berry);
        }
    }
}

