/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.PokeBallImpactEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.Beam;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

public class EmptyPokeBallEntity
extends PokeBallEntity {
    private int waitTime;
    private int criticalTime = 0;
    private BattleController battleController;
    private boolean isBattleThrown = false;
    private int totalTime;
    private boolean captureFinished;
    private double pokemonPosX;
    private double pokemonPosY;
    private double pokemonPosZ;
    boolean capturedPokemon = false;

    public EmptyPokeBallEntity(EntityType<EmptyPokeBallEntity> type, World world) {
        super(type, world);
    }

    public EmptyPokeBallEntity(World world) {
        this((EntityType<EmptyPokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), world);
    }

    public EmptyPokeBallEntity(World world, LivingEntity entityliving, PokeBall type, boolean dropItem) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), type, world, entityliving, PokeBallMode.EMPTY);
        this.thrower = entityliving;
        this.dropItem = dropItem;
        this.setInitialYaw(this.thrower.field_70177_z);
        this.setInitialPitch(this.thrower.field_70125_A);
        this.func_234612_a_((Entity)entityliving, entityliving.field_70125_A, entityliving.field_70177_z, 0.0f, (float)type.getVelocityModifier(), 0.5f);
    }

    public EmptyPokeBallEntity(World world, LivingEntity thrower, PixelmonEntity target, PokeBall type, BattleController battleController) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), type, world, thrower, PokeBallMode.BATTLE);
        this.thrower = thrower;
        this.dropItem = false;
        this.endRotationYaw = thrower.field_70759_as;
        this.pixelmon = target;
        this.isBattleThrown = true;
        this.battleController = battleController;
        this.field_70170_p = thrower.field_70170_p;
        battleController.pauseBattle();
        this.func_70012_b(thrower.func_226277_ct_(), thrower.func_226278_cu_() + (double)thrower.func_70047_e(), thrower.func_226281_cx_(), thrower.field_70177_z, thrower.field_70125_A);
        this.func_70107_b(this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), this.func_226278_cu_() - (double)0.1f, this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f));
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213293_j((double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8, (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8, (double)(-MathHelper.func_76126_a((float)0.0f)) * 0.8);
        this.doCaptureCalc(this.pixelmon);
    }

    @Override
    protected void func_70227_a(RayTraceResult movingobjectposition) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeBallImpactEvent(this, movingobjectposition)) && !this.isBattleThrown) {
            return;
        }
        if (this.dropItem && this.getBallType().getBreakChance() > 0.0 && RandomHelper.getRandomChance(this.getBallType().getBreakChance()) && !this.getIsWaiting() && movingobjectposition.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            for (ItemStack item : this.getComponentItems()) {
                this.func_70099_a(item, 0.0f);
            }
            this.func_241204_bJ_();
            return;
        }
        if (this.isBattleThrown && !this.field_70170_p.field_72995_K) {
            if (!this.getIsWaiting()) {
                this.startBattleCapture();
            } else {
                this.startShake();
            }
        } else {
            if (movingobjectposition.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockState state = this.field_70170_p.func_180495_p(((BlockRayTraceResult)movingobjectposition).func_216350_a());
                Block hitBlock = state.func_177230_c();
                Material mat = state.func_185904_a();
                if (hitBlock == Blocks.field_196804_gh || mat == Material.field_151585_k) {
                    return;
                }
                if (!this.getIsWaiting() && mat.func_76220_a()) {
                    if (this.dropItem) {
                        this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.func_241204_bJ_();
                    this.func_174812_G();
                    return;
                }
                if (this.getIsWaiting()) {
                    EntityHelper.setPosition((Entity)this, EnumRotation.y, ((BlockRayTraceResult)movingobjectposition).func_216350_a().func_177956_o() + 1);
                    EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.0);
                    this.setIsOnGround(true);
                    this.func_230245_c_(true);
                }
                return;
            }
            if (movingobjectposition instanceof EntityRayTraceResult && ((EntityRayTraceResult)movingobjectposition).func_216348_a() instanceof PixelmonEntity) {
                if (this.getIsWaiting()) {
                    return;
                }
                this.dropItem = false;
                this.pixelmon = (PixelmonEntity)((EntityRayTraceResult)movingobjectposition).func_216348_a();
                this.setPairedEntity((Entity)this.pixelmon);
                this.pokemonPosX = this.pixelmon.func_226277_ct_();
                this.pokemonPosY = this.pixelmon.func_226278_cu_();
                this.pokemonPosZ = this.pixelmon.func_226281_cx_();
                if (this.pixelmon.battleController != null) {
                    boolean inBattle = false;
                    if (this.pixelmon.battleController.checkValid()) {
                        inBattle = true;
                    } else if (this.pixelmon.getTrainer() != null) {
                        this.pixelmon.func_241204_bJ_();
                        inBattle = true;
                    }
                    if (inBattle) {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                        if (this.dropItem) {
                            this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                        }
                        this.func_241204_bJ_();
                        return;
                    }
                }
                if (this.pixelmon.getBossTier().isBoss()) {
                    ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.boss", new Object[0]);
                    if (this.dropItem) {
                        this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.func_241204_bJ_();
                    return;
                }
                if (this.pixelmon.getPokemon().isUncatchable()) {
                    ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.aura", new Object[0]);
                    if (this.dropItem) {
                        this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.func_241204_bJ_();
                    return;
                }
                if (this.pixelmon.hasOwner() || this.pixelmon.getTrainer() != null) {
                    if (this.pixelmon.getOwner() == this.thrower) {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.alreadyown", new Object[0]);
                    } else {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.otherspokemon", new Object[0]);
                    }
                    if (this.dropItem) {
                        this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.func_241204_bJ_();
                    return;
                }
                if (this.pixelmon.hitByPokeball != null) {
                    return;
                }
                this.pixelmon.hitByPokeball = this;
                if (!this.getIsWaiting()) {
                    this.startCapture();
                }
            } else if (this.getIsWaiting()) {
                this.startShake();
            } else {
                if (this.dropItem) {
                    this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                }
                this.func_241204_bJ_();
                return;
            }
        }
        super.func_70227_a(movingobjectposition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnRedBeam() {
        PixelmonEntity entity = (PixelmonEntity)this.field_70170_p.func_73045_a(this.getPairedEntity());
        if (entity == null) {
            return;
        }
        if (!Minecraft.func_71410_x().func_147113_T() && this.field_70146_Z.nextInt(2) == 0) {
            double w = entity.getForm().getDimensions().getWidth() / 2.0;
            double h = entity.getForm().getDimensions().getHeight() / 2.0;
            double dx = this.field_70146_Z.nextDouble() * w - w / 2.0;
            double dy = this.field_70146_Z.nextDouble() * h;
            double dz = this.field_70146_Z.nextDouble() * w - w / 2.0;
            ParticleArcanery parent = new ParticleArcanery(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, new Beam((Entity)this, (Entity)entity, new Vector3d(this.field_70146_Z.nextDouble() * 0.05, this.field_70146_Z.nextDouble() * 0.05 + 0.05, this.field_70146_Z.nextDouble() * 0.05), new Vector3d(dx, dy, dz), 0.05, 15, 0.05f, 0.15f, 0.15f, 3.0f, -6, 2.0f, 1.0f, 0.0f, 0.0f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)parent);
        }
    }

    private void startCapture() {
        this.pixelmon.func_213317_d(Vector3d.field_186680_a);
        this.initialScale = this.pixelmon.getPixelmonScale();
        this.setIsWaiting(true);
        this.setPokeballID(this.canCatch ? this.numShakes : -1 * this.numShakes);
        this.pixelmon.func_213317_d(Vector3d.field_186680_a);
        this.field_70125_A = 0.0f;
        this.func_213317_d(Vector3d.field_186680_a);
        int i = -2;
        while (!this.field_70170_p.func_175623_d(new BlockPos((int)this.func_226277_ct_(), (int)Math.ceil(this.func_226278_cu_()) + i, (int)this.func_226281_cx_()))) {
            ++i;
        }
        EntityHelper.setPosition((Entity)this, EnumRotation.y, Math.ceil(this.func_226278_cu_()) + (double)i + (double)0.1f);
    }

    private void startBattleCapture() {
        this.pokemonPosX = this.pixelmon.func_226277_ct_();
        this.pokemonPosY = this.pixelmon.func_226278_cu_();
        this.pokemonPosZ = this.pixelmon.func_226281_cx_();
        this.pixelmon.hitByPokeball = this;
        this.startCapture();
        this.func_70107_b((int)this.func_226277_ct_(), this.func_226278_cu_(), (int)this.func_226281_cx_());
    }

    private void forceBattleCapture() {
        this.startBattleCapture();
        this.pixelmon.unloadEntity();
        this.setIsOnGround(true);
    }

    private void startShake() {
        this.func_213317_d(Vector3d.field_186680_a);
        this.setIsOnGround(true);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70071_h_();
            return;
        }
        EntityHelper.setMotion((Entity)this, EnumRotation.y, EntityHelper.getMotion((Entity)this, EnumRotation.y) * this.getBallType().getGravityModifier());
        ++this.totalTime;
        ++this.criticalTime;
        if (this.criticalTime == 43 && this.getCritical()) {
            ServerWorld world = (ServerWorld)this.field_70170_p;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 0.6f, 1.2f);
            for (int i = 0; i < 15; ++i) {
                world.func_195598_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.75);
            }
        }
        if (this.func_226278_cu_() <= -40.0 && !this.getIsOnGround() && this.pixelmon != null) {
            this.setIsOnGround(true);
        }
        if (this.getIsOnGround()) {
            if (this.waitTime < 0) {
                this.waitTime = 0;
            }
            ++this.waitTime;
        }
        if (this.capturedPokemon) {
            if (this.waitTime > 20) {
                this.storeCapture();
                this.func_241204_bJ_();
            }
        } else {
            ((Object)((Object)this)).getClass();
            if (this.waitTime > this.numShakes * 25) {
                this.catchPokemon();
                this.waitTime = 0;
            } else if (this.totalTime > 100 && this.isBattleThrown && !this.getIsWaiting() && !this.captureFinished) {
                this.forceBattleCapture();
            }
        }
        super.func_70071_h_();
    }

    private void storeCapture() {
        this.pixelmon.retrieve("PokemonCaught");
        Pokemon pokemon = this.pixelmon.getPokemon();
        if (pokemon.getOwnerPlayer() != null) {
            this.setIsWaiting(false);
            return;
        }
        pokemon.setOriginalTrainer((PlayerEntity)((ServerPlayerEntity)this.thrower));
        pokemon.setBall(this.getBallType());
        pokemon.setFriendship(pokemon.getForm().getSpawn().getBaseFriendship());
        this.getBallType().getLogic().doAfterEffect(this.getBallType(), this, this.pixelmon);
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayerEntity)this.thrower, pokemon, "PokeBall"))) {
            return;
        }
        PokedexEvent.Pre preEvent = new PokedexEvent.Pre(this.thrower.func_110124_au(), pokemon, PokedexRegistrationStatus.CAUGHT, "capture");
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            PlayerPokedex.set(this.thrower.func_110124_au(), pokemon, PokedexRegistrationStatus.CAUGHT);
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.thrower.func_110124_au(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        StorageProxy.getParty((ServerPlayerEntity)this.thrower).add(pokemon);
        if (this.getMode() == PokeBallMode.BATTLE) {
            PlayerParticipant p = (PlayerParticipant)this.battleController.getParticipantForEntity(this.thrower);
            Experience.awardExp(this.battleController.participants, p, this.pixelmon.getPixelmonWrapper());
            this.battleController.endBattle(BattleEndCause.FORCE);
        }
        this.setIsWaiting(false);
        StorageProxy.getParty((ServerPlayerEntity)((ServerPlayerEntity)this.thrower)).stats.addCaughtTypes(pokemon.getForm().getTypes());
        StorageProxy.getParty((ServerPlayerEntity)((ServerPlayerEntity)this.thrower)).transientData.captureCombo.onCapture((ServerPlayerEntity)this.thrower, pokemon.getSpecies());
        PixelmonAdvancements.throwCaptureTriggers((ServerPlayerEntity)this.thrower, this.getBallType(), pokemon);
    }

    protected void catchPokemon() {
        if (!this.isBattleThrown && this.pixelmon.battleController != null) {
            boolean inBattle = false;
            if (this.pixelmon.battleController.checkValid()) {
                inBattle = true;
            } else if (this.pixelmon.getTrainer() != null) {
                inBattle = true;
            }
            if (inBattle) {
                ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                if (this.dropItem) {
                    this.func_70099_a(this.getBallType().getBallItem(), 0.0f);
                }
                this.func_241204_bJ_();
                return;
            }
        }
        this.captureFinished = true;
        if (this.canCatch) {
            boolean transformedToDitto;
            CaptureEvent.SuccessfulCapture capEvent = new CaptureEvent.SuccessfulCapture((ServerPlayerEntity)this.thrower, this.pixelmon, this);
            if (Pixelmon.EVENT_BUS.post((Event)capEvent)) {
                this.failCapture();
                return;
            }
            this.pixelmon = capEvent.getPokemon();
            this.pixelmon.getPokemon().setOriginalTrainer((PlayerEntity)((ServerPlayerEntity)this.thrower));
            if (!this.pixelmon.getPokemon().getBonusStats().isPersistentAfterCapture()) {
                this.pixelmon.getPokemon().setBonusStats(new BonusStats());
            }
            TranslationTextComponent message = ChatHandler.getMessage((transformedToDitto = this.checkReallyADitto()) ? "pixelmon.pokeballs.capturetransform" : "pixelmon.pokeballs.capture", this.pixelmon.getLocalizedName());
            if (this.pixelmon.battleController == null) {
                ChatHandler.sendChat((ICommandSource)this.thrower, message);
            } else {
                PixelmonWrapper pw = this.pixelmon.getPixelmonWrapper();
                if (pw != null) {
                    pw.resetOnSwitch();
                    HeldItem currentHeldItem = pw.getHeldItem();
                    if (currentHeldItem != NoItem.noItem && currentHeldItem != pw.initialCopyOfPokemon.getHeldItemAsItemHeld()) {
                        pw.enableReturnHeldItem();
                    }
                }
                this.pixelmon.battleController.sendToAll(message);
                Experience.awardExp(this.pixelmon.battleController.participants, this.pixelmon.getParticipant(), pw);
            }
            this.tryApplyRibbons();
            this.capturedPokemon = true;
            this.waitTime = 0;
        } else {
            this.failCapture();
        }
    }

    private boolean checkReallyADitto() {
        boolean transformToDitto;
        boolean isMeltan = this.pixelmon.getSpecies().is(PixelmonSpecies.MELTAN);
        boolean bl = transformToDitto = this.field_70146_Z.nextDouble() <= PixelmonConfigProxy.getSpawning().getTransformToDittoOnCatch();
        if (PixelmonSpecies.getLegendaries().contains(this.pixelmon.getSpecies().getDex()) || !PixelmonConfigProxy.getSpawning().getCanTransformToDittoOnCatch().contains(this.pixelmon.getPokemonName())) {
            transformToDitto = false;
        }
        if (transformToDitto || isMeltan && this.field_70146_Z.nextDouble() <= PixelmonConfigProxy.getSpawning().getMeltanTransformChance()) {
            transformToDitto = true;
            int level = this.pixelmon.getPokemon().getPokemonLevel();
            boolean isShiny = this.pixelmon.getPokemon().isShiny();
            this.pixelmon.getPokemon().setSpecies(PixelmonSpecies.DITTO, true);
            this.pixelmon.getPokemon().initialize(InitializeCategory.INTRINSIC_FORCEFUL, InitializeCategory.SPECIES);
            this.pixelmon.getPokemon().setLevel(level);
            this.pixelmon.getPokemon().setShiny(isShiny);
        }
        return transformToDitto;
    }

    private void tryApplyRibbons() {
        ServerPlayerEntity player;
        int rolls = 1;
        if (this.func_234616_v_() instanceof ServerPlayerEntity && StorageProxy.getParty(player = (ServerPlayerEntity)this.func_234616_v_()).getMarkCharm().isActive()) {
            rolls = PixelmonConfigProxy.getGeneral().getMarkCharmRolls();
        }
        for (int i = 0; i < rolls; ++i) {
            if (this.pixelmon.getPokemon().getRibbons().size() != 0) continue;
            if (Math.random() <= 0.001) {
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RARE.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.01) {
                this.pixelmon.getPokemon().addRibbon(RandomHelper.getRandomElementFromArray(RibbonRegistry.GROUP_28).getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.UNCOMMON.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                Biome biome;
                WeatherType weatherType;
                if (this.pixelmon.battleController != null) {
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.MistyTerrain)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.MISTY.getValueUnsafe());
                        continue;
                    }
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.Sandstorm)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SANDSTORM.getValueUnsafe());
                        continue;
                    }
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.Sunny)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DRY.getValueUnsafe());
                        continue;
                    }
                    weatherType = WeatherType.get(this.field_70170_p);
                    biome = this.field_70170_p.func_226691_t_(this.pixelmon.func_233580_cy_());
                    if (weatherType == WeatherType.RAIN) {
                        if (biome.func_201851_b() == Biome.RainType.SNOW) {
                            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SNOWY.getValueUnsafe());
                            continue;
                        }
                        if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RAINY.getValueUnsafe());
                        continue;
                    }
                    if (weatherType == WeatherType.STORM) {
                        if (biome.func_201851_b() == Biome.RainType.SNOW) {
                            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.BLIZZARD.getValueUnsafe());
                            continue;
                        }
                        if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.STORMY.getValueUnsafe());
                        continue;
                    }
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.CLOUDY.getValueUnsafe());
                    continue;
                }
                weatherType = WeatherType.get(this.field_70170_p);
                biome = this.field_70170_p.func_226691_t_(this.pixelmon.func_233580_cy_());
                if (weatherType == WeatherType.RAIN) {
                    if (biome.func_201851_b() == Biome.RainType.SNOW) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SNOWY.getValueUnsafe());
                        continue;
                    }
                    if (biome.func_201851_b() != Biome.RainType.RAIN) continue;
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RAINY.getValueUnsafe());
                    continue;
                }
                if (weatherType == WeatherType.STORM) {
                    if (biome.func_201851_b() == Biome.RainType.SNOW) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.BLIZZARD.getValueUnsafe());
                        continue;
                    }
                    if (biome.func_201851_b() != Biome.RainType.RAIN) continue;
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.STORMY.getValueUnsafe());
                    continue;
                }
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.CLOUDY.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                List<WorldTime> current = WorldTime.getCurrent(this.field_70170_p);
                if (current.contains(WorldTime.AFTERNOON)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.LUNCHTIME.getValueUnsafe());
                    continue;
                }
                if (current.contains(WorldTime.DUSK)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DUSK.getValueUnsafe());
                    continue;
                }
                if (current.contains(WorldTime.NIGHT) || current.contains(WorldTime.DAWN)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SLEEPY_TIME.getValueUnsafe());
                    continue;
                }
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DAWN.getValueUnsafe());
                continue;
            }
            if (!(Math.random() <= 0.04) || this.battleController == null || !this.battleController.wasFishing) continue;
            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.FISHING.getValueUnsafe());
        }
    }

    private void failCapture() {
        Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.FailedCapture((ServerPlayerEntity)this.thrower, this.pixelmon, this));
        this.openAngle = -1.5707964f;
        this.waitTime = 0;
        this.setIsWaiting(false);
        this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.hitByPokeball = null;
        if (this.field_70170_p.func_73045_a(this.pixelmon.func_145782_y()) != null) {
            this.pixelmon.unloadEntity();
        }
        this.pixelmon.revive();
        this.field_70170_p.func_217376_c((Entity)this.pixelmon);
        this.pixelmon.getPokemon().updateDimensionAndEntityID((RegistryKey<World>)this.field_70170_p.func_234923_W_(), this.pixelmon.func_145782_y());
        this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.resetAlterations(this.initialScale);
        this.pixelmon.revive();
        this.getBallType().getLogic().doFailEffect(this.getBallType(), this, this.pixelmon);
        TranslationTextComponent message = ChatHandler.getMessage("pixelmon.pokeballs.brokefree", this.pixelmon.getLocalizedName());
        if (this.getMode() == PokeBallMode.BATTLE && !this.battleController.battleEnded) {
            this.pixelmon.battleController = this.battleController;
            if (this.pixelmon.transformed != null) {
                this.pixelmon.updateTransformed();
            }
            PlayerParticipant playerParticipant = (PlayerParticipant)this.battleController.getParticipantForEntity(this.thrower);
            playerParticipant.lastFailedCapture = this.getBallType();
            this.battleController.sendToAll(message);
            this.battleController.endPause();
        } else {
            ChatHandler.sendChat((ICommandSource)this.thrower, message);
        }
        this.func_241204_bJ_();
    }

    public void func_241204_bJ_() {
        if (this.isBattleThrown && !this.captureFinished) {
            if (!this.getIsWaiting()) {
                this.forceBattleCapture();
            }
            this.catchPokemon();
            return;
        }
        if (this.capturedPokemon && this.getIsWaiting()) {
            this.storeCapture();
        }
        if (this.pixelmon != null && this.pixelmon.hitByPokeball == this) {
            this.pixelmon.hitByPokeball = null;
        }
        super.func_241204_bJ_();
    }
}

