/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.movement;

import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementBase;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class PixelmonMovementFlying
extends PixelmonMovementBase {
    public PixelmonMovementFlying(AbstractMovesEntity dragon) {
        super(dragon);
    }

    @Override
    public void handleMovement(List<EnumKeybinds> movements) {
        ControlledMovementLogic mountedFlyingParameters = this.pixelmon.getForm().getMovement().getMountedFlyingParameters();
        if (this.pixelmon != null && this.pixelmon.getOwner() != null && BattleRegistry.getBattle((PlayerEntity)this.pixelmon.getOwner()) != null) {
            this.pixelmon.func_213293_j(0.0, 0.0, 0.0);
            this.pixelmon.func_213315_a(MoverType.SELF, Vector3d.field_186680_a);
        } else if (mountedFlyingParameters != null) {
            mountedFlyingParameters.handleMovement(movements, this.pixelmon);
        }
    }

    @Override
    public void onLivingUpdate() {
        ControlledMovementLogic mountedFlyingParameters = this.pixelmon.getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters != null) {
            mountedFlyingParameters.travelCustom(this.pixelmon, this);
        }
    }

    @Override
    public void updatePassenger(Entity passenger, Vector3f offsets) {
        Vector3d lookVec = this.pixelmon.func_213322_ci();
        if (this.pixelmon.isHovering()) {
            lookVec = this.pixelmon.func_70040_Z();
            lookVec = lookVec.func_178787_e(new Vector3d(0.0, -2.0 * lookVec.field_72448_b, 0.0));
        }
        if (this.pixelmon.getStaysHorizontalInRender()) {
            lookVec = new Vector3d(this.pixelmon.func_213322_ci().func_82615_a(), 0.0, this.pixelmon.func_213322_ci().func_82616_c());
        }
        lookVec = lookVec.func_72432_b();
        Vector3d upVec = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vec = new Vector3d(0.0, 0.0, 0.0);
        Vector3d yVec = null;
        if (this.pixelmon.getStaysHorizontalInRender()) {
            yVec = lookVec.func_72431_c(new Vector3d(1.0, 0.0, 1.0));
        } else {
            Vector3d horizVec = lookVec.func_72431_c(new Vector3d(0.0, 1.0, 0.0));
            yVec = lookVec.func_72431_c(horizVec);
        }
        if (yVec.field_72448_b < 0.0) {
            yVec = yVec.func_186678_a(-1.0);
        }
        yVec = yVec.func_72432_b();
        if (offsets.func_195902_c() != 0.0f) {
            double zPosScale = (offsets.func_195902_c() + this.pixelmon.func_213302_cg()) * this.pixelmon.getPixelmonScale() * this.pixelmon.getScaleFactor();
            vec = vec.func_72441_c(yVec.field_72450_a * zPosScale, yVec.field_72448_b * zPosScale, yVec.field_72449_c * zPosScale);
        }
        if (offsets.func_195900_b() != 0.0f) {
            double yPosScale = offsets.func_195900_b() * this.pixelmon.getPixelmonScale() * this.pixelmon.getScaleFactor();
            vec = vec.func_72441_c(lookVec.field_72450_a * yPosScale, lookVec.field_72448_b * yPosScale, lookVec.field_72449_c * yPosScale);
        }
        Matrix3f matRot = this.createRotationMatrix(lookVec);
        Vector3d vecRot = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        vecRot = this.transform(matRot, vecRot);
        passenger.func_70107_b(this.pixelmon.func_226277_ct_() + vecRot.field_72450_a, this.pixelmon.func_226278_cu_() + vecRot.field_72448_b, this.pixelmon.func_226281_cx_() + vecRot.field_72449_c);
    }

    public final Vector3d transform(Matrix3f mat, Vector3d t) {
        double x = (double)mat.field_226097_a_ * t.func_82615_a() + (double)mat.field_226098_b_ * t.func_82617_b() + (double)mat.field_226099_c_ * t.func_82616_c();
        double y = (double)mat.field_226100_d_ * t.func_82615_a() + (double)mat.field_226101_e_ * t.func_82617_b() + (double)mat.field_226102_f_ * t.func_82616_c();
        double z = (double)mat.field_226103_g_ * t.func_82615_a() + (double)mat.field_226104_h_ * t.func_82617_b() + (double)mat.field_226105_i_ * t.func_82616_c();
        return new Vector3d(x, y, z);
    }
}

