/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Dig {
    public static ArrayList<Block> allowedBlocks = new ArrayList();

    public static MoveSkill createMoveSkill() {
        allowedBlocks = Lists.newArrayList((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150435_aG, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150346_d});
        MoveSkill moveSkill = new MoveSkill("dig").setName("pixelmon.moveskill.dig").describe("pixelmon.moveskill.dig.description1", "pixelmon.moveskill.dig.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/dig.png")).setAnyMoves("Dig").setUsePP(true);
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            Direction sideHit = (Direction)tup.func_76340_b();
            BlockPos pos = (BlockPos)tup.func_76341_a();
            int depth = 74 - (int)(((float)pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) - 20.0f) / 180.0f * 74.0f);
            if (depth < 2) {
                depth = 2;
            }
            int maxOff = 1;
            if (pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) > 150) {
                maxOff = 2;
            }
            if (pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) > 300) {
                maxOff = 3;
            }
            if (pos.func_177956_o() < depth) {
                pixelmon.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.NEUTRAL, 0.3f, 0.1f);
            } else {
                int yOff;
                int xOff;
                if (sideHit == Direction.UP) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == Direction.DOWN) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == Direction.SOUTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff2 = -1 * maxOff; yOff2 <= maxOff; ++yOff2) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, yOff2, 0));
                        }
                    }
                } else if (sideHit == Direction.NORTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff3 = -1 * maxOff; yOff3 <= maxOff; ++yOff3) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, yOff3, 0));
                        }
                    }
                } else if (sideHit == Direction.EAST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(0, yOff, zOff));
                        }
                    }
                } else if (sideHit == Direction.WEST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(0, yOff, zOff));
                        }
                    }
                }
                pixelmon.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            }
            float speed = pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            return (int)(300.0f * (1.0f - LineCalc.lerp(speed, 1.0f, 200.0f, 0.0f, 0.5f)));
        });
        return moveSkill;
    }

    private static void doHarvest(PixelmonEntity user, BlockPos pos) {
        ServerPlayerEntity player;
        boolean flag;
        BlockState state = user.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (allowedBlocks.contains(block) && (flag = block.canHarvestBlock(state, (IBlockReader)user.field_70170_p, pos, (PlayerEntity)(player = (ServerPlayerEntity)user.getOwner()))) && Dig.removeBlock(pos, user.field_70170_p, player, true, player.func_71121_q().func_204610_c(pos))) {
            user.field_70170_p.func_175655_b(pos, true);
        }
    }

    private static boolean removeBlock(BlockPos pos, World theWorld, ServerPlayerEntity playerMP, boolean canHarvest, FluidState fluid) {
        BlockState iblockstate = theWorld.func_180495_p(pos);
        boolean flag = false;
        Block block = iblockstate.func_177230_c();
        block.func_176208_a(theWorld, pos, iblockstate, (PlayerEntity)playerMP);
        flag = block.removedByPlayer(iblockstate, theWorld, pos, (PlayerEntity)playerMP, canHarvest, fluid);
        if (flag) {
            block.func_176206_d((IWorld)theWorld, pos, iblockstate);
        }
        return flag;
    }
}

