/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class KyuremFormChange
implements IFormChange {
    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == PixelmonItems.dna_splicers;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.KYUREM) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayerEntity player) {
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        if (!pixelmon.getForm().isForm(PixelmonForms.NONE)) {
            ItemFormChangeEvent event;
            CompoundNBT fusedPokemonNBT = pixelmon.getPokemon().getPersistentData().func_74775_l("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.isEmpty()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.func_200200_C_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().func_82580_o("FusedPokemon");
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), pixelmon.field_70170_p, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isPalette("shiny"), PixelmonSpecies.ZEKROM.getValueUnsafe().getName().equals(fusedPokemonNBT.func_74779_i("Name")) ? 0.5 : 1.0, 0.5, PixelmonSpecies.ZEKROM.getValueUnsafe().getName().equals(fusedPokemonNBT.func_74779_i("Name")) ? 1.0 : 0.5, 0.0), pixelmon.field_70170_p);
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FUSION_BOLT, new Attack(AttackRegistry.SCARY_FACE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FUSION_FLARE, new Attack(AttackRegistry.SCARY_FACE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FREEZE_SHOCK, new Attack(AttackRegistry.GLACIATE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.ICE_BURN, new Attack(AttackRegistry.GLACIATE));
            pixelmon.getPokemon().setForm(PixelmonForms.NONE);
        } else {
            Pokemon pokemon = storage.findOne(p -> !p.isEgg() && p.isPokemonOptional(PixelmonSpecies.RESHIRAM, PixelmonSpecies.ZEKROM));
            if (pokemon == null) {
                ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.interaction.kyurem.notfound", pixelmon.func_145748_c_());
                return true;
            }
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187853_gC, SoundCategory.NEUTRAL, 0.3f, 0.2f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.RADIALTHUNDER, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), pixelmon.field_70170_p, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isPalette("shiny"), pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM) ? 0.5 : 1.0, 0.5, pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM) ? 1.0 : 0.5), pixelmon.field_70170_p);
            pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            storage.set((StoragePosition)pokemon.getStorageAndPosition().func_76340_b(), null);
            CompoundNBT pokenbt = new CompoundNBT();
            pokemon.writeToNBT(pokenbt);
            pixelmon.getPokemon().getPersistentData().func_218657_a("FusedPokemon", (INBT)pokenbt);
            if (pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM)) {
                pixelmon.setForm("black");
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.SCARY_FACE, new Attack(AttackRegistry.FUSION_BOLT));
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.GLACIATE, new Attack(AttackRegistry.FREEZE_SHOCK));
            } else {
                pixelmon.setForm("white");
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.SCARY_FACE, new Attack(AttackRegistry.FUSION_FLARE));
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.GLACIATE, new Attack(AttackRegistry.ICE_BURN));
            }
        }
        return true;
    }
}

