/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom;

import com.google.common.collect.Maps;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.CameruptInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.MiltankInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.ShearInteraction;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public abstract class PixelmonInteraction {
    public int maxInteractions;
    public int counter = 400;
    private static final Map<RegistryValue<Species>, Supplier<? extends PixelmonInteraction>> PIXELMON_INTERACTIONS = Maps.newHashMap();

    public PixelmonInteraction(int maxInteractions) {
        this.maxInteractions = maxInteractions;
    }

    public boolean processInteract(AbstractBaseEntity pixelmon, PlayerEntity player, Hand hand, ItemStack itemstack) {
        if (pixelmon instanceof AbstractInteractionsEntity) {
            AbstractInteractionsEntity poke = (AbstractInteractionsEntity)pixelmon;
            poke.setNumInteractions(poke.getNumInteractions() - 1);
        }
        if (this.counter <= 0) {
            this.resetCounter(pixelmon);
        }
        return true;
    }

    public void resetCounter(AbstractBaseEntity pixelmon) {
        if (!pixelmon.field_70170_p.field_72995_K) {
            this.counter = pixelmon.func_70681_au().nextInt(600) + 800;
        }
    }

    @Nullable
    public static PixelmonInteraction getInteraction(Species species) {
        Supplier<? extends PixelmonInteraction> interaction = PIXELMON_INTERACTIONS.get(species.getRegistryValue());
        if (interaction == null) {
            return null;
        }
        return interaction.get();
    }

    static {
        PIXELMON_INTERACTIONS.put(PixelmonSpecies.MILTANK, MiltankInteraction::new);
        PIXELMON_INTERACTIONS.put(PixelmonSpecies.CAMERUPT, CameruptInteraction::new);
        PIXELMON_INTERACTIONS.put(PixelmonSpecies.MAREEP, ShearInteraction::new);
        PIXELMON_INTERACTIONS.put(PixelmonSpecies.WOOLOO, ShearInteraction::new);
        PIXELMON_INTERACTIONS.put(PixelmonSpecies.DUBWOOL, ShearInteraction::new);
    }
}

