/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.TechnicalMoveItem;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class InteractionTechnicalMove
implements IInteraction {
    @Override
    public boolean processInteract(PixelmonEntity pixelmon, PlayerEntity player, Hand hand, ItemStack stack) {
        if (stack.func_77973_b() instanceof TechnicalMoveItem) {
            if (!pixelmon.isOwnedBy((LivingEntity)player)) {
                return false;
            }
            Pokemon pokemon = pixelmon.getPokemon();
            ITechnicalMove technicalMove = TechnicalMoveItem.getMove(stack);
            if (technicalMove == null) {
                return true;
            }
            if (!pixelmon.getForm().getMoves().canLearn(technicalMove)) {
                if (pixelmon.getForm().getMoves().canLearnViaOtherSet(technicalMove)) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.interaction.tmcantlearncanother", pixelmon.getNickname(), technicalMove.getAttack().getTranslatedName());
                } else {
                    ChatHandler.sendChat((Entity)player, "pixelmon.interaction.tmcantlearn", pixelmon.getNickname(), technicalMove.getAttack().getTranslatedName());
                }
                return true;
            }
            if (pokemon.getMoveset().hasAttack(technicalMove.getAttack())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.interaction.tmknown", pixelmon.getNickname(), technicalMove.getAttack().getTranslatedName());
                return true;
            }
            if (pokemon.getMoveset().size() >= 4) {
                if (!player.func_184812_l_()) {
                    ItemStack cost = stack.func_77946_l();
                    cost.func_190920_e(1);
                    Predicate<ServerPlayerEntity> condition = null;
                    if (technicalMove instanceof Gen8TechnicalRecords) {
                        condition = !PixelmonConfigProxy.getGeneral().getTMs().isAllowTRReuse() ? LearnMoveController.itemCostCondition(cost).and(this.addReminderMove(technicalMove, pokemon)) : this.addReminderMove(technicalMove, pokemon);
                    } else if (!PixelmonConfigProxy.getGeneral().getTMs().isAllowTMReuse()) {
                        condition = LearnMoveController.itemCostCondition(cost);
                    }
                    LearnMoveController.sendLearnMove((ServerPlayerEntity)player, pokemon.getUUID(), technicalMove.getAttack(), condition);
                } else {
                    LearnMoveController.sendLearnMove((ServerPlayerEntity)player, pokemon.getUUID(), technicalMove.getAttack());
                }
            } else {
                pokemon.getMoveset().add(new Attack(technicalMove.getAttack()));
                if (technicalMove instanceof Gen8TechnicalRecords && !pokemon.getMoveset().getReminderMoves().contains(technicalMove.getAttack())) {
                    pokemon.getMoveset().getReminderMoves().add(technicalMove.getAttack());
                }
                pixelmon.update(EnumUpdateType.Moveset);
                ChatHandler.sendChat((Entity)player, "pixelmon.stats.learnedmove", pixelmon.getNickname(), technicalMove.getAttack().getTranslatedName());
                if (!player.func_184812_l_()) {
                    if (technicalMove instanceof Gen8TechnicalRecords && !PixelmonConfigProxy.getGeneral().getTMs().isAllowTRReuse()) {
                        stack.func_190918_g(1);
                    } else if (!PixelmonConfigProxy.getGeneral().getTMs().isAllowTMReuse()) {
                        stack.func_190918_g(1);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Predicate<ServerPlayerEntity> addReminderMove(ITechnicalMove move, Pokemon pokemon) {
        return p -> {
            if (!pokemon.getMoveset().getReminderMoves().contains(move.getAttack())) {
                pokemon.getMoveset().getReminderMoves().add(move.getAttack());
            }
            return true;
        };
    }
}

