/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTutorEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.LoadTutorDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SelectPokemonResponsePacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public class NPCTutor
extends NPCEntity {
    public static final DataSync<NPCTutor, EnumNPCTutorType> SYNC_TUTOR_TYPE = new DataSync<NPCTutor, EnumNPCTutorType>(NPCTutor.class, PixelmonDataSerializers.NPC_TUTOR_TYPE, (npcTutor, type) -> {
        npcTutor.tutorType = type;
    });
    public static ArrayList<ImmutableAttack> allTutorMoves = new ArrayList();
    public static ArrayList<ImmutableAttack> allTransferMoves = new ArrayList();
    public final List<LearnableMove> moveList = Lists.newArrayList();
    public EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);
    private EnumNPCTutorType tutorType;

    public NPCTutor(EntityType<NPCTutor> type, World world) {
        super(type, world);
    }

    public NPCTutor(World world) {
        this((EntityType<NPCTutor>)((EntityType)EntityRegistration.NPC_TUTOR.get()), world);
        this.init("Tutor");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.define(SYNC_TUTOR_TYPE, EnumNPCTutorType.TUTOR);
    }

    @Override
    public void init(String name) {
        if (name.equals("Tutor")) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            name = trainer.name;
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                this.setTextureIndex(RandomHelper.rand.nextInt(trainer.textures.size()));
            }
        }
        super.init(name);
        this.npcLocation = SpawnLocationType.LAND_NPC;
        if (this.moveList.isEmpty()) {
            this.randomiseMoveList();
        }
        if (this.learnTypes.isEmpty()) {
            if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
                this.learnTypes.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
                this.learnTypes.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
            } else {
                this.learnTypes.add(BaseStatsLearnType.TRANSFER_MOVES);
            }
        }
        if (this.getAIMode() != EnumTrainerAI.StandStill) {
            this.setAIMode(EnumTrainerAI.Wander);
        }
        this.initAI();
    }

    @Override
    public String getDisplayText() {
        if (this.getTutorType() == EnumNPCTutorType.TRANSFER) {
            return I18n.func_135052_a((String)"pixelmon.npc.transfername", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    @Override
    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }

    public void setTutorType(EnumNPCTutorType type) {
        SYNC_TUTOR_TYPE.set((Entity)this, (Object)type);
        this.learnTypes.clear();
        if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
            this.learnTypes.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
            this.learnTypes.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
        } else {
            this.learnTypes.add(BaseStatsLearnType.TRANSFER_MOVES);
        }
        this.randomiseMoveList();
    }

    public EnumNPCTutorType getTutorType() {
        return this.tutorType;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("TutorType", this.getTutorType().ordinal());
        if (this.moveList.isEmpty()) {
            nbt.func_74768_a("numAttacks", 0);
            return;
        }
        nbt.func_74768_a("numAttacks", this.moveList.size());
        for (int i = 0; i < this.moveList.size(); ++i) {
            LearnableMove learnableMove = this.moveList.get(i);
            nbt.func_74778_a("attack" + i, learnableMove.attack().getAttackName());
            nbt.func_74768_a("attack" + i + "costNum", learnableMove.costs().size());
            List<ItemStack> costs = learnableMove.costs();
            for (int j = 0; j < costs.size(); ++j) {
                ItemStack current = costs.get(j);
                nbt.func_74768_a("attack" + i + "cost" + j, Item.func_150891_b((Item)current.func_77973_b()));
                nbt.func_74768_a("attack" + i + "cost" + j + "Num", current.func_190916_E());
                if (current.func_77952_i() == 0) continue;
                nbt.func_74768_a("attack" + i + "cost" + j + "Damage", current.func_77952_i());
            }
        }
        if (!this.isDefaultLearnList()) {
            ListNBT list = new ListNBT();
            for (BaseStatsLearnType type : this.learnTypes) {
                list.add((Object)StringNBT.func_229705_a_((String)type.name()));
            }
            nbt.func_218657_a("learnTypes", (INBT)list);
        }
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_220892_d.clear();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, Attributes.field_233821_d_.func_111110_b()));
                break;
            }
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("TutorType")) {
            this.setTutorType(EnumNPCTutorType.values()[nbt.func_74762_e("TutorType")]);
        } else {
            this.setTutorType(EnumNPCTutorType.random());
        }
        int numAttacks = nbt.func_74762_e("numAttacks");
        if (numAttacks > 0) {
            this.moveList.clear();
        }
        for (int i = 0; i < numAttacks; ++i) {
            Optional<ImmutableAttack> optional = AttackRegistry.getAttackBase(nbt.func_74779_i("attack" + i));
            if (!optional.isPresent()) continue;
            int numCosts = nbt.func_74762_e("attack" + i + "costNum");
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack((IItemProvider)Item.func_150899_d((int)nbt.func_74762_e("attack" + i + "cost" + j)), nbt.func_74762_e("attack" + i + "cost" + j + "Num"));
                if (nbt.func_74764_b("attack" + i + "cost" + j + "Damage") && nbt.func_74762_e("attack" + i + "cost" + j + "Damage") != 0) {
                    current.func_196085_b(nbt.func_74762_e("attack" + i + "cost" + j + "Damage"));
                }
                cost.add(current);
            }
            this.moveList.add(new LearnableMove(optional.get(), cost, true));
        }
        if (nbt.func_150297_b("learnTypes", 9)) {
            this.learnTypes.clear();
            for (INBT base : nbt.func_150295_c("learnTypes", 8)) {
                StringNBT string = (StringNBT)base;
                try {
                    BaseStatsLearnType type = BaseStatsLearnType.valueOf(string.func_150285_a_());
                    this.learnTypes.add(type);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vector, Hand hand) {
        if (player instanceof ServerPlayerEntity && hand == Hand.MAIN_HAND) {
            if (this.moveList.isEmpty()) {
                this.init("");
            }
            ItemStack itemStack = player.func_184586_b(hand);
            NetworkHelper.sendPacket(new LoadTutorDataPacket(this.moveList), (ServerPlayerEntity)player);
            if (player.func_184812_l_() && itemStack.func_77973_b() instanceof NPCEditorItem) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                NetworkHelper.sendPacket(new LoadTutorDataPacket(this.moveList, this.learnTypes), (ServerPlayerEntity)player);
                OpenScreenPacket.open(player, EnumGuiScreen.TutorEditor, this.func_145782_y());
            } else {
                OpenScreenPacket.open(player, EnumGuiScreen.PickPokemon, this.getTutorType() == EnumNPCTutorType.TUTOR ? SelectPokemonResponsePacket.Mode.Tutor.ordinal() : SelectPokemonResponsePacket.Mode.Transfer_Tutor.ordinal(), this.func_145782_y());
            }
        } else {
            this.field_70714_bg.field_220892_d.clear();
        }
        return super.func_184199_a(player, vector, hand);
    }

    public void handlePickedPokemon(ServerPlayerEntity player, Pokemon pokemon) {
        ArrayList learnableMoveList = Lists.newArrayList();
        for (LearnableMove learnableMove : this.moveList) {
            learnableMoveList.add(new LearnableMove(learnableMove, this.canLearn(player, pokemon, learnableMove.attack())));
        }
        NPCTutorEvent.CollectLearnableMoves.Pre pre = new NPCTutorEvent.CollectLearnableMoves.Pre((PlayerEntity)player, this, pokemon, learnableMoveList);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        NetworkHelper.sendPacket(new LoadTutorDataPacket(pre.getLearnableMoves()), player);
        OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.Tutor, pokemon.getPosition().order, this.func_145782_y());
        Pixelmon.EVENT_BUS.post((Event)new NPCTutorEvent.CollectLearnableMoves.Post((PlayerEntity)player, this, pokemon, pre.getLearnableMoves()));
    }

    public boolean canLearn(ServerPlayerEntity player, Pokemon pokemon, ImmutableAttack attack) {
        return pokemon.getForm().getMoves().canLearn(pokemon.getForm(), attack, this.learnTypes.toArray(new BaseStatsLearnType[0]));
    }

    private static Attack getRandomAttack(EnumNPCTutorType type) {
        return new Attack(CollectionHelper.getRandomElement(type == EnumNPCTutorType.TUTOR ? allTutorMoves : allTransferMoves));
    }

    private static ItemStack getRandomCost() {
        Item[] randomItems = new Item[]{Items.field_151042_j, Items.field_151043_k, Items.field_151045_i, Items.field_151166_bC, PixelmonItems.aluminium_ingot, PixelmonItems.amethyst, PixelmonItems.ruby, PixelmonItems.crystal, PixelmonItems.sapphire, PixelmonItems.silicon};
        int randomItem = RandomHelper.getRandomNumberBetween(0, randomItems.length - 1);
        return new ItemStack((IItemProvider)randomItems[randomItem], RandomHelper.getRandomNumberBetween(1, 16));
    }

    public static void encode(PacketBuffer buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        if (attackList != null) {
            buf.writeInt(attackList.size());
            for (int i = 0; i < attackList.size(); ++i) {
                buf.func_180714_a(attackList.get(i).getMove().getAttackName());
                buf.writeInt(costs.get(i).size());
                for (int j = 0; j < costs.get(i).size(); ++j) {
                    ItemStack current = costs.get(i).get(j);
                    buf.writeInt(Item.func_150891_b((Item)current.func_77973_b()));
                    buf.writeInt(current.func_190916_E());
                    buf.writeInt(current.func_77952_i());
                }
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void decode(PacketBuffer buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        int numAttacks = buf.readInt();
        for (int i = 0; i < numAttacks; ++i) {
            attackList.add(new Attack(buf.func_218666_n()));
            int numCosts = buf.readInt();
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack((IItemProvider)Item.func_150899_d((int)buf.readInt()), buf.readInt());
                current.func_196085_b(buf.readInt());
                cost.add(current);
            }
            costs.add(cost);
        }
    }

    private boolean isDefaultLearnList() {
        EnumSet<BaseStatsLearnType> defaults = EnumSet.noneOf(BaseStatsLearnType.class);
        if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
            defaults.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
            defaults.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
        } else {
            defaults.add(BaseStatsLearnType.TRANSFER_MOVES);
        }
        return this.learnTypes.containsAll(defaults);
    }

    public void randomiseMoveList() {
        this.moveList.clear();
        HashSet moveSet = Sets.newHashSet();
        ArrayList<ImmutableAttack> attackPool = this.getTutorType() == EnumNPCTutorType.TUTOR ? allTutorMoves : allTransferMoves;
        for (int i = 0; i < Math.min(PixelmonConfigProxy.getGeneral().getMovesPerTutor(), attackPool.size()); ++i) {
            ImmutableAttack random;
            while (!moveSet.add(random = CollectionHelper.getRandomElement(attackPool))) {
            }
        }
        for (ImmutableAttack base : moveSet) {
            this.moveList.add(new LearnableMove(base, Collections.singletonList(NPCTutor.getRandomCost()), true));
        }
    }

    public static class LearnableMove
    extends AbstractPixelmonPacket {
        private ImmutableAttack attack;
        private List<ItemStack> costs;
        private boolean learnable;

        public LearnableMove() {
            super(PacketDirection.PLAY_CLIENT, true);
        }

        public LearnableMove(ImmutableAttack attack, List<ItemStack> costs, boolean learnable) {
            this();
            this.attack = attack;
            this.costs = Lists.newArrayList();
            for (ItemStack cost : costs) {
                this.costs.add(cost.func_77946_l());
            }
            this.learnable = learnable;
        }

        public LearnableMove(LearnableMove source, boolean learnable) {
            this();
            this.attack = source.attack;
            this.costs = Lists.newArrayList();
            for (ItemStack cost : source.costs) {
                this.costs.add(cost.func_77946_l());
            }
            this.learnable = learnable;
        }

        public ImmutableAttack attack() {
            return this.attack;
        }

        public List<ItemStack> costs() {
            return this.costs;
        }

        public boolean learnable() {
            return this.learnable;
        }

        @Override
        public void decode(PacketBuffer buf) {
            this.attack = AttackRegistry.getAttackBase(buf.func_218666_n()).orElse(null);
            int count = buf.readInt();
            this.costs = Lists.newArrayList();
            for (int i = 0; i < count; ++i) {
                this.costs.add(buf.func_150791_c());
            }
            this.learnable = buf.readBoolean();
        }

        @Override
        protected void handlePacket(NetworkEvent.Context context) {
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_180714_a(this.attack.getAttackName());
            buf.writeInt(this.costs.size());
            for (ItemStack stack : this.costs) {
                buf.func_150788_a(stack);
            }
            buf.writeBoolean(this.learnable);
        }

        public void readFromNBT(CompoundNBT compound) {
            this.attack = AttackRegistry.getAttackBase(compound.func_74779_i("move")).orElse(null);
            this.costs = Lists.newArrayList();
            ListNBT list = compound.func_150295_c("costs", 10);
            for (INBT base : list) {
                CompoundNBT cost = (CompoundNBT)base;
                this.costs.add(ItemStack.func_199557_a((CompoundNBT)cost));
            }
            this.learnable = compound.func_74767_n("learnable");
        }

        public CompoundNBT writeToNBT(CompoundNBT compound) {
            compound.func_74778_a("move", this.attack == null ? "" : this.attack.getAttackName());
            ListNBT list = new ListNBT();
            for (ItemStack cost : this.costs) {
                list.add((Object)cost.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("costs", (INBT)list);
            compound.func_74757_a("learnable", this.learnable);
            return compound;
        }
    }
}

