/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.ai.ExecuteActionGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsTargetGoal;
import com.pixelmonmod.pixelmon.ai.TargetNearestGoal;
import com.pixelmonmod.pixelmon.ai.TrainerInBattleGoal;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ITrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import com.pixelmonmod.pixelmon.tools.Quadstate;
import com.pixelmonmod.pixelmon.world.generation.gyms.MovesetDefinition;
import com.pixelmonmod.pixelmon.world.generation.gyms.PokemonDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.ArrayUtils;

public class NPCTrainer
extends NPCEntity {
    private static final DataSync<NPCTrainer, EnumEncounterMode> SYNC_ENCOUNTER_MODE = new DataSync<NPCTrainer, EnumEncounterMode>(NPCTrainer.class, PixelmonDataSerializers.ENCOUNTER_MODE, (npcTrainer, o) -> {
        npcTrainer.encounterMode = o;
    });
    private static final DataSync<NPCTrainer, EnumMegaItemsUnlocked> SYNC_MEGA_ITEM = new DataSync<NPCTrainer, EnumMegaItemsUnlocked>(NPCTrainer.class, PixelmonDataSerializers.MEGA_ITEM, (npcTrainer, enumMegaItemsUnlocked) -> {
        npcTrainer.megaItem = enumMegaItemsUnlocked;
    });
    private static final DataSync<NPCTrainer, EnumOldGenMode> SYNC_OLD_GEN = new DataSync<NPCTrainer, EnumOldGenMode>(NPCTrainer.class, PixelmonDataSerializers.OLD_GEN_MODE, (npcTrainer, enumOldGenMode) -> {
        npcTrainer.oldGenMode = enumOldGenMode;
    });
    private static final DataSync<NPCTrainer, BossTier> SYNC_BOSS_MODE = new DataSync<NPCTrainer, BossTier>(NPCTrainer.class, PixelmonDataSerializers.BOSS_MODE, (npcTrainer, bossTier) -> {
        npcTrainer.bossTier = bossTier;
    });
    private static final DataSync<NPCTrainer, Integer> SYNC_TRAINER_LEVEL = new DataSync<NPCTrainer, Integer>(NPCTrainer.class, DataSerializers.field_187192_b, (npcTrainer, integer) -> {
        npcTrainer.trainerLevel = integer;
    });
    private static final DataSync<NPCTrainer, BattleAIMode> SYNC_BATTLE_AI = new DataSync<NPCTrainer, BattleAIMode>(NPCTrainer.class, PixelmonDataSerializers.BATTLE_AI_MODE, (npcTrainer, battleAIMode) -> {
        npcTrainer.battleAIMode = battleAIMode;
    });
    private static final DataSync<NPCTrainer, Integer> SYNC_ENGAGE_DISTANCE = new DataSync<NPCTrainer, Integer>(NPCTrainer.class, DataSerializers.field_187192_b, (npcTrainer, integer) -> {
        npcTrainer.engageDistance = integer;
    });
    private TrainerPartyStorage party = new TrainerPartyStorage(this);
    public boolean usingDefaultName = true;
    public boolean usingDefaultGreeting = true;
    public boolean usingDefaultWin = true;
    public boolean usingDefaultLose = true;
    public String greeting = "";
    public String winMessage = "";
    public String loseMessage = "";
    public int winMoney;
    public int pokemonLevel;
    private String trainerId = "";
    ItemStack[] winnings = new ItemStack[0];
    private boolean startRotationSet = false;
    private float startRotationYaw;
    public boolean isGymLeader = false;
    public transient boolean canEngage = true;
    public HashMap<UUID, Long> playerEncounters = new HashMap();
    public ArrayList<String> winCommands = new ArrayList();
    public ArrayList<String> loseCommands = new ArrayList();
    public ArrayList<String> forfeitCommands = new ArrayList();
    public ArrayList<String> preBattleCommands = new ArrayList();
    public BattleRules battleRules = new BattleRules();
    private EnumEncounterMode encounterMode;
    private EnumMegaItemsUnlocked megaItem;
    private EnumOldGenMode oldGenMode;
    private BossTier bossTier;
    private BattleAIMode battleAIMode;
    private int trainerLevel;
    private int engageDistance;
    public BattleController battleController;

    public NPCTrainer(EntityType<NPCTrainer> type, World par1World) {
        super(type, par1World);
    }

    public NPCTrainer(World world) {
        this((EntityType<NPCTrainer>)((EntityType)EntityRegistration.NPC_TRAINER.get()), world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.define(SYNC_ENCOUNTER_MODE, EnumEncounterMode.Once);
        this.define(SYNC_BOSS_MODE, BossTierRegistry.NOT_BOSS);
        this.define(SYNC_TRAINER_LEVEL, 0);
        this.define(SYNC_BATTLE_AI, BattleAIMode.DEFAULT);
        this.define(SYNC_MEGA_ITEM, EnumMegaItemsUnlocked.None);
        this.define(SYNC_OLD_GEN, EnumOldGenMode.World);
        this.define(SYNC_ENGAGE_DISTANCE, 10);
    }

    public void init(BaseTrainer trainer) {
        super.init(trainer.name);
        this.party = new TrainerPartyStorage(this);
        TrainerData info = ServerNPCRegistry.trainers.getRandomData(trainer);
        if (info == null) {
            BaseTrainer b = ServerNPCRegistry.trainers.getRandomBaseWithData();
            info = ServerNPCRegistry.trainers.getRandomData(b.name);
        }
        this.chatIndex = info.getRandomChat();
        if (this.usingDefaultName) {
            this.setName("" + info.getRandomName());
        }
        this.trainerId = info.id;
        this.winMoney = info.winnings;
        this.pokemonLevel = info.getRandomLevel();
        if (this.pokemonLevel == 0) {
            this.pokemonLevel = 1;
        }
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)this.pokemonLevel);
        this.setBaseTrainer(info.trainerType);
        if (info.trainerType.textures.size() > 1) {
            this.setTextureIndex(this.field_70170_p.field_73012_v.nextInt(info.trainerType.textures.size()));
        }
        this.loadPokemon(info.getRandomParty());
    }

    public String getName(String langCode) {
        if (this.usingDefaultName) {
            try {
                int index = Integer.parseInt(this.func_200200_C_().getString());
                ITrainerData translatedData = this.getTranslatedData(langCode);
                if (translatedData == null) {
                    return this.func_200200_C_().getString();
                }
                return translatedData.getName(index);
            }
            catch (NumberFormatException e) {
                return this.func_200200_C_().getString();
            }
        }
        return this.func_200200_C_().getString();
    }

    public void clearGreetings() {
        this.usingDefaultGreeting = false;
        this.usingDefaultWin = false;
        this.usingDefaultLose = false;
        this.greeting = null;
        this.winMessage = null;
        this.loseMessage = null;
    }

    public String getGreeting(String langCode) {
        if (this.usingDefaultGreeting) {
            return this.getChat((String)langCode).opening;
        }
        return this.greeting;
    }

    public String getWinMessage(String langCode) {
        if (this.usingDefaultWin) {
            return this.getChat((String)langCode).win;
        }
        return this.winMessage;
    }

    public String getLoseMessage(String langCode) {
        if (this.usingDefaultLose) {
            return this.getChat((String)langCode).lose;
        }
        return this.loseMessage;
    }

    private ITrainerData getTranslatedData(String langCode) {
        return ServerNPCRegistry.getTranslatedData(langCode, this.getBaseTrainer(), this.trainerId);
    }

    public TrainerChat getChat(String langCode) {
        ITrainerData data = this.getTranslatedData(langCode);
        if (data == null) {
            return new TrainerChat("", "", "");
        }
        return data.getChat(this.chatIndex);
    }

    public int getWinMoney() {
        return this.winMoney;
    }

    public void setEncounterMode(EnumEncounterMode mode) {
        SYNC_ENCOUNTER_MODE.set((Entity)this, (Object)mode);
        this.playerEncounters.clear();
    }

    public void setMegaItem(EnumMegaItemsUnlocked megaItem) {
        SYNC_MEGA_ITEM.set((Entity)this, (Object)megaItem);
    }

    public void setOldGenMode(EnumOldGenMode mode) {
        SYNC_OLD_GEN.set((Entity)this, (Object)mode);
    }

    public EnumEncounterMode getEncounterMode() {
        return this.encounterMode;
    }

    public EnumMegaItemsUnlocked getMegaItem() {
        return this.megaItem;
    }

    public EnumOldGenMode getOldGen() {
        return this.oldGenMode;
    }

    public void setEngageDistance(int engageDistance) {
        SYNC_ENGAGE_DISTANCE.set((Entity)this, (Object)engageDistance);
    }

    public int getEngageDistance() {
        return this.engageDistance;
    }

    public void setTrainerType(BaseTrainer model, PlayerEntity player) {
        this.init(model);
        this.setTextureIndex(0);
        this.setBaseTrainer(model);
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        NetworkHelper.sendPacket(new ClearTrainerPokemonPacket(), playerMP);
        for (Pokemon pokemon : this.party.getTeam()) {
            NetworkHelper.sendPacket(new StoreTrainerPokemonPacket(pokemon), playerMP);
        }
        String loc = playerMP.getLanguage();
        this.setName(ServerNPCRegistry.trainers.getTranslatedRandomName(loc, model, this.trainerId));
        SetTrainerData p = new SetTrainerData(this, loc);
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(p), playerMP);
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        EnumTrainerAI ai = this.getAIMode();
        return ai != EnumTrainerAI.StandStill && ai != EnumTrainerAI.StillAndEngage;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.startRotationSet && this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            this.field_70177_z = this.startRotationYaw;
            this.field_70759_as = this.startRotationYaw;
        }
    }

    @Override
    protected void checkForRarityDespawn() {
        if (this.battleController != null) {
            return;
        }
        super.checkForRarityDespawn();
    }

    public PixelmonEntity releasePokemon(UUID newPokemonUUID) {
        return this.party.find(newPokemonUUID).getOrSpawnPixelmon((Entity)this);
    }

    public void loadPokemon(ArrayList<Pokemon> pokemonList) {
        for (int i = 0; i < 6; ++i) {
            this.party.set(i, null);
        }
        if (pokemonList == null || pokemonList.isEmpty()) {
            this.party.add(PokemonSpecificationProxy.create(PixelmonSpecies.STARLY.getValueUnsafe().getName(), "lvl:5").create());
        } else {
            for (Pokemon pokemon : pokemonList) {
                pokemon.setLevel(Math.max(1, RandomHelper.getRandomNumberBetween(this.pokemonLevel - 1, this.pokemonLevel + 1)));
                this.party.add(pokemon);
            }
        }
    }

    private void initializePokemon(PokemonDefinition definition, int level, boolean isDouble) {
        BaseShopItem item;
        MovesetDefinition moves = RandomHelper.getRandomElementFromList(definition.getMovesets());
        if (level < moves.minLevel || level < definition.getMinLevel() || level > definition.getMaxLevel()) {
            return;
        }
        if (moves.doubleOnly && !isDouble) {
            return;
        }
        Pokemon pokemon = PokemonFactory.create(PokemonSpecificationProxy.create(definition.getPokemon().getName(), "form:" + moves.form, "lvl:" + Math.max(1, Math.min(PixelmonServerConfig.maxLevel, RandomHelper.getRandomNumberBetween(level - 1, level + 1)))));
        if (this.isGymLeader) {
            pokemon.getEVs().setStat(BattleStatsType.ATTACK, moves.evAtk);
            pokemon.getEVs().setStat(BattleStatsType.DEFENSE, moves.evDef);
            pokemon.getEVs().setStat(BattleStatsType.HP, moves.evHP);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_ATTACK, moves.evSpAtk);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_DEFENSE, moves.evSpDef);
            pokemon.getEVs().setStat(BattleStatsType.SPEED, moves.evSpeed);
            pokemon.getEVs().setStat(BattleStatsType.ATTACK, moves.ivAtk);
            pokemon.getEVs().setStat(BattleStatsType.DEFENSE, moves.ivDef);
            pokemon.getEVs().setStat(BattleStatsType.HP, moves.ivHP);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_ATTACK, moves.ivSpAtk);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_DEFENSE, moves.ivSpDef);
            pokemon.getEVs().setStat(BattleStatsType.SPEED, moves.ivSpeed);
            if (moves.nature != null && moves.nature.length > 0) {
                pokemon.setNature(RandomHelper.getRandomElementFromArray(moves.nature));
            }
        }
        pokemon.setHealth(pokemon.getMaxHealth());
        if (moves.ability != null && moves.ability.length > 0) {
            pokemon.setAbility(RandomHelper.getRandomElementFromArray(moves.ability));
        } else {
            ArrayList<Ability> randomAbilities = new ArrayList<Ability>();
            for (Ability ability : pokemon.getForm().getAbilities().getAll()) {
                if (ability == null) continue;
                randomAbilities.add(ability);
            }
            if (!randomAbilities.isEmpty()) {
                pokemon.setAbility((Ability)RandomHelper.getRandomElementFromList(randomAbilities));
            }
        }
        if (moves.heldItem != null && moves.heldItem.length > 0 && (item = ServerNPCRegistry.shopkeepers.getItem(RandomHelper.getRandomElementFromArray(moves.heldItem))) != null) {
            item.getItem().func_190920_e(1);
            pokemon.setHeldItem(item.getItem().func_77946_l());
        }
        pokemon.setFriendship(255);
        Moveset moveset = pokemon.getMoveset();
        moveset.clear();
        this.addGymTrainerMove(moves.move1, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move2, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move3, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move4, pokemon, moves.ivsDefined);
        this.party.add(pokemon);
        int pos = ((StoragePosition)this.party.find((UUID)pokemon.getUUID()).getStorageAndPosition().func_76340_b()).order;
        if (moves.lead && pos != 0) {
            this.party.swap(pos, 0);
        }
        this.calculateGen();
    }

    private void addGymTrainerMove(String[] possibleMoves, Pokemon pokemon, boolean ivsDefined) {
        if (possibleMoves != null && possibleMoves.length > 0) {
            Attack attack;
            Moveset moveset = pokemon.getMoveset();
            int randomIndex = this.field_70170_p.field_73012_v.nextInt(possibleMoves.length);
            String selectedMove = possibleMoves[randomIndex];
            Element hiddenPowerType = null;
            if (selectedMove.contains("Hidden Power")) {
                if (!ivsDefined) {
                    hiddenPowerType = Element.parseType(selectedMove.replace("Hidden Power ", ""));
                }
                selectedMove = "Hidden Power";
            }
            if ((attack = new Attack(selectedMove)) != null && !moveset.contains(attack)) {
                moveset.add(attack);
                if (hiddenPowerType != null) {
                    pokemon.getIVs().copyIVs(HiddenPower.getOptimalIVs(hiddenPowerType));
                }
            } else {
                String[] reducedPossible = (String[])ArrayUtils.remove((Object[])possibleMoves, (int)randomIndex);
                this.addGymTrainerMove(reducedPossible, pokemon, ivsDefined);
            }
        }
    }

    public void startBattle(BattleParticipant battleParticipant) {
        this.calculateGen();
        if (battleParticipant instanceof PlayerParticipant) {
            PlayerParticipant player = (PlayerParticipant)battleParticipant;
            EnumEncounterMode encounterMode = this.getEncounterMode();
            if (encounterMode == EnumEncounterMode.OncePerMCDay) {
                this.playerEncounters.put(player.player.func_110124_au(), this.field_70170_p.func_82737_E());
            } else if (encounterMode == EnumEncounterMode.OncePerDay) {
                this.playerEncounters.put(player.player.func_110124_au(), System.currentTimeMillis());
            }
        }
        this.healAllPokemon();
    }

    public Quadstate calculateGen() {
        return this.party.isOldGen((RegistryKey<World>)this.field_70170_p.func_234923_W_());
    }

    public void loseBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getLoseMessage(langCode = ((ServerPlayerEntity)opponents.get(0).getEntity()).getLanguage()) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getLoseMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            ServerPlayerEntity player = (ServerPlayerEntity)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new BeatTrainerEvent(player, this));
            if (this.getEncounterMode() == EnumEncounterMode.Once) {
                this.func_70106_y();
                this.func_241204_bJ_();
            } else {
                this.healAllPokemon();
                if (this.getEncounterMode() == EnumEncounterMode.OncePerPlayer) {
                    this.playerEncounters.put(player.func_110124_au(), this.field_70170_p.func_82737_E());
                }
            }
            if (player.field_70170_p.func_217371_b(player.func_110124_au()) == null) {
                return;
            }
            if (this.winMoney > 0) {
                int calculatedWinMoney = this.winMoney * this.party.getAverageLevel();
                if (!this.func_213397_c(0.0)) {
                    calculatedWinMoney = this.winMoney;
                }
                PlayerParticipant playerParticipant = (PlayerParticipant)opponents.get(0);
                calculatedWinMoney *= playerParticipant.getPrizeMoneyMultiplier();
                BankAccount account = BankAccountProxy.getBankAccount(playerParticipant.player).orElse(null);
                if (account != null) {
                    account.add(calculatedWinMoney);
                    if (playerParticipant.bc == null) {
                        ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.GREEN, "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.getLanguage()));
                    } else {
                        ChatHandler.sendBattleMessage((Entity)playerParticipant.getEntity(), "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.getLanguage()));
                    }
                }
            }
            if (this.winnings.length > 0) {
                ArrayList<DroppedItem> drops = new ArrayList<DroppedItem>();
                int id = 0;
                for (ItemStack item : this.winnings) {
                    if (item.func_190916_E() == 0) {
                        item.func_190920_e(1);
                    }
                    drops.add(new DroppedItem(item.func_77946_l(), id++));
                }
                DropItemQueryList.register(this, drops, player);
            }
            if (this.getBaseTrainer() != null && this.getBaseTrainer().name.equals("Fisherman")) {
                int number = RandomHelper.getRandomNumberBetween(1, 100);
                int number2 = RandomHelper.getRandomNumberBetween(1, 1000);
                if (number == 43) {
                    DropItemHelper.giveItemStack(player, new ItemStack((IItemProvider)PixelmonItems.good_rod), false);
                    ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.GREEN, "pixelmon.entitytrainer.goodrod", new Object[0]);
                } else if (number2 == 564) {
                    DropItemHelper.giveItemStack(player, new ItemStack((IItemProvider)PixelmonItems.super_rod), false);
                    ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.GREEN, "pixelmon.entitytrainer.superrod", new Object[0]);
                }
            }
        }
    }

    public void winBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getWinMessage(langCode = ((ServerPlayerEntity)opponents.get(0).getEntity()).getLanguage()) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getWinMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            ServerPlayerEntity player = (ServerPlayerEntity)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new LostToTrainerEvent(player, this));
        }
    }

    public void healAllPokemon() {
        this.party.getTeam().forEach(Pokemon::heal);
    }

    public void restoreAllFriendship() {
        this.party.getTeam().forEach(pokemon -> pokemon.setFriendship(255));
    }

    public UUID getNextPokemonUUID() {
        Pokemon pokemon = this.party.findOne(p -> !p.isEgg() && !p.getPixelmonEntity().isPresent());
        return pokemon == null ? null : pokemon.getUUID();
    }

    public int getTrainerLevel() {
        return this.trainerLevel;
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.Trainer, player));
        return false;
    }

    public ActionResultType func_233661_c_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof NPCEditorItem) {
                ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
                if (!NPCEditorItem.checkPermission((PlayerEntity)playerMP)) {
                    return ActionResultType.FAIL;
                }
                this.func_110163_bv();
                this.field_70714_bg.field_220892_d.clear();
                this.party.sendCacheToPlayer(playerMP);
                String loc = playerMP.getLanguage();
                SetTrainerData p = new SetTrainerData(this, loc);
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(p), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.TrainerEditor, this.getNPCID());
            }
        } else {
            this.field_70714_bg.field_220892_d.clear();
        }
        return super.func_233661_c_(player, hand);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        CompoundNBT pokemonNbt = new CompoundNBT();
        this.party.writeToNBT(pokemonNbt);
        nbt.func_218657_a("pokeStore", (INBT)pokemonNbt);
        nbt.func_74778_a("BossTier", this.getBossTier().getID());
        if (this.greeting != null) {
            nbt.func_74778_a("Greeting", this.greeting);
        }
        if (this.winMessage != null) {
            nbt.func_74778_a("WinMessage", this.winMessage);
        }
        if (this.loseMessage != null) {
            nbt.func_74778_a("LoseMessage", this.loseMessage);
        }
        CompoundNBT tmpWinnings = new CompoundNBT();
        for (int i = 0; i < this.winnings.length; ++i) {
            CompoundNBT itemTag = new CompoundNBT();
            if (this.winnings[i] == null) continue;
            this.winnings[i].func_77955_b(itemTag);
            tmpWinnings.func_218657_a("item" + i, (INBT)itemTag);
        }
        nbt.func_74768_a("NPCLevel", this.pokemonLevel);
        nbt.func_74768_a("WinMoney", this.winMoney);
        nbt.func_218657_a("WinningsTag", (INBT)tmpWinnings);
        EnumEncounterMode mode = this.getEncounterMode();
        nbt.func_74777_a("EncMode", (short)mode.ordinal());
        nbt.func_74768_a("EngageDistance", this.getEngageDistance());
        if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited) {
            ListNBT list = new ListNBT();
            for (Map.Entry<UUID, Long> entry : this.playerEncounters.entrySet()) {
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_186854_a("UUID", entry.getKey());
                if (mode != EnumEncounterMode.OncePerPlayer) {
                    compoundNBT.func_74772_a("time", entry.getValue().longValue());
                }
                list.add((Object)compoundNBT);
            }
            nbt.func_218657_a("Encounters", (INBT)list);
        }
        nbt.func_74777_a("BattleAIMode", (short)this.getBattleAIMode().ordinal());
        nbt.func_74757_a("DefaultName", this.usingDefaultName);
        nbt.func_74757_a("DefaultWin", this.usingDefaultWin);
        nbt.func_74757_a("DefaultLose", this.usingDefaultLose);
        nbt.func_74757_a("DefaultGreet", this.usingDefaultGreeting);
        nbt.func_74778_a("TrainerIndex", this.trainerId);
        nbt.func_74768_a("ChatIndex", this.chatIndex);
        nbt.func_74768_a("hasMegaItem", this.getMegaItem().ordinal());
        if (this.getOldGen() != null) {
            nbt.func_74768_a("oldGen", this.getOldGen().ordinal());
        }
        if (this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            nbt.func_74776_a("TrainerRotation", this.startRotationYaw);
        }
        if (nbt.func_74764_b("EngageDistance")) {
            this.setEngageDistance(nbt.func_74762_e("EngageDistance"));
        }
        nbt.func_74757_a("GymLeader", this.isGymLeader);
        this.battleRules.writeToNBT(nbt);
        CompoundNBT commandsNbt = nbt.func_74775_l("Commands");
        ListNBT winList = new ListNBT();
        for (String string : this.winCommands) {
            winList.add((Object)StringNBT.func_229705_a_((String)string));
        }
        commandsNbt.func_218657_a("winCommands", (INBT)winList);
        ListNBT listNBT = new ListNBT();
        for (String string : this.loseCommands) {
            listNBT.add((Object)StringNBT.func_229705_a_((String)string));
        }
        commandsNbt.func_218657_a("loseCommands", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (String forfeitCommand : this.forfeitCommands) {
            listNBT2.add((Object)StringNBT.func_229705_a_((String)forfeitCommand));
        }
        commandsNbt.func_218657_a("forfeitCommands", (INBT)listNBT2);
        ListNBT listNBT3 = new ListNBT();
        for (String preBattleCommand : this.preBattleCommands) {
            listNBT3.add((Object)StringNBT.func_229705_a_((String)preBattleCommand));
        }
        commandsNbt.func_218657_a("preBattleCommands", (INBT)listNBT3);
        nbt.func_218657_a("Commands", (INBT)commandsNbt);
    }

    public boolean canStartBattle(PlayerEntity opponent, boolean printMessages) {
        if (opponent == null) {
            return true;
        }
        if (!this.canEngage) {
            return false;
        }
        if (this.battleController != null) {
            if (printMessages) {
                ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.inbattle", new Object[0]);
            }
            return false;
        }
        Long lastEncounter = this.playerEncounters.get(opponent.func_110124_au());
        if (lastEncounter != null) {
            EnumEncounterMode mode = this.getEncounterMode();
            if (mode == EnumEncounterMode.OncePerDay) {
                long oldTime;
                long oldDay;
                long curTime = System.currentTimeMillis();
                long curDay = curTime / 86400000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 86400000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerMCDay) {
                long oldTime;
                long oldDay;
                long curTime = this.field_70170_p.func_82737_E();
                long curDay = curTime / 24000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 24000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.oncemcday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerPlayer) {
                if (printMessages) {
                    ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceplayer", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("DefaultName")) {
            this.usingDefaultName = nbt.func_74767_n("DefaultName");
            this.usingDefaultWin = nbt.func_74767_n("DefaultWin");
            this.usingDefaultLose = nbt.func_74767_n("DefaultLose");
            this.usingDefaultGreeting = nbt.func_74767_n("DefaultGreet");
            this.trainerId = nbt.func_74779_i("TrainerIndex");
            this.chatIndex = nbt.func_74762_e("ChatIndex");
        }
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("BossTier")) {
            this.setBossTier(BossTierRegistry.getBossTierOrNotBoss(nbt.func_74779_i("BossTier")));
        }
        this.party.readFromNBT(nbt.func_74775_l("pokeStore"));
        if (nbt.func_74764_b("Greeting")) {
            this.greeting = nbt.func_74779_i("Greeting");
            this.winMessage = nbt.func_74779_i("WinMessage");
            this.loseMessage = nbt.func_74779_i("LoseMessage");
        }
        if (nbt.func_74764_b("hasMegaItem")) {
            this.setMegaItem(EnumMegaItemsUnlocked.values()[nbt.func_74762_e("hasMegaItem")]);
        }
        if (nbt.func_74764_b("oldGen")) {
            this.setOldGenMode(EnumOldGenMode.values()[nbt.func_74762_e("oldGen")]);
        }
        if (nbt.func_74764_b("WinningsTag")) {
            CompoundNBT tag = nbt.func_74775_l("WinningsTag");
            this.winnings = new ItemStack[tag.func_150296_c().size()];
            int index = 0;
            for (String key : tag.func_150296_c()) {
                this.winnings[index++] = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(key));
            }
        } else if (nbt.func_74764_b("Winnings")) {
            int[] testArray = nbt.func_74759_k("Winnings");
            ArrayList<Item> array = new ArrayList<Item>();
            for (int aTestArray : testArray) {
                array.add(Item.func_150899_d((int)aTestArray));
            }
            this.winnings = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.winnings[i] = new ItemStack((IItemProvider)array.get(i));
            }
        }
        if (nbt.func_74764_b("TrainerRotation")) {
            this.setStartRotationYaw(nbt.func_74760_g("TrainerRotation"));
        }
        if (nbt.func_74764_b("EncMode")) {
            EnumEncounterMode mode = EnumEncounterMode.getFromIndex(nbt.func_74765_d("EncMode"));
            this.setEncounterMode(mode);
            this.playerEncounters.clear();
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.func_74764_b("numEncounters")) {
                int numEncounters = nbt.func_74762_e("numEncounters");
                for (int i = 0; i < numEncounters; ++i) {
                    String uuid = nbt.func_74779_i("encPl" + i);
                    long time = 0L;
                    if (mode != EnumEncounterMode.OncePerPlayer) {
                        long oldDay;
                        long curDay;
                        time = nbt.func_74763_f("encTi" + i);
                        if (mode == EnumEncounterMode.OncePerDay) {
                            curDay = System.currentTimeMillis() / 86400000L;
                            if (curDay > (oldDay = time / 86400000L)) continue;
                            this.playerEncounters.put(UUID.fromString(uuid), time);
                            continue;
                        }
                        if (mode != EnumEncounterMode.OncePerMCDay || (curDay = this.field_70170_p.func_82737_E() / 24000L) > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(UUID.fromString(uuid), time);
                        continue;
                    }
                    this.playerEncounters.put(UUID.fromString(uuid), 0L);
                }
            }
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.func_74764_b("Encounters")) {
                ListNBT list = nbt.func_150295_c("Encounters", 10);
                for (int i = 0; i < list.size(); ++i) {
                    long oldDay;
                    long curDay;
                    long time;
                    CompoundNBT compound = list.func_150305_b(i);
                    UUID uuid = compound.func_186857_a("UUID");
                    long l = time = mode != EnumEncounterMode.OncePerPlayer ? compound.func_74763_f("time") : 0L;
                    if (mode == EnumEncounterMode.OncePerDay) {
                        curDay = System.currentTimeMillis() / 86400000L;
                        if (curDay > (oldDay = time / 86400000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    if (mode == EnumEncounterMode.OncePerMCDay) {
                        curDay = this.field_70170_p.func_82737_E() / 24000L;
                        if (curDay > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    this.playerEncounters.put(uuid, 0L);
                }
            }
        } else {
            this.setEncounterMode(EnumEncounterMode.Once);
        }
        if (nbt.func_74764_b("BattleAIMode")) {
            this.setBattleAIMode(BattleAIMode.getFromIndex(nbt.func_74765_d("BattleAIMode")));
        }
        if (nbt.func_74764_b("NPCLevel")) {
            this.pokemonLevel = nbt.func_74762_e("NPCLevel");
            SYNC_TRAINER_LEVEL.set((Entity)this, (Object)this.pokemonLevel);
            this.updateTrainerLevel();
        }
        if (nbt.func_74764_b("Commands")) {
            CompoundNBT cmdNbt = nbt.func_74775_l("Commands");
            if (cmdNbt.func_74764_b("winCommands")) {
                ListNBT wins = cmdNbt.func_150295_c("winCommands", 8);
                for (int i = 0; i < wins.size(); ++i) {
                    this.winCommands.add(wins.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("loseCommands")) {
                ListNBT loss = cmdNbt.func_150295_c("loseCommands", 8);
                for (int i = 0; i < loss.size(); ++i) {
                    this.loseCommands.add(loss.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("forfeitCommands")) {
                ListNBT forfeit = cmdNbt.func_150295_c("forfeitCommands", 8);
                for (int i = 0; i < forfeit.size(); ++i) {
                    this.forfeitCommands.add(forfeit.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("preBattleCommands")) {
                ListNBT preBattle = cmdNbt.func_150295_c("preBattleCommands", 8);
                for (int i = 0; i < preBattle.size(); ++i) {
                    this.preBattleCommands.add(preBattle.func_150307_f(i));
                }
            }
        }
        if (nbt.func_74764_b("WinMoney")) {
            this.winMoney = nbt.func_74762_e("WinMoney");
        }
        if (nbt.func_74764_b("GymLeader")) {
            this.isGymLeader = nbt.func_74767_n("GymLeader");
        }
        this.battleRules.readFromNBT(nbt);
        if (nbt.func_74764_b("BattleType")) {
            this.battleRules.set(BattleRuleRegistry.BATTLE_TYPE, (Object)BattleType.values()[nbt.func_74765_d("BattleType")]);
            nbt.func_82580_o("BattleType");
        }
        this.updateTrainerLevel();
    }

    public void randomisePokemon(PlayerEntity player) {
        ArrayList<Pokemon> randomParty;
        BaseTrainer base = this.getBaseTrainer();
        if (base.name.equals("Steve")) {
            int partySize = RandomHelper.getRandomNumberBetween(1, 6);
            randomParty = new ArrayList(partySize);
            for (int i = 0; i < partySize; ++i) {
                randomParty.add(PokemonSpecificationProxy.create(PixelmonSpecies.getRandomSpecies().getName()).create());
            }
            this.pokemonLevel = RandomHelper.getRandomNumberBetween(2, 99);
        } else {
            TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
            if (data == null) {
                Pixelmon.LOGGER.error(base.name + " has no trainer data set.");
                return;
            }
            randomParty = data.getRandomParty();
        }
        this.loadPokemon(randomParty);
        this.updateTrainerLevel();
        NetworkHelper.sendPacket(new ClearTrainerPokemonPacket(), (ServerPlayerEntity)player);
        for (Pokemon pokemon : this.party.getTeam()) {
            NetworkHelper.sendPacket(new StoreTrainerPokemonPacket(pokemon), (ServerPlayerEntity)player);
        }
    }

    @Override
    public BossTier getBossTier() {
        if (this.bossTier == null) {
            return BossTierRegistry.NOT_BOSS;
        }
        return this.bossTier;
    }

    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        SYNC_BOSS_MODE.set((Entity)this, (Object)tier);
    }

    public BattleAIMode getBattleAIMode() {
        return this.battleAIMode;
    }

    public void setBattleAIMode(BattleAIMode mode) {
        if (mode != null) {
            SYNC_BATTLE_AI.set((Entity)this, (Object)mode);
        }
    }

    public BattleType getBattleType() {
        return this.battleRules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE);
    }

    public void updateTrainerLevel() {
        int lvlTotal = 0;
        int count = 0;
        for (Pokemon pokemon : this.party.getTeam()) {
            lvlTotal += pokemon.getPokemonLevel();
            ++count;
        }
        if (count < 1) {
            count = 1;
        }
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)(lvlTotal / count));
    }

    @Override
    public void initDefaultAI() {
        this.func_70661_as().func_212239_d(true);
    }

    @Override
    public void initAI() {
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.field_220892_d.clear();
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new TrainerInBattleGoal(this));
                this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
                this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new TrainerInBattleGoal(this));
                this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, Attributes.field_233821_d_.func_111110_b()));
                break;
            }
            case StillAndEngage: {
                this.field_70714_bg.field_220892_d.clear();
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new TrainerInBattleGoal(this));
                this.field_70714_bg.func_75776_a(2, (Goal)new ExecuteActionGoal(this));
                this.field_70714_bg.func_75776_a(3, (Goal)new TargetNearestGoal(this, (float)this.getEngageDistance(), true));
                this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsTargetGoal((MobEntity)this, 1.01));
                break;
            }
            case WanderAndEngage: {
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new TrainerInBattleGoal(this));
                this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, this.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
                this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PixelmonEntity.class, 6.0f));
                this.field_70714_bg.func_75776_a(5, (Goal)new ExecuteActionGoal(this));
                this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsTargetGoal((MobEntity)this, 1.01));
                this.field_70714_bg.func_75776_a(7, (Goal)new TargetNearestGoal(this, (float)this.getEngageDistance(), true));
            }
        }
    }

    public void update(SetTrainerData p) {
        if (!p.greeting.equals("")) {
            this.greeting = p.greeting;
            this.usingDefaultGreeting = false;
        }
        if (!p.lose.equals("")) {
            this.loseMessage = p.lose;
            this.usingDefaultLose = false;
        }
        if (!p.win.equals("")) {
            this.winMessage = p.win;
            this.usingDefaultWin = false;
        }
        this.winMoney = p.winMoney;
        if (p.rules != null) {
            this.battleRules = p.rules;
        }
        if (p.name != null && !p.name.isEmpty()) {
            this.setName(p.name);
        }
    }

    public void setStartRotationYaw(float f) {
        this.startRotationSet = true;
        this.startRotationYaw = f;
        this.field_70177_z = f;
        this.field_70759_as = f;
    }

    @Override
    public String getDisplayText() {
        String s = "boss";
        if (this.getBossTier() != null && this.getBossTier().isNotBoss()) {
            s = "" + this.getTrainerLevel();
        }
        return s;
    }

    @Override
    public String getSubTitleText() {
        return I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]);
    }

    public void setBattleController(BattleController battleController) {
        this.battleController = battleController;
    }

    public BattleController getBattleController() {
        return this.battleController;
    }

    public TrainerPartyStorage getPokemonStorage() {
        return this.party;
    }

    public MobEntity getEntity() {
        return this;
    }

    public void setAttackTargetPix(LivingEntity entity) {
        this.func_70624_b(entity);
    }

    public void updateDrops(ItemStack[] drops) {
        this.winnings = drops;
    }

    public ItemStack[] getWinnings() {
        return this.winnings;
    }

    public void setPokemonLevel(int pokemonLevel) {
        this.pokemonLevel = pokemonLevel;
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)pokemonLevel);
        BaseTrainer base = this.getBaseTrainer();
        TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
        this.loadPokemon(data.getRandomParty());
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

