/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.PossibleTradeList;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class NPCTrader
extends NPCEntity {
    public TradePair tradePair = null;

    public NPCTrader(EntityType<NPCTrader> type, World par1World) {
        super(type, par1World);
        this.setName(new TranslationTextComponent("pixelmon.npc.tradername").getString());
        this.init("Youngster");
    }

    public NPCTrader(World world) {
        this((EntityType<NPCTrader>)((EntityType)EntityRegistration.NPC_TRADER.get()), world);
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    @Override
    public void init(String name) {
        super.init(name);
        if (this.trainer == null) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                SYNC_TEXTURE_INDEX.set((Entity)this, (Object)this.field_70170_p.field_73012_v.nextInt(trainer.textures.size()));
            }
        }
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
        if (this.getNickName().equalsIgnoreCase("")) {
            this.setNickName(ServerNPCRegistry.getRandomName());
        }
    }

    public void setNewTrade() {
        this.tradePair = PossibleTradeList.getRandomTrade();
    }

    @Override
    public void unloadEntity() {
        this.func_70106_y();
        this.func_241204_bJ_();
    }

    public ActionResultType func_233661_c_(PlayerEntity player, Hand hand) {
        if (player instanceof ServerPlayerEntity) {
            this.updateTradePair();
            ItemStack stack = player.func_184586_b(hand);
            int id = this.getNPCID();
            if (stack != null && stack.func_77973_b() == PixelmonItems.trainer_editor) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                NPCTrades.updateClientTradeData((ServerPlayerEntity)player, this.tradePair);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCTrade, id);
            } else {
                NPCTrades.showTrade((ServerPlayerEntity)player, this.tradePair, id);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTrade() {
        return this.tradePair != null;
    }

    public void updateTradePair() {
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.updateTradePair();
        nbt.func_218657_a("Offer", (INBT)this.tradePair.offer.write(new CompoundNBT()));
        nbt.func_218657_a("Exchange", (INBT)this.tradePair.exchange.write(new CompoundNBT()));
        if (this.tradePair.description != null) {
            nbt.func_74778_a("TradeDescription", this.tradePair.description);
        }
        nbt.func_74777_a("ModelIndex", (short)this.getBaseTrainer().id);
        if (this.getBaseTrainer().textures.size() > 1) {
            nbt.func_74768_a("TextureIndex", this.getTextureIndex());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ModelIndex")) {
            SYNC_MODEL.set((Entity)this, (Object)ServerNPCRegistry.trainers.getById(nbt.func_74765_d("ModelIndex")));
            if (this.getBaseTrainer().textures.size() > 1) {
                SYNC_TEXTURE_INDEX.set((Entity)this, (Object)nbt.func_74762_e("TextureIndex"));
            }
        }
        this.tradePair = new TradePair(PokemonSpecificationProxy.create("species:random"), PokemonSpecificationProxy.create("species:random"));
        if (nbt.func_74764_b("Exchange")) {
            PokemonSpecification requestedSpec = nbt.func_74781_a("Exchange") instanceof CompoundNBT ? PokemonSpecificationProxy.fromNbt(nbt.func_74775_l("Exchange")) : PokemonSpecificationProxy.create(nbt.func_74779_i("Exchange"));
            this.tradePair.exchange = requestedSpec;
        } else {
            this.tradePair.exchange = PokemonSpecificationProxy.create("species:random");
        }
        if (nbt.func_74764_b("Offer")) {
            PokemonSpecification offeredSpec = nbt.func_74781_a("Offer") instanceof CompoundNBT ? PokemonSpecificationProxy.fromNbt(nbt.func_74775_l("Offer")) : PokemonSpecificationProxy.create(nbt.func_74779_i("Offer"));
            this.tradePair.offer = offeredSpec;
        } else {
            this.tradePair.offer = PokemonSpecificationProxy.create("random");
        }
        if (nbt.func_74764_b("TradeDescription")) {
            this.tradePair.description = nbt.func_74779_i("TradeDescription");
        }
    }

    public void updateTrade(PokemonSpecification offer, PokemonSpecification exchange, @Nullable String description) {
        this.tradePair = new TradePair(offer, exchange, description);
    }

    @Override
    public String getDisplayText() {
        return I18n.func_135052_a((String)"pixelmon.npc.tradername", (Object[])new Object[0]);
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_220892_d.clear();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, Attributes.field_233821_d_.func_111110_b()));
                break;
            }
        }
    }

    @Override
    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }
}

