/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HealerEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.HealerTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;

public class NPCNurseJoy
extends NPCEntity {
    public NPCNurseJoy(EntityType<NPCNurseJoy> type, World world) {
        super(type, world);
    }

    public NPCNurseJoy(World world) {
        this((EntityType<NPCNurseJoy>)((EntityType)EntityRegistration.NPC_NURSE_JOY.get()), world);
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
        this.setTextureIndex(RandomHelper.getRandomNumberBetween(0, 1));
    }

    public NPCNurseJoy(World world, int texture) {
        this((EntityType<NPCNurseJoy>)((EntityType)EntityRegistration.NPC_NURSE_JOY.get()), world);
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
        this.setTextureIndex(texture);
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    @Override
    public String getTexture() {
        if (this.getTextureIndex() == 1) {
            return "pixelmon:textures/steve/nursejoy.png";
        }
        return "pixelmon:textures/steve/doctor.png";
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        if (player instanceof ServerPlayerEntity) {
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.NurseJoy, player))) {
                return false;
            }
            HealerTileEntity healer = BlockHelper.findClosestTileEntity(HealerTileEntity.class, (Entity)this, 8.0, h -> !h.beingUsed);
            if (healer != null) {
                if (!Pixelmon.EVENT_BUS.post((Event)new HealerEvent.Pre(player, healer.func_174877_v(), true))) {
                    Pokerus.informPlayer((ServerPlayerEntity)player);
                    healer.use(this, player);
                }
            } else {
                ChatHandler.sendChat((Entity)player, "gui.nursejoy.full", new Object[0]);
            }
        }
        return true;
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public Entity getEntity() {
        return super.getEntity();
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.initDefaultAI();
    }

    public boolean shouldRiderSit() {
        return super.shouldRiderSit();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return super.getPickedResult(target);
    }

    public boolean canRiderInteract() {
        return super.canRiderInteract();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return super.canBeRiddenInWater(rider);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        return super.getClassification(forSpawnCount);
    }

    public boolean isMultipartEntity() {
        return super.isMultipartEntity();
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return super.getParts();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }
}

