/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.ai.HarvestFarmLandGoal;
import com.pixelmonmod.pixelmon.ai.WanderGoal;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public abstract class NPCEntity
extends CreatureEntity
implements INPC {
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f SMALLER = new Vector3f(0.85f, 0.8f, 0.85f);
    private static final ThreadPool TEXTURE_LOADER = ThreadPool.createNewThreadPool("Texture Loader", 1);
    public static final int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 600;
    public static int intMaxTicksToDespawn = 1200;
    public static final DataSync<NPCEntity, String> SYNC_NAME = new DataSync<NPCEntity, String>(NPCEntity.class, DataSerializers.field_187194_d, (npcEntity, s) -> {
        npcEntity.name = s;
    });
    public static final DataSync<NPCEntity, String> SYNC_NICKNAME = new DataSync<NPCEntity, String>(NPCEntity.class, DataSerializers.field_187194_d, (npcEntity, s) -> {
        npcEntity.nickName = s;
    });
    public static final DataSync<NPCEntity, BaseTrainer> SYNC_MODEL = new DataSync<NPCEntity, BaseTrainer>(NPCEntity.class, PixelmonDataSerializers.BASE_TRAINER, (npcEntity, baseTrainer) -> {
        npcEntity.trainer = baseTrainer;
    });
    public static final DataSync<NPCEntity, Integer> SYNC_TEXTURE_INDEX = new DataSync<NPCEntity, Integer>(NPCEntity.class, DataSerializers.field_187192_b, (npcEntity, integer) -> {
        npcEntity.textureIndex = integer;
    });
    public static final DataSync<NPCEntity, String> SYNC_CUSTOM_STEVE_TEXTURE = new DataSync<NPCEntity, String>(NPCEntity.class, DataSerializers.field_187194_d, (npcEntity, s) -> {
        npcEntity.customSteveTexture = s;
    });
    public static final DataSync<NPCEntity, Integer> SYNC_PROFESSION = new DataSync<NPCEntity, Integer>(NPCEntity.class, DataSerializers.field_187192_b, (npcEntity, integer) -> {
        npcEntity.profession = integer;
    });
    private static final DataSync<NPCEntity, EnumTrainerAI> SYNC_NPC_AI = new DataSync<NPCEntity, EnumTrainerAI>(NPCEntity.class, PixelmonDataSerializers.TRAINER_AI, (npcEntity, enumTrainerAI) -> {
        npcEntity.trainerAI = enumTrainerAI;
        if (npcEntity.func_70661_as() != null && npcEntity.field_70714_bg != null) {
            npcEntity.initAI();
        }
    });
    private String name;
    private String nickName;
    private int npcID;
    protected BaseTrainer trainer;
    private int textureIndex;
    private String customSteveTexture;
    private int profession;
    private EnumTrainerAI trainerAI;
    public SpawnLocationType npcLocation;
    public int despawnCounter = -1;
    private Inventory npcInventory;
    protected int chatIndex;
    public ArrayList<String> interactCommands = new ArrayList();
    protected EntityDataSyncManager dataSyncManager;
    private int randomTickDivider;

    public NPCEntity(EntityType<? extends NPCEntity> type, World world) {
        super(type, world);
        this.npcInventory = new Inventory(8);
        this.initAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.define(SYNC_NAME, "");
        this.define(SYNC_NICKNAME, "");
        this.define(SYNC_MODEL, NPCRegistryTrainers.Steve);
        this.define(SYNC_TEXTURE_INDEX, 0);
        this.define(SYNC_CUSTOM_STEVE_TEXTURE, "youngster1");
        this.define(SYNC_PROFESSION, -1);
        this.define(SYNC_NPC_AI, EnumTrainerAI.Wander);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public void init(String name) {
        this.setName(name);
        this.func_70606_j(100.0f);
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        SYNC_NICKNAME.set((Entity)this, (Object)nickName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.getTextureIndex() == -1) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        BaseTrainer t = this.getBaseTrainer();
        if (t == null) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        if (t == NPCRegistryTrainers.Steve || t.name.equals("Steve")) {
            String textureName = t.textures.get(this.getTextureIndex());
            if (textureName.equals("Custom_PN") && this.getCustomSteveTexture().contains(";")) {
                String id = this.getCustomSteveTexture().split(";")[1];
                ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
                if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(rl) == null) {
                    try {
                        NativeImage image = NativeImage.func_195713_a((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                        if (image.func_195714_b() < 64) {
                            int y;
                            int x;
                            NativeImage resized = new NativeImage(image.func_195702_a(), image.func_195702_a(), false);
                            for (x = 0; x < image.func_195702_a(); ++x) {
                                for (y = 0; y < image.func_195714_b(); ++y) {
                                    resized.func_195700_a(x, y, image.func_195709_a(x, y));
                                }
                            }
                            for (x = 32; x < resized.func_195702_a(); ++x) {
                                for (y = 0; y < 16; ++y) {
                                    int rgb = resized.func_195709_a(x, y);
                                    if (rgb != -16777216) continue;
                                    resized.func_195700_a(x, y, 0);
                                }
                            }
                            for (x = 0; x < 16; ++x) {
                                for (y = 16; y < 32; ++y) {
                                    resized.func_195700_a(x + 16, y + 32, resized.func_195709_a(x, y));
                                }
                            }
                            for (x = 40; x < 56; ++x) {
                                for (y = 16; y < 32; ++y) {
                                    resized.func_195700_a(x - 8, y + 32, resized.func_195709_a(x, y));
                                }
                            }
                            image = resized;
                        }
                        Minecraft.func_71410_x().func_110434_K().func_229263_a_(rl, (Texture)new DynamicTexture(image));
                        return rl.toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()).toString();
                    }
                }
                return rl.toString();
            }
            if (textureName.equals("Custom_RP") && this.getCustomSteveTexture().equals("")) {
                return DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()).toString();
            }
            if (textureName.equals("Steve")) {
                return DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()).toString();
            }
        }
        if (!t.textures.isEmpty() && this.getTextureIndex() > -1) {
            if (this.getTextureIndex() >= t.textures.size()) {
                this.setTextureIndex(t.textures.size() - 1);
            }
            if (t.textures.get(this.getTextureIndex()).equals("Custom_RP")) {
                return "pixelmon:textures/steve/" + this.getCustomSteveTexture() + ".png";
            }
            return "pixelmon:textures/steve/" + t.textures.get(this.getTextureIndex()) + ".png";
        }
        if (this.getTextureIndex() == -1) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        if (t != NPCRegistryTrainers.Steve && !t.name.equals("Steve")) {
            return "pixelmon:textures/steve/" + t.name.toLowerCase(Locale.ROOT) + ".png";
        }
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
    }

    public String getCustomSteveTexture() {
        if (this.customSteveTexture == null || this.customSteveTexture.isEmpty()) {
            return "baker.png";
        }
        return this.customSteveTexture;
    }

    public void setCustomSteveTexture(String tex) {
        BaseTrainer trainer = this.getBaseTrainer();
        if (this.getTextureIndex() < 0 || trainer.textures.size() <= this.getTextureIndex()) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)tex);
            return;
        }
        String textureName = trainer.textures.get(this.getTextureIndex());
        if (textureName == null || !textureName.equals("Custom_PN")) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)tex);
            return;
        }
        TEXTURE_LOADER.submit(() -> {
            try {
                String texture = this.getBase64Texture(tex);
                this.func_184102_h().func_213167_f(() -> SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)(tex + ";" + texture)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getBase64Texture(String name) throws IOException {
        String base64;
        if (name == null || name.trim().isEmpty()) {
            return "dc1c77ce8e54925ab58125446ec53b0cdd3d0ca3db273eb908d5482787ef4016";
        }
        GameProfile profile = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152655_a(name);
        if (profile == null) {
            return "dc1c77ce8e54925ab58125446ec53b0cdd3d0ca3db273eb908d5482787ef4016";
        }
        if (!profile.getProperties().isEmpty()) {
            base64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).getValue();
        } else {
            InputStream is = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + profile.getId().toString().replace("-", "")).openConnection().getInputStream();
            base64 = new JsonParser().parse((Reader)new InputStreamReader(is)).getAsJsonObject().getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
        }
        return new JsonParser().parse((Reader)new InputStreamReader(new ByteArrayInputStream(Base64.getDecoder().decode(base64)))).getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString().replace("http://textures.minecraft.net/texture/", "");
    }

    public boolean func_213397_c(double p_213397_1_) {
        return !this.func_104002_bU() && !this.func_213392_I();
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent(this.name);
    }

    public void setName(String name) {
        SYNC_NAME.set((Entity)this, (Object)name);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_180136_u() || par1DamageSource.func_76357_e()) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70039_c(CompoundNBT p_70039_1_) {
        return this.shouldSave() && super.func_70039_c(p_70039_1_);
    }

    public boolean shouldSave() {
        return this.func_70089_S() && (this.func_104002_bU() || PixelmonConfigProxy.getStorage().isWriteEntitiesToWorld() || super.func_213392_I());
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("Name", this.func_200200_C_().getString());
        if (this.npcLocation == null || this.npcLocation == SpawnLocationType.LAND) {
            this.npcLocation = SpawnLocationType.LAND_VILLAGER;
        }
        nbt.func_74768_a("trainerLocation", this.npcLocation.ordinal());
        nbt.func_74778_a("BaseTrainer", this.getBaseTrainer().name);
        if (this.getBaseTrainer() == NPCRegistryTrainers.Steve || this.getBaseTrainer().textures.size() > 1) {
            nbt.func_74768_a("TextureIndex", this.getTextureIndex());
        }
        nbt.func_74778_a("CustomSteveTexture", this.getCustomSteveTexture());
        nbt.func_74777_a("Profession", (short)this.getProfession());
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.npcInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.npcInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.add((Object)itemstack.serializeNBT());
        }
        nbt.func_218657_a("Inventory", (INBT)nbttaglist);
        nbt.func_74777_a("AIMode", (short)this.getAIMode().ordinal());
        CompoundNBT commandsNbt = new CompoundNBT();
        ListNBT interactList = new ListNBT();
        for (String interactCommand : this.interactCommands) {
            interactList.add((Object)StringNBT.func_229705_a_((String)interactCommand));
        }
        commandsNbt.func_218657_a("interactCommands", (INBT)interactList);
        nbt.func_218657_a("Commands", (INBT)commandsNbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        CompoundNBT cmdNbt;
        super.func_70037_a(nbt);
        this.setName(nbt.func_74779_i("Name"));
        if (nbt.func_74764_b("trainerLocation")) {
            this.npcLocation = SpawnLocationType.getFromIndex(nbt.func_74762_e("trainerLocation"));
            if (this.npcLocation == null) {
                this.npcLocation = SpawnLocationType.LAND_VILLAGER;
            }
        } else {
            this.npcLocation = SpawnLocationType.LAND;
        }
        this.init(this.func_200200_C_().getString());
        BaseTrainer trainer = null;
        if (nbt.func_74764_b("ModelIndex")) {
            trainer = ServerNPCRegistry.trainers.getById(nbt.func_74762_e("ModelIndex"));
        } else if (nbt.func_74764_b("BaseTrainer")) {
            trainer = NPCRegistryTrainers.getByName(nbt.func_74779_i("BaseTrainer"));
        }
        if (trainer != null) {
            this.setBaseTrainer(trainer);
            if (this.getBaseTrainer().textures.size() > 1) {
                this.setTextureIndex(nbt.func_74762_e("TextureIndex"));
            }
        }
        if (nbt.func_74779_i("CustomSteveTexture").contains(";")) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)nbt.func_74779_i("CustomSteveTexture"));
        } else {
            this.setCustomSteveTexture(nbt.func_74779_i("CustomSteveTexture"));
        }
        this.setProfession(nbt.func_74765_d("Profession"));
        ListNBT nbttaglist = nbt.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.npcInventory.func_174894_a(itemstack);
        }
        if (this.getProfession() == 0) {
            this.initVilagerAI();
            this.field_70714_bg.func_75776_a(6, (Goal)new HarvestFarmLandGoal(this, 0.6));
        }
        if (nbt.func_74764_b("IsPersistent") && nbt.func_74767_n("IsPersistent")) {
            this.func_110163_bv();
        }
        if (nbt.func_74764_b("AIMode")) {
            this.setAIMode(EnumTrainerAI.getFromOrdinal(nbt.func_74765_d("AIMode")));
            this.initAI();
        }
        if (nbt.func_74764_b("Commands") && (cmdNbt = nbt.func_74775_l("Commands")).func_74764_b("interactCommands")) {
            ListNBT wins = cmdNbt.func_150295_c("interactCommands", 8);
            for (int i = 0; i < wins.size(); ++i) {
                this.interactCommands.add(wins.func_150307_f(i));
            }
        }
    }

    public void initAI() {
        this.initDefaultAI();
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        int var3;
        int var2;
        int var1 = MathHelper.func_76128_c((double)this.func_226277_ct_());
        Block block = this.field_70170_p.func_180495_p(new BlockPos(var1, (var2 = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b)) - 1, var3 = MathHelper.func_76128_c((double)this.func_226281_cx_()))).func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150354_m;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vector, Hand hand) {
        return this.interactWithNPC(player, hand) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public int getNPCID() {
        return this.func_145782_y();
    }

    public abstract String getDisplayText();

    public String getSubTitleText() {
        return null;
    }

    public BossTier getBossTier() {
        return BossTierRegistry.NOT_BOSS;
    }

    public BaseTrainer getBaseTrainer() {
        return this.trainer;
    }

    public void setBaseTrainer(BaseTrainer trainer) {
        SYNC_MODEL.set((Entity)this, (Object)trainer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean bindTexture() {
        block19: {
            String textureName;
            block20: {
                block21: {
                    if (this.getTextureIndex() == -1) {
                        return false;
                    }
                    BaseTrainer t = this.getBaseTrainer();
                    if (t != NPCRegistryTrainers.Steve && !t.name.equals("Steve")) break block19;
                    textureName = t.textures.get(this.getTextureIndex());
                    if (textureName.equals("Custom_PN") && this.getCustomSteveTexture().contains(";")) {
                        String id = this.getCustomSteveTexture().split(";")[1];
                        ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
                        if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(rl) == null) {
                            try {
                                NativeImage image = NativeImage.func_195713_a((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                                if (image.func_195714_b() < 64) {
                                    int y;
                                    int x;
                                    NativeImage resized = new NativeImage(image.func_195702_a(), image.func_195702_a(), false);
                                    for (x = 0; x < image.func_195702_a(); ++x) {
                                        for (y = 0; y < image.func_195714_b(); ++y) {
                                            resized.func_195700_a(x, y, image.func_195709_a(x, y));
                                        }
                                    }
                                    for (x = 32; x < resized.func_195702_a(); ++x) {
                                        for (y = 0; y < 16; ++y) {
                                            int rgb = resized.func_195709_a(x, y);
                                            if (rgb != -16777216) continue;
                                            resized.func_195700_a(x, y, 0);
                                        }
                                    }
                                    for (x = 0; x < 16; ++x) {
                                        for (y = 16; y < 32; ++y) {
                                            resized.func_195700_a(x + 16, y + 32, resized.func_195709_a(x, y));
                                        }
                                    }
                                    for (x = 40; x < 56; ++x) {
                                        for (y = 16; y < 32; ++y) {
                                            resized.func_195700_a(x - 8, y + 32, resized.func_195709_a(x, y));
                                        }
                                    }
                                    image = resized;
                                }
                                Minecraft.func_71410_x().func_110434_K().func_229263_a_(rl, (Texture)new DynamicTexture(image));
                                Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                Minecraft.func_71410_x().func_110434_K().func_110577_a(DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()));
                            }
                        } else {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                        }
                        return true;
                    }
                    if (!textureName.equals("Custom_RP")) break block20;
                    if (this.getCustomSteveTexture().equals("")) break block21;
                    if (CommonProxy.resourceLocationExists(ResourceLocationHelper.of(this.getTexture()))) break block20;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()));
                return true;
            }
            if (textureName.equals("Steve")) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()));
                return true;
            }
        }
        return false;
    }

    public Vector3f getModelScale() {
        BaseTrainer base = this.getBaseTrainer();
        if (base != null && (base.name.equals("Youngster") || base.name.equals("Lass") || base.name.equals("PreschoolerGirl"))) {
            return SMALLER;
        }
        return ONE;
    }

    public static <T extends NPCEntity> Optional<T> locateNPCClient(World world, int id, Class<T> type) {
        Entity entityByID = world.func_73045_a(id);
        if (!type.isInstance(entityByID)) {
            return Optional.empty();
        }
        return Optional.of((NPCEntity)entityByID);
    }

    public static <T extends NPCEntity> Optional<T> locateNPCServer(World world, int id, Class<T> type) {
        Entity entityByID = world.func_73045_a(id);
        if (!type.isInstance(entityByID)) {
            return Optional.empty();
        }
        return Optional.of((NPCEntity)entityByID);
    }

    public static <T extends NPCEntity> Optional<T> locateNPCServer(World world, String name, Class<T> type, String langCode) {
        List entities = ((ServerWorld)world).getEntities().collect(Collectors.toList());
        for (int i = 0; i < entities.size(); ++i) {
            String npcName;
            Entity entity = (Entity)entities.get(i);
            if (!type.isInstance(entity) || !name.equals(npcName = type == NPCTrainer.class ? ((NPCTrainer)entity).getName(langCode) : ((NPCEntity)entity).func_200200_C_().getString())) continue;
            return Optional.of((NPCEntity)entity);
        }
        return Optional.empty();
    }

    public void unloadEntity() {
        this.func_70106_y();
        this.func_241204_bJ_();
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public void setTextureIndex(int index) {
        SYNC_TEXTURE_INDEX.set((Entity)this, (Object)index);
    }

    public void func_70071_h_() {
        if (this.func_213397_c(0.0) && !this.field_70170_p.field_72995_K) {
            this.checkForRarityDespawn();
        }
        try {
            super.func_70071_h_();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void checkForRarityDespawn() {
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                this.func_241204_bJ_();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    protected boolean playersNearby() {
        for (int i = 0; i < this.field_70170_p.func_217369_A().size(); ++i) {
            double distancez;
            double distancey;
            PlayerEntity player = (PlayerEntity)this.field_70170_p.func_217369_A().get(i);
            double distancex = player.func_226277_ct_() - this.func_226277_ct_();
            double distancesquared = distancex * distancex + (distancey = player.func_226278_cu_() - this.func_226278_cu_()) * distancey + (distancez = player.func_226281_cx_() - this.func_226281_cx_()) * distancez;
            if (!(distancesquared < (double)(PixelmonConfigProxy.getSpawning().getDespawnRadius() * PixelmonConfigProxy.getSpawning().getDespawnRadius()))) continue;
            return true;
        }
        return false;
    }

    public void setProfession(int professionId) {
        SYNC_PROFESSION.set((Entity)this, (Object)professionId);
    }

    public int getProfession() {
        return this.profession;
    }

    public void initDefaultAI() {
        this.func_70661_as().func_212239_d(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public void initWanderingAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WanderGoal(this));
    }

    public void initVilagerAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, (double)0.8f, (double)0.6f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.func_98053_h(true);
    }

    public boolean isFarmItemInInventory() {
        for (int i = 0; i < this.npcInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.npcInventory.func_70301_a(i);
            if (itemstack == null || itemstack.func_77973_b() != Items.field_151014_N && itemstack.func_77973_b() != Items.field_151174_bG && itemstack.func_77973_b() != Items.field_151172_bF) continue;
            return true;
        }
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int j = inventorySlot - 300;
        if (j >= 0 && j < this.npcInventory.func_70302_i_()) {
            this.npcInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public boolean hasItemToPlant() {
        boolean flag;
        boolean bl = flag = this.getProfession() == 0;
        return flag ? !this.hasEnoughItems(5) : !this.hasEnoughItems(1);
    }

    private boolean hasEnoughItems(int multiplier) {
        boolean flag = this.getProfession() == 0;
        for (int j = 0; j < this.npcInventory.func_70302_i_(); ++j) {
            ItemStack itemstack = this.npcInventory.func_70301_a(j);
            if (itemstack == null) continue;
            if (itemstack.func_77973_b() == Items.field_151025_P && itemstack.func_190916_E() >= 3 * multiplier || itemstack.func_77973_b() == Items.field_151174_bG && itemstack.func_190916_E() >= 12 * multiplier || itemstack.func_77973_b() == Items.field_151172_bF && itemstack.func_190916_E() >= 12 * multiplier) {
                return true;
            }
            if (!flag || itemstack.func_77973_b() != Items.field_151015_O || itemstack.func_190916_E() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    public Inventory getNPCInventory() {
        return this.npcInventory;
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemstack1 = this.npcInventory.func_174894_a(itemstack);
            if (itemstack1 == null) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    private boolean canVillagerPickupItem(Item itemIn) {
        return itemIn == Items.field_151025_P || itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public EnumTrainerAI getAIMode() {
        if (this.trainerAI == null) {
            SYNC_NPC_AI.set((Entity)this, (Object)EnumTrainerAI.Wander);
        }
        return this.trainerAI;
    }

    public void setAIMode(EnumTrainerAI mode) {
        SYNC_NPC_AI.set((Entity)this, (Object)mode);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

