/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SpawningStrategy
extends WikiCommandStrategy {
    public SpawningStrategy() {
        super("spawning");
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        List<SpawnInfoPokemon> standardSpawnInfos;
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.BOLD})), false);
        Map<String, List<SpawnSet>> spawnSets = PixelmonSpawning.getAll();
        ArrayList standard = Lists.newArrayList();
        if (spawnSets.containsKey("standard")) {
            standard.addAll((Collection)spawnSets.remove("standard"));
        }
        if (spawnSets.containsKey("legendaries")) {
            standard.addAll((Collection)spawnSets.remove("legendaries"));
        }
        if (!(standardSpawnInfos = SpawningStrategy.getSpawnInfo(pokemon, standard)).isEmpty()) {
            SpawningStrategy.sendBiomeMessage(sender, standardSpawnInfos, "standard");
        }
        boolean anyBiome = false;
        for (Map.Entry<String, List<SpawnSet>> entry : spawnSets.entrySet()) {
            List<SpawnInfoPokemon> spawnInfos;
            if (entry.getKey().equalsIgnoreCase("npc") || entry.getKey().equalsIgnoreCase("megas") || (spawnInfos = SpawningStrategy.getSpawnInfo(pokemon, entry.getValue())).isEmpty()) continue;
            anyBiome = true;
            sender.func_197030_a((ITextComponent)new StringTextComponent(""), false);
            SpawningStrategy.sendBiomeMessage(sender, spawnInfos, entry.getKey());
        }
        if (standardSpawnInfos.isEmpty() && !anyBiome) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.nobiome", new Object[0]), false);
        }
    }

    private static void sendBiomeMessage(CommandSource sender, List<SpawnInfoPokemon> spawnInfos, String name) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning." + name, new Object[0]), false);
        for (SpawnInfoPokemon spawnInfo : spawnInfos) {
            String biomes = spawnInfo.condition.biomes.stream().map(biome -> biome.toString()).collect(Collectors.joining(", "));
            sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)new TranslationTextComponent("pixelmon.command.wiki.spawning.spec")).func_230529_a_((ITextComponent)new StringTextComponent(spawnInfo.getPokemonSpec().toString())), false);
            if (biomes.isEmpty()) {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.nospawnsinbiome", new Object[0]), false);
            } else {
                sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)new TranslationTextComponent("pixelmon.command.wiki.spawning.biomes")).func_230529_a_((ITextComponent)PixelmonCommandUtils.format(biomes, new Object[0])), false);
            }
            sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)SpawningStrategy.getRarityFormatted(spawnInfo.rarity)), false);
            if (spawnInfo.condition.cachedWeathers != null && !spawnInfo.condition.cachedWeathers.isEmpty()) {
                sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.weather", spawnInfo.condition.cachedWeathers.stream().map(WeatherType::getLocalizedName).collect(Collectors.joining(", ")))), false);
            }
            if (spawnInfo.condition.times == null || spawnInfo.condition.times.isEmpty()) continue;
            sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.time", spawnInfo.condition.times.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", ")))), false);
        }
    }

    private static List<SpawnInfoPokemon> getSpawnInfo(Pokemon pokemon, List<SpawnSet> spawnSets) {
        ArrayList spawnInfos = Lists.newArrayList();
        for (SpawnSet spawnSet : spawnSets) {
            for (SpawnInfo spawnInfo : spawnSet.spawnInfos) {
                SpawnInfoPokemon spawnInfoPokemon;
                if (!(spawnInfo instanceof SpawnInfoPokemon) || (spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo).getSpecies() == null || spawnInfoPokemon.getSpecies().getDex() != pokemon.getSpecies().getDex()) continue;
                spawnInfos.add(spawnInfoPokemon);
            }
        }
        return spawnInfos;
    }

    private static IFormattableTextComponent getRarityFormatted(float rarity) {
        String rarityKey = "pixelmon.command.wiki.spawning.rarity.";
        rarityKey = (double)rarity <= 10.0 ? rarityKey + "ultra_rare" : ((double)rarity <= 25.0 ? rarityKey + "very_rare" : ((double)rarity <= 50.0 ? rarityKey + "rare" : ((double)rarity <= 200.0 ? rarityKey + "uncommon" : rarityKey + "common")));
        return PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.rarity", new Object[0]).func_230529_a_((ITextComponent)TextHelper.space(1)).func_230529_a_((ITextComponent)PixelmonCommandUtils.format(rarityKey, new Object[0]));
    }
}

