/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TradeSimCommand
extends PixelCommand {
    public TradeSimCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "tradesim", "/tradesim [player] <slot> [simulated]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.pokeedit.slot", new Object[0]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", target.func_200200_C_());
        String name = "Magikarp";
        if (args.length == 3 && !PixelmonSpecies.get(name = args[2]).isPresent()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.tradesim.unknown", new Object[0]);
        }
        if (pokemon.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.tradesim.egg", new Object[0]);
        }
        if (pokemon.hasFlag("untradeable") && !PixelmonCommandUtils.hasPermission(sender, "pixelmon.tradesim.bypass.untradeable")) {
            PixelmonCommandUtils.endCommand("pixelmon.command.tradesim.untradeable", new Object[0]);
        }
        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        pixelmon.testTradeEvolution(PixelmonSpecies.get(name).get().getValueUnsafe());
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.tradesim.success", new Object[0]), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

